/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.NavSource;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.pom.Navigatable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0003%&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fJ\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator;", "", "source", "Lcom/android/tools/idea/codenavigation/NavSource;", "executor", "Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "<init>", "(Lcom/android/tools/idea/codenavigation/NavSource;Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;)V", "mySource", "getMySource$annotations", "()V", "getMySource", "()Lcom/android/tools/idea/codenavigation/NavSource;", "myListeners", "", "Lcom/android/tools/idea/codenavigation/CodeNavigator$Listener;", "cpuArchSource", "Ljava/util/function/Supplier;", "", "getCpuArchSource", "()Ljava/util/function/Supplier;", "setCpuArchSource", "(Ljava/util/function/Supplier;)V", "addListener", "", "listener", "removeListener", "navigate", "Ljava/util/concurrent/CompletableFuture;", "", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "isNavigatableAsync", "isNavigatable", "getNavigatableAsync", "Lcom/intellij/pom/Navigatable;", "getNavigatable", "Executor", "Companion", "Listener", "codenavigation"})
@SourceDebugExtension(value={"SMAP\nCodeNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeNavigator.kt\ncom/android/tools/idea/codenavigation/CodeNavigator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1869#2,2:135\n*S KotlinDebug\n*F\n+ 1 CodeNavigator.kt\ncom/android/tools/idea/codenavigation/CodeNavigator\n*L\n88#1:135,2\n*E\n"})
public final class CodeNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor executor;
    @NotNull
    private final NavSource mySource;
    @NotNull
    private final List<Listener> myListeners;
    @NotNull
    private Supplier<String> cpuArchSource;
    @NotNull
    private static final Executor applicationExecutor = new Executor(){

        public void onForeground(Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            ApplicationManager.getApplication().invokeLater(runnable2);
        }

        public Future<?> onBackground(Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(runnable2);
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"executeOnPooledThread(...)");
            return future2;
        }
    };
    @NotNull
    private static final Executor testExecutor = new Executor(){

        public void onForeground(Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            runnable2.run();
        }

        public Future<?> onBackground(Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable2);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
            return completableFuture;
        }
    };

    public CodeNavigator(@NotNull NavSource source2, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.mySource = source2;
        this.myListeners = new ArrayList();
        this.cpuArchSource = CodeNavigator::cpuArchSource$lambda$0;
    }

    @NotNull
    public final NavSource getMySource() {
        return this.mySource;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMySource$annotations() {
    }

    @NotNull
    public final Supplier<String> getCpuArchSource() {
        return this.cpuArchSource;
    }

    public final void setCpuArchSource(@NotNull Supplier<String> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"<set-?>");
        this.cpuArchSource = supplier;
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myListeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myListeners.remove(listener2);
    }

    @Nullable
    public final CompletableFuture<Boolean> navigate(@NotNull CodeLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Iterable $this$forEach$iv = this.myListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onNavigated(location);
        }
        return this.getNavigatableAsync(location).thenApplyAsync(arg_0 -> CodeNavigator.navigate$lambda$3(CodeNavigator::navigate$lambda$2, arg_0), arg_0 -> CodeNavigator.navigate$lambda$4(this, arg_0));
    }

    @NotNull
    public final CompletableFuture<Boolean> isNavigatableAsync(@NotNull CodeLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CompletionStage completionStage = this.getNavigatableAsync(location).thenApply(arg_0 -> CodeNavigator.isNavigatableAsync$lambda$7(CodeNavigator::isNavigatableAsync$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    public final boolean isNavigatable(@NotNull CodeLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Navigatable navigatable2 = this.getNavigatable(location);
        return navigatable2 != null ? navigatable2.canNavigateToSource() : false;
    }

    private final CompletableFuture<Navigatable> getNavigatableAsync(CodeLocation location) {
        CompletableFuture<Navigatable> completableFuture = CompletableFuture.supplyAsync(() -> CodeNavigator.getNavigatableAsync$lambda$8(this, location), arg_0 -> CodeNavigator.getNavigatableAsync$lambda$9(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private final Navigatable getNavigatable(CodeLocation location) {
        return (Navigatable)ReadAction.compute(() -> CodeNavigator.getNavigatable$lambda$10(this, location));
    }

    private static final String cpuArchSource$lambda$0() {
        return null;
    }

    private static final Boolean navigate$lambda$2(Navigatable nav) {
        block0: {
            Navigatable navigatable2 = nav;
            if (navigatable2 == null) break block0;
            navigatable2.navigate(true);
        }
        return nav != null;
    }

    private static final Boolean navigate$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void navigate$lambda$4(CodeNavigator this$0, Runnable runnable2) {
        Executor executor = this$0.executor;
        Runnable runnable3 = runnable2;
        Intrinsics.checkNotNull((Object)runnable3);
        executor.onForeground(runnable3);
    }

    private static final Boolean isNavigatableAsync$lambda$6$lambda$5(Navigatable $nav) {
        Navigatable navigatable2 = $nav;
        return navigatable2 != null ? navigatable2.canNavigateToSource() : false;
    }

    private static final Boolean isNavigatableAsync$lambda$6(Navigatable nav) {
        return (Boolean)ReadAction.compute(() -> CodeNavigator.isNavigatableAsync$lambda$6$lambda$5(nav));
    }

    private static final Boolean isNavigatableAsync$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Navigatable getNavigatableAsync$lambda$8(CodeNavigator this$0, CodeLocation $location) {
        return this$0.getNavigatable($location);
    }

    private static final void getNavigatableAsync$lambda$9(CodeNavigator this$0, Runnable runnable2) {
        Executor executor = this$0.executor;
        Runnable runnable3 = runnable2;
        Intrinsics.checkNotNull((Object)runnable3);
        executor.onBackground(runnable3);
    }

    private static final Navigatable getNavigatable$lambda$10(CodeNavigator this$0, CodeLocation $location) {
        return this$0.mySource.lookUp($location, this$0.cpuArchSource.get());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator$Companion;", "", "<init>", "()V", "applicationExecutor", "Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "getApplicationExecutor", "()Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "testExecutor", "getTestExecutor", "codenavigation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Executor getApplicationExecutor() {
            return applicationExecutor;
        }

        @NotNull
        public final Executor getTestExecutor() {
            return testExecutor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0014\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator$Executor;", "", "onForeground", "", "runnable", "Ljava/lang/Runnable;", "onBackground", "Ljava/util/concurrent/Future;", "codenavigation"})
    public static interface Executor {
        public void onForeground(@NotNull Runnable var1);

        @NotNull
        public Future<?> onBackground(@NotNull Runnable var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/codenavigation/CodeNavigator$Listener;", "", "onNavigated", "", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "codenavigation"})
    public static interface Listener {
        public void onNavigated(@NotNull CodeLocation var1);
    }
}

