/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CodeLocation {
    public static final int INVALID_LINE_NUMBER = -1;
    @Nullable
    private final String myClassName;
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myMethodName;
    @Nullable
    private final String mySignature;
    @Nullable
    private final List<String> myMethodParameters;
    private final int myLineNumber;
    private final boolean myNativeCode;
    private final long myNativeVAddress;
    @Nullable
    private final String myNativeModuleName;
    @Nullable
    private final String myFullComposableName;

    private CodeLocation(@NotNull Builder builder) {
        this.myClassName = builder.myClassName;
        this.myFileName = builder.myFileName;
        this.myMethodName = builder.myMethodName;
        this.mySignature = builder.mySignature;
        this.myMethodParameters = builder.myMethodParameters;
        this.myLineNumber = builder.myLineNumber;
        this.myNativeCode = builder.myNativeCode;
        this.myNativeVAddress = builder.myNativeVAddress;
        this.myNativeModuleName = builder.myNativeModuleName;
        this.myFullComposableName = builder.myFullComposableName;
    }

    @TestOnly
    @NotNull
    public static CodeLocation stub() {
        return new Builder("").build();
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getMethodName() {
        return this.myMethodName;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Nullable
    public String getSignature() {
        return this.mySignature;
    }

    @Nullable
    public List<String> getMethodParameters() {
        return this.myMethodParameters == null ? null : new ArrayList<String>(this.myMethodParameters);
    }

    public boolean isNativeCode() {
        return this.myNativeCode;
    }

    public long getNativeVAddress() {
        return this.myNativeVAddress;
    }

    @Nullable
    public String getNativeModuleName() {
        return this.myNativeModuleName;
    }

    @Nullable
    public String getFullComposableName() {
        return this.myFullComposableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeLocation location = (CodeLocation)o;
        return this.myLineNumber == location.myLineNumber && this.myNativeCode == location.myNativeCode && this.myNativeVAddress == location.myNativeVAddress && Objects.equals(this.myClassName, location.myClassName) && Objects.equals(this.myFileName, location.myFileName) && Objects.equals(this.myMethodName, location.myMethodName) && Objects.equals(this.mySignature, location.mySignature) && Objects.equals(this.myMethodParameters, location.myMethodParameters) && Objects.equals(this.myNativeModuleName, location.myNativeModuleName) && Objects.equals(this.myFullComposableName, location.myFullComposableName);
    }

    public int hashCode() {
        return Objects.hash(this.myClassName, this.myFileName, this.myMethodName, this.mySignature, this.myMethodParameters, this.myLineNumber, this.myNativeCode, this.myNativeVAddress, this.myNativeModuleName, this.myFullComposableName);
    }

    @NotNull
    public String getOuterClass() {
        if (this.myClassName == null) {
            return "";
        }
        int innerCharIndex = this.myClassName.indexOf(36);
        return innerCharIndex < 0 ? this.myClassName : this.myClassName.substring(0, innerCharIndex);
    }

    public static final class Builder {
        @Nullable
        private final String myClassName;
        @Nullable
        String myFileName;
        @Nullable
        String myMethodName;
        @Nullable
        String mySignature;
        @Nullable
        List<String> myMethodParameters;
        int myLineNumber = -1;
        boolean myNativeCode;
        long myNativeVAddress = -1L;
        @Nullable
        String myNativeModuleName;
        @Nullable
        String myFullComposableName;

        public Builder(@Nullable String className) {
            this.myClassName = className;
        }

        public Builder(@NotNull CodeLocation rhs) {
            this.myClassName = rhs.getClassName();
            this.myFileName = rhs.getFileName();
            this.myMethodName = rhs.getMethodName();
            this.mySignature = rhs.getSignature();
            this.myMethodParameters = rhs.getMethodParameters();
            this.myLineNumber = rhs.getLineNumber();
            this.myNativeCode = rhs.myNativeCode;
            this.myNativeVAddress = rhs.myNativeVAddress;
            this.myNativeModuleName = rhs.myNativeModuleName;
            this.myFullComposableName = rhs.myFullComposableName;
        }

        @NotNull
        public Builder setFileName(@Nullable String fileName) {
            this.myFileName = StringUtil.nullize((String)fileName);
            return this;
        }

        @NotNull
        public Builder setMethodName(@Nullable String methodName) {
            this.myMethodName = StringUtil.nullize((String)methodName);
            return this;
        }

        @NotNull
        public Builder setMethodSignature(@NotNull String signature) {
            this.mySignature = signature;
            return this;
        }

        @NotNull
        public Builder setMethodParameters(@NotNull List<String> methodParameters) {
            this.myMethodParameters = methodParameters;
            return this;
        }

        @NotNull
        public Builder setLineNumber(int lineNumber) {
            this.myLineNumber = lineNumber;
            return this;
        }

        public Builder setNativeCode(boolean nativeCode) {
            this.myNativeCode = nativeCode;
            return this;
        }

        public Builder setNativeVAddress(long nativeVAddress) {
            this.myNativeVAddress = nativeVAddress;
            return this;
        }

        public Builder setNativeModuleName(String name2) {
            this.myNativeModuleName = name2;
            return this;
        }

        public Builder setFullComposableName(String name2) {
            this.myFullComposableName = name2;
            return this;
        }

        @NotNull
        public CodeLocation build() {
            return new CodeLocation(this);
        }
    }
}

