/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.backup.BackupProgressListener;
import com.android.tools.idea.actions.ActionUtils;
import com.android.tools.idea.backup.ActionHelper;
import com.android.tools.idea.backup.ActionHelperImpl;
import com.android.tools.idea.backup.BackupBundle;
import com.android.tools.idea.backup.BackupManager;
import com.android.tools.idea.backup.DeviceChecker;
import com.android.tools.idea.backup.DialogFactory;
import com.android.tools.idea.backup.DialogFactoryImpl;
import com.android.tools.idea.backup.RestoreAppActionGroup;
import com.android.tools.idea.backup.UtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.progress.ContextKt;
import com.intellij.platform.util.progress.SequentialProgressReporter;
import com.intellij.platform.util.progress.SequentialProgressReporterHandle;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0013\u001a\u00020\r*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/backup/RestoreAppAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "config", "Lcom/android/tools/idea/backup/RestoreAppAction$Config;", "actionHelper", "Lcom/android/tools/idea/backup/ActionHelper;", "dialogFactory", "Lcom/android/tools/idea/backup/DialogFactory;", "<init>", "(Lcom/android/tools/idea/backup/RestoreAppAction$Config;Lcom/android/tools/idea/backup/ActionHelper;Lcom/android/tools/idea/backup/DialogFactory;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getDeviceSerialNumber", "", "showDialog", "Lcom/intellij/openapi/project/Project;", "message", "Config", "intellij.android.backup"})
public final class RestoreAppAction
extends AnAction {
    @NotNull
    private final Config config;
    @NotNull
    private final ActionHelper actionHelper;
    @NotNull
    private final DialogFactory dialogFactory;

    public RestoreAppAction(@NotNull Config config, @NotNull ActionHelper actionHelper, @NotNull DialogFactory dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)actionHelper, (String)"actionHelper");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        this.config = config;
        this.actionHelper = actionHelper;
        this.dialogFactory = dialogFactory;
    }

    public /* synthetic */ RestoreAppAction(Config config, ActionHelper actionHelper, DialogFactory dialogFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Standalone.INSTANCE;
        }
        if ((n & 2) != 0) {
            actionHelper = new ActionHelperImpl();
        }
        if ((n & 4) != 0) {
            dialogFactory = new DialogFactoryImpl();
        }
        this(config, actionHelper, dialogFactory);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!((Boolean)StudioFlags.BACKUP_ENABLED.get()).booleanValue()) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (Intrinsics.areEqual((Object)this.config, (Object)Config.Standalone.INSTANCE) && RestoreAppActionGroup.Companion.showGroup(project2)) {
            return;
        }
        boolean ok2 = DeviceChecker.Companion.checkEventDeviceType(this, e);
        if (!ok2) {
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setIcon(this.config.getPresentation().getIcon());
        e.getPresentation().setText(this.config.getPresentation().getText());
        e.getPresentation().setDescription(this.config.getPresentation().getDescription());
        if ((Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainToolbar") || Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainMenu")) && this.actionHelper.getDeployTargetCount(project2) != 1) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            ActionUtils.enableRichTooltip((Presentation)presentation, (AnAction)this, (String)BackupBundle.message("error.multiple.devices", new Object[0]));
            return;
        }
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String serialNumber = this.getDeviceSerialNumber(e);
        if (serialNumber == null) {
            this.showDialog(project2, BackupBundle.message("error.device.not.running", new Object[0]));
            return;
        }
        BackupManager backupManager = BackupManager.Companion.getInstance(project2);
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.project((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"project(...)");
        boolean ok2 = (Boolean)TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)"Collecting Data", (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(backupManager, serialNumber, this, project2, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ BackupManager $backupManager;
            final /* synthetic */ String $serialNumber;
            final /* synthetic */ RestoreAppAction this$0;
            final /* synthetic */ Project $project;
            {
                this.$backupManager = $backupManager;
                this.$serialNumber = $serialNumber;
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = this.$backupManager;
                        var4_4 = this.$serialNumber;
                        var5_5 = this.this$0;
                        var6_6 = this.$project;
                        size$iv = 100;
                        $i$f$reportSequentialProgress = false;
                        this.L$0 = var3_3;
                        this.L$1 = var4_4;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.label = 1;
                        v0 = ContextKt.internalCurrentStepAsSequential((int)size$iv, (Continuation)((Continuation)this));
                        if (v0 == var16_2) {
                            return var16_2;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        $i$f$reportSequentialProgress = false;
                        var6_6 = (Project)this.L$3;
                        var5_5 = (RestoreAppAction)this.L$2;
                        var4_4 = (String)this.L$1;
                        var3_3 = (BackupManager)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 2 sources

                        var8_11 = (AutoCloseable)v0;
                        var9_12 = null;
                        it$iv = (SequentialProgressReporterHandle)var8_11;
                        $i$a$-use-StepsKt$reportSequentialProgress$2$iv = false;
                        reporter = it$iv.getReporter();
                        $i$a$-reportSequentialProgress$default-RestoreAppAction$actionPerformed$ok$1$1 = false;
                        steps = 2;
                        step = new Ref.IntRef();
                        this.L$0 = var8_11;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(reporter, step, steps, var3_3, var4_4, var5_5, var6_6, null){
                            int label;
                            final /* synthetic */ SequentialProgressReporter $reporter;
                            final /* synthetic */ Ref.IntRef $step;
                            final /* synthetic */ int $steps;
                            final /* synthetic */ BackupManager $backupManager;
                            final /* synthetic */ String $serialNumber;
                            final /* synthetic */ RestoreAppAction this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.$reporter = $reporter;
                                this.$step = $step;
                                this.$steps = $steps;
                                this.$backupManager = $backupManager;
                                this.$serialNumber = $serialNumber;
                                this.this$0 = $receiver;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        ++this.$step.element;
                                        UtilsKt.onStep(this.$reporter, new BackupProgressListener.Step(this.$step.element, this.$steps, "Checking device..."));
                                        this.label = 1;
                                        v0 = this.$backupManager.checkDevice(this.$serialNumber, (Continuation<? super String>)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        if ((result = (String)v0) != null) {
                                            RestoreAppAction.access$showDialog(this.this$0, this.$project, result);
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        return Boxing.boxBoolean((boolean)true);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        ** if (v1 != var16_2) goto lbl46
lbl45:
                        // 1 sources

                        return var16_2;
lbl46:
                        // 1 sources

                        ** GOTO lbl58
                    }
                    case 2: {
                        $i$f$reportSequentialProgress = false;
                        $i$a$-use-StepsKt$reportSequentialProgress$2$iv = false;
                        $i$a$-reportSequentialProgress$default-RestoreAppAction$actionPerformed$ok$1$1 = false;
                        var9_12 = null;
                        var8_11 = (AutoCloseable)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl58:
                            // 2 sources

                            var10_13 = Boxing.boxBoolean((boolean)((Boolean)v1));
                            ** GOTO lbl68
                        }
                        catch (Throwable var11_16) {
                            var9_12 = var11_16;
                            throw var11_16;
                        }
                    }
                    catch (Throwable var11_17) {
                        throw var11_17;
                    }
                    {
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)var8_11, (Throwable)var9_12);
                        }
lbl68:
                        // 1 sources

                        return var10_13;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (ok2) {
            Config config = this.config;
            Object object = config instanceof Config.File ? (Config.File)config : null;
            if ((object == null || (object = ((Config.File)object).getPath()) == null) && (object = backupManager.chooseRestoreFile()) == null) {
                return;
            }
            Object file = object;
            backupManager.restoreModal(serialNumber, (Path)file, BackupManager.Source.RESTORE_APP_ACTION, true);
        }
    }

    private final String getDeviceSerialNumber(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        String string = (String)RunningDevicesConstants.SERIAL_NUMBER_KEY.getData(dataContext);
        if (string == null) {
            string = this.actionHelper.getDeployTargetSerial(project2);
        }
        return string;
    }

    private final void showDialog(Project $this$showDialog, String message) {
        DialogFactory.showDialog$default(this.dialogFactory, $this$showDialog, BackupBundle.message("restore.file.action.error.title", new Object[0]), message, null, 8, null);
    }

    public RestoreAppAction() {
        this(null, null, null, 7, null);
    }

    public static final /* synthetic */ void access$showDialog(RestoreAppAction $this, Project $receiver, String message) {
        $this.showDialog($receiver, message);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\b\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/backup/RestoreAppAction$Config;", "", "<init>", "()V", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "getPresentation", "()Lcom/intellij/openapi/actionSystem/Presentation;", "Standalone", "Browse", "File", "Lcom/android/tools/idea/backup/RestoreAppAction$Config$Browse;", "Lcom/android/tools/idea/backup/RestoreAppAction$Config$File;", "Lcom/android/tools/idea/backup/RestoreAppAction$Config$Standalone;", "intellij.android.backup"})
    public static abstract sealed class Config {
        private Config() {
        }

        @NotNull
        public abstract Presentation getPresentation();

        public /* synthetic */ Config(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/backup/RestoreAppAction$Config$Browse;", "Lcom/android/tools/idea/backup/RestoreAppAction$Config;", "<init>", "()V", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "getPresentation", "()Lcom/intellij/openapi/actionSystem/Presentation;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.backup"})
        public static final class Browse
        extends Config {
            @NotNull
            public static final Browse INSTANCE = new Browse();
            @NotNull
            private static final Presentation presentation = new Presentation(BackupBundle.message("restore.action.browse", new Object[0]));

            private Browse() {
                super(null);
            }

            @Override
            @NotNull
            public Presentation getPresentation() {
                return presentation;
            }

            @NotNull
            public String toString() {
                return "Browse";
            }

            public int hashCode() {
                return -389209659;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Browse)) {
                    return false;
                }
                Browse cfr_ignored_0 = (Browse)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/backup/RestoreAppAction$Config$File;", "Lcom/android/tools/idea/backup/RestoreAppAction$Config;", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "getPresentation", "()Lcom/intellij/openapi/actionSystem/Presentation;", "intellij.android.backup"})
        public static final class File
        extends Config {
            @NotNull
            private final Path path;
            @NotNull
            private final Presentation presentation;

            public File(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                super(null);
                this.path = path;
                this.presentation = new Presentation(((Object)this.path).toString());
            }

            @NotNull
            public final Path getPath() {
                return this.path;
            }

            @Override
            @NotNull
            public Presentation getPresentation() {
                return this.presentation;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/backup/RestoreAppAction$Config$Standalone;", "Lcom/android/tools/idea/backup/RestoreAppAction$Config;", "<init>", "()V", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "getPresentation", "()Lcom/intellij/openapi/actionSystem/Presentation;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.backup"})
        public static final class Standalone
        extends Config {
            @NotNull
            public static final Standalone INSTANCE;
            @NotNull
            private static final Presentation presentation;

            private Standalone() {
                super(null);
            }

            @Override
            @NotNull
            public Presentation getPresentation() {
                return presentation;
            }

            @NotNull
            public String toString() {
                return "Standalone";
            }

            public int hashCode() {
                return 1401898496;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Standalone)) {
                    return false;
                }
                Standalone cfr_ignored_0 = (Standalone)other;
                return true;
            }

            static {
                Presentation presentation;
                INSTANCE = new Standalone();
                Presentation $this$presentation_u24lambda_u240 = presentation = new Presentation();
                boolean bl = false;
                $this$presentation_u24lambda_u240.setText(BackupBundle.message("restore.action.title", new Object[0]));
                $this$presentation_u24lambda_u240.setDescription(BackupBundle.message("restore.action.description", new Object[0]));
                $this$presentation_u24lambda_u240.setIcon(AllIcons.Actions.Download);
                Standalone.presentation = presentation;
            }
        }
    }
}

