/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.backup.BackupService;
import com.android.tools.idea.backup.PostBackupDialogKt;
import com.android.tools.idea.backup.UtilsKt;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.util.PathExtensionsKt;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import icons.StudioIcons;
import java.awt.Component;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/backup/PostBackupDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "backupPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "mode", "Lcom/android/tools/idea/backup/PostBackupDialog$Mode;", "selectedSetting", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "openRunConfigWhenDone", "", "setAsCurrentRunConfig", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "showNotification", "settings", "addNewRunConfigSetting", "getRunConfigSettings", "", "isApplicable", "applicationId", "", "Mode", "RunConfigSettingRenderer", "intellij.android.backup"})
@SourceDebugExtension(value={"SMAP\nPostBackupDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostBackupDialog.kt\ncom/android/tools/idea/backup/PostBackupDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,187:1\n774#2:188\n865#2,2:189\n1056#2:191\n1869#2,2:192\n27#3:194\n*S KotlinDebug\n*F\n+ 1 PostBackupDialog.kt\ncom/android/tools/idea/backup/PostBackupDialog\n*L\n151#1:188\n151#1:189,2\n152#1:191\n153#1:192,2\n88#1:194\n*E\n"})
public final class PostBackupDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Path backupPath;
    @NotNull
    private Mode mode;
    @Nullable
    private RunnerAndConfigurationSettings selectedSetting;
    private boolean openRunConfigWhenDone;
    private boolean setAsCurrentRunConfig;

    public PostBackupDialog(@NotNull Project project, @NotNull Path backupPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        super(project);
        this.project = project;
        this.backupPath = backupPath;
        this.mode = Mode.EXISTING_CONFIG;
        this.setAsCurrentRunConfig = true;
        this.init();
        this.setTitle("Add To Run Configuration");
        this.pack();
        this.setResizable(false);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> PostBackupDialog.createCenterPanel$lambda$7(this, arg_0));
    }

    protected void doOKAction() {
        RunnerAndConfigurationSettings settings;
        this.applyFields();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings = (switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1 -> this.selectedSetting;
            case 2 -> this.addNewRunConfigSetting();
            default -> throw new NoWhenBranchMatchedException();
        });
        RunConfiguration runConfiguration = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        AndroidRunConfiguration androidRunConfiguration = runConfiguration instanceof AndroidRunConfiguration ? (AndroidRunConfiguration)runConfiguration : null;
        if (androidRunConfiguration == null) {
            return;
        }
        AndroidRunConfiguration config = androidRunConfiguration;
        config.RESTORE_ENABLED = true;
        config.RESTORE_FILE = ((Object)PathExtensionsKt.relativeToProject((Path)this.backupPath, (Project)this.project)).toString();
        boolean bl = this.openRunConfigWhenDone;
        if (bl) {
            RunDialog.editConfiguration((Project)this.project, (RunnerAndConfigurationSettings)settings, (String)"Edit Configuration");
        } else if (!bl) {
            this.showNotification(settings);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (this.setAsCurrentRunConfig) {
            RunManager.Companion.getInstance(this.project).setSelectedConfiguration(settings);
        }
        super.doOKAction();
    }

    private final void showNotification(RunnerAndConfigurationSettings settings) {
        Notification notification = new Notification("Backup", "Updated run configuration '" + settings.getName() + "'", NotificationType.INFORMATION);
        notification.addAction(new AnAction(this, settings){
            final /* synthetic */ PostBackupDialog this$0;
            final /* synthetic */ RunnerAndConfigurationSettings $settings;
            {
                this.this$0 = $receiver;
                this.$settings = $settings;
                super("Open");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RunDialog.editConfiguration((Project)PostBackupDialog.access$getProject$p(this.this$0), (RunnerAndConfigurationSettings)this.$settings, (String)"Edit Configuration");
            }
        });
        Notifications.Bus.notify((Notification)notification, (Project)this.project);
    }

    private final RunnerAndConfigurationSettings addNewRunConfigSetting() {
        RunManager runManager = RunManager.Companion.getInstance(this.project);
        RunnerAndConfigurationSettings settings = runManager.createConfiguration("Restore", AndroidRunConfigurationType.class);
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        runManager.setUniqueNameIfNeeded(runConfiguration);
        String applicationId2 = BackupService.Companion.getMetadata(this.backupPath).getApplicationId();
        Module module = UtilsKt.findHolderModule(this.project, applicationId2);
        if (module != null) {
            RunConfiguration runConfiguration2 = settings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration2, (String)"null cannot be cast to non-null type com.android.tools.idea.run.AndroidRunConfiguration");
            AndroidRunConfiguration config = (AndroidRunConfiguration)runConfiguration2;
            config.setModule(module);
        }
        settings.storeInLocalWorkspace();
        runManager.addConfiguration(settings);
        return settings;
    }

    /*
     * WARNING - void declaration
     */
    private final List<RunnerAndConfigurationSettings> getRunConfigSettings() {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        RunManager runManager = RunManager.Companion.getInstance(this.project);
        String applicationId2 = BackupService.Companion.getMetadata(this.backupPath).getApplicationId();
        RunnerAndConfigurationSettings selectedConfiguration = runManager.getSelectedConfiguration();
        List $this$getRunConfigSettings_u24lambda_u2411 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = selectedConfiguration;
        boolean bl2 = runnerAndConfigurationSettings != null ? this.isApplicable(runnerAndConfigurationSettings, applicationId2) : false;
        if (bl2) {
            $this$getRunConfigSettings_u24lambda_u2411.add(selectedConfiguration);
        }
        Iterable iterable = runManager.getAllSettings();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl3 = false;
            if (!this.isApplicable(it, applicationId2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (RunnerAndConfigurationSettings)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)it, (Object)selectedConfiguration)) continue;
            $this$getRunConfigSettings_u24lambda_u2411.add(it);
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(RunnerAndConfigurationSettings $this$isApplicable, String applicationId2) {
        RunConfiguration runConfiguration = $this$isApplicable.getConfiguration();
        if (!(runConfiguration instanceof AndroidRunConfiguration)) return false;
        AndroidRunConfiguration androidRunConfiguration = (AndroidRunConfiguration)runConfiguration;
        if (androidRunConfiguration == null) {
            return false;
        }
        AndroidRunConfiguration configuration2 = androidRunConfiguration;
        if (PostBackupDialogKt.access$isComposePreview(configuration2)) return false;
        ApplicationIdProvider applicationIdProvider = configuration2.getApplicationIdProvider();
        if (!Intrinsics.areEqual((Object)(applicationIdProvider != null ? applicationIdProvider.getPackageName() : null), (Object)applicationId2)) return false;
        return true;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4$lambda$0(List $settings, PostBackupDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.radioButton("Add to existing run configuration", (Object)Mode.EXISTING_CONFIG);
        if (!((Collection)$settings).isEmpty()) {
            this$0.selectedSetting = (RunnerAndConfigurationSettings)CollectionsKt.first((List)$settings);
        }
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)$settings, (ListCellRenderer)new RunConfigSettingRenderer()), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return PostBackupDialog.access$getSelectedSetting$p((PostBackupDialog)((Object)this.receiver));
            }

            public void set(Object value2) {
                PostBackupDialog.access$setSelectedSetting$p((PostBackupDialog)((Object)this.receiver), (RunnerAndConfigurationSettings)value2);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4$lambda$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.radioButton("Add to a new run configuration", (Object)Mode.NEW_CONFIG);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4$lambda$2(PostBackupDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox("Open run configuration when done"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return PostBackupDialog.access$getOpenRunConfigWhenDone$p((PostBackupDialog)((Object)this.receiver));
            }

            public void set(Object value2) {
                PostBackupDialog.access$setOpenRunConfigWhenDone$p((PostBackupDialog)((Object)this.receiver), (Boolean)value2);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4$lambda$3(PostBackupDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox("Set as current run configuration"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return PostBackupDialog.access$getSetAsCurrentRunConfig$p((PostBackupDialog)((Object)this.receiver));
            }

            public void set(Object value2) {
                PostBackupDialog.access$setSetAsCurrentRunConfig$p((PostBackupDialog)((Object)this.receiver), (Boolean)value2);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$4(PostBackupDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        List<RunnerAndConfigurationSettings> settings = this$0.getRunConfigSettings();
        if (settings.isEmpty()) {
            this$0.mode = Mode.NEW_CONFIG;
        }
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PostBackupDialog.createCenterPanel$lambda$7$lambda$4$lambda$0(settings, this$0, arg_0), (int)1, null).enabled(!((Collection)settings).isEmpty());
        Panel.row$default((Panel)$this$buttonsGroup, null, PostBackupDialog::createCenterPanel$lambda$7$lambda$4$lambda$1, (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PostBackupDialog.createCenterPanel$lambda$7$lambda$4$lambda$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PostBackupDialog.createCenterPanel$lambda$7$lambda$4$lambda$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Mode createCenterPanel$lambda$7$lambda$5(PostBackupDialog this$0) {
        return this$0.mode;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6(PostBackupDialog this$0, Mode it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.mode = it;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$7(PostBackupDialog this$0, Panel $this$panel) {
        void getter$iv;
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> PostBackupDialog.createCenterPanel$lambda$7$lambda$4(this$0, arg_0), (int)3, null);
        Function0 function0 = () -> PostBackupDialog.createCenterPanel$lambda$7$lambda$5(this$0);
        Function1 setter$iv = arg_0 -> PostBackupDialog.createCenterPanel$lambda$7$lambda$6(this$0, arg_0);
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Mode.class);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(PostBackupDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ RunnerAndConfigurationSettings access$getSelectedSetting$p(PostBackupDialog $this) {
        return $this.selectedSetting;
    }

    public static final /* synthetic */ void access$setSelectedSetting$p(PostBackupDialog $this, RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        $this.selectedSetting = runnerAndConfigurationSettings;
    }

    public static final /* synthetic */ boolean access$getOpenRunConfigWhenDone$p(PostBackupDialog $this) {
        return $this.openRunConfigWhenDone;
    }

    public static final /* synthetic */ void access$setOpenRunConfigWhenDone$p(PostBackupDialog $this, boolean bl) {
        $this.openRunConfigWhenDone = bl;
    }

    public static final /* synthetic */ boolean access$getSetAsCurrentRunConfig$p(PostBackupDialog $this) {
        return $this.setAsCurrentRunConfig;
    }

    public static final /* synthetic */ void access$setSetAsCurrentRunConfig$p(PostBackupDialog $this, boolean bl) {
        $this.setAsCurrentRunConfig = bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/backup/PostBackupDialog$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "EXISTING_CONFIG", "NEW_CONFIG", "intellij.android.backup"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode EXISTING_CONFIG = new Mode();
        public static final /* enum */ Mode NEW_CONFIG = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value2) {
            return Enum.valueOf(Mode.class, value2);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.EXISTING_CONFIG, Mode.NEW_CONFIG};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J<\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/backup/PostBackupDialog$RunConfigSettingRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "<init>", "()V", "component", "Ljavax/swing/JLabel;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.android.backup"})
    private static final class RunConfigSettingRenderer
    implements ListCellRenderer<RunnerAndConfigurationSettings> {
        @NotNull
        private final JLabel component = new JLabel(StudioIcons.Shell.Filetree.ANDROID_PROJECT, 10);

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends RunnerAndConfigurationSettings> list, @Nullable RunnerAndConfigurationSettings value2, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Object object = value2;
            if (object == null || (object = object.getName()) == null) {
                object = "";
            }
            this.component.setText((String)object);
            return this.component;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.EXISTING_CONFIG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.NEW_CONFIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

