/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.assistant.RecipeUtilsKt;
import com.android.tools.idea.npw.model.NewTemplateRendererKt;
import com.android.tools.idea.npw.template.ModuleTemplateDataBuilderKt;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.template.RecipeExecutor;
import com.android.tools.idea.wizard.template.TemplateData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2!\u0010\u0011\u001a\u001d\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007j\u0002`\f\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0007J3\u0010\u0013\u001a\u00020\n2!\u0010\u0011\u001a\u001d\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007j\u0002`\f\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J3\u0010\u0010\u001a\u00020\u000f2!\u0010\u0011\u001a\u001d\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007j\u0002`\f\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\u0006\u0010\u0012\u001a\u00020\rH\u0002RG\u0010\u0004\u001a;\u0012+\u0012)\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007j\u0002`\f\u00a2\u0006\u0002\b\u000b\u0012\u0004\u0012\u00020\r0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/assistant/RecipeUtils;", "", "<init>", "()V", "recipeMetadataCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/util/Pair;", "Lkotlin/Function2;", "Lcom/android/tools/idea/wizard/template/RecipeExecutor;", "Lcom/android/tools/idea/wizard/template/TemplateData;", "", "Lkotlin/ExtensionFunctionType;", "Lcom/android/tools/idea/wizard/template/Recipe;", "Lcom/intellij/openapi/project/Project;", "", "Lcom/android/tools/idea/assistant/RecipeMetadata;", "getRecipeMetadata", "recipe", "project", "execute", "module", "Lcom/intellij/openapi/module/Module;", "setUpMetadata", "context", "Lcom/android/tools/idea/templates/recipe/RenderingContext;", "metadata", "getRecipeMetadataCacheSize", "", "parseManifestForPermissions", "file", "Ljava/io/File;", "getAndroidModules", "assistant"})
@SourceDebugExtension(value={"SMAP\nRecipeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeUtils.kt\ncom/android/tools/idea/assistant/RecipeUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,213:1\n1869#2,2:214\n1869#2,2:216\n1869#2,2:218\n1869#2,2:220\n1869#2,2:222\n1869#2,2:224\n3829#3:226\n4344#3,2:227\n*S KotlinDebug\n*F\n+ 1 RecipeUtils.kt\ncom/android/tools/idea/assistant/RecipeUtils\n*L\n153#1:214,2\n156#1:216,2\n159#1:218,2\n160#1:220,2\n161#1:222,2\n162#1:224,2\n210#1:226\n210#1:227,2\n*E\n"})
public final class RecipeUtils {
    @NotNull
    public static final RecipeUtils INSTANCE = new RecipeUtils();
    @NotNull
    private static final ConcurrentHashMap<Pair<Function2<RecipeExecutor, TemplateData, Unit>, Project>, List<RecipeMetadata>> recipeMetadataCache = new ConcurrentHashMap();

    private RecipeUtils() {
    }

    @JvmStatic
    @WorkerThread
    @NotNull
    public static final List<RecipeMetadata> getRecipeMetadata(@NotNull Function2<? super RecipeExecutor, ? super TemplateData, Unit> recipe, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Pair key = new Pair(recipe, (Object)project);
        List list = recipeMetadataCache.computeIfAbsent((Pair<Function2<RecipeExecutor, TemplateData, Unit>, Project>)key, arg_0 -> RecipeUtils.getRecipeMetadata$lambda$2(arg_0 -> RecipeUtils.getRecipeMetadata$lambda$1(project, recipe, key, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
        return list;
    }

    @JvmStatic
    @UiThread
    public static final void execute(@NotNull Function2<? super RecipeExecutor, ? super TemplateData, Unit> recipe, @NotNull Module module) {
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        File file = AndroidRootUtil.findModuleRootFolderPath(module);
        Intrinsics.checkNotNull((Object)file);
        File moduleRoot = file;
        File rootPath = new File(FileUtil.generateRandomTemporaryPath(), "unused");
        rootPath.deleteOnExit();
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RenderingContext context = new RenderingContext(project, module, "Unnamed", (TemplateData)ModuleTemplateDataBuilderKt.getExistingModuleTemplateDataBuilder(module).build(), rootPath, moduleRoot, false, true);
        WriteCommandAction.writeCommandAction((Project)module.getProject()).withName("Executing recipe instructions").run(() -> RecipeUtils.execute$lambda$3(recipe, context));
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        TemplateUtils.openEditors(project2, (Collection<? extends File>)context.getFilesToOpen(), true);
    }

    private final RecipeMetadata getRecipeMetadata(Function2<? super RecipeExecutor, ? super TemplateData, Unit> recipe, Module module) {
        RecipeMetadata metadata = new RecipeMetadata(recipe, module, null, null, null, null, null, 124, null);
        File file = AndroidRootUtil.findModuleRootFolderPath(module);
        Intrinsics.checkNotNull((Object)file);
        File moduleRoot = file;
        File rootPath = new File(FileUtil.generateRandomTemporaryPath(), "unused");
        rootPath.deleteOnExit();
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RenderingContext context = new RenderingContext(project, module, "Unnamed", (TemplateData)ModuleTemplateDataBuilderKt.getExistingModuleTemplateDataBuilder(module).build(), rootPath, moduleRoot, false, true);
        NewTemplateRendererKt.findReferences(recipe, context);
        this.setUpMetadata(context, metadata);
        return metadata;
    }

    @VisibleForTesting
    public final void setUpMetadata(@NotNull RenderingContext context, @NotNull RecipeMetadata metadata) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        RenderingContext $this$setUpMetadata_u24lambda_u2410 = context;
        boolean bl = false;
        List manifests = new ArrayList();
        Set set2 = $this$setUpMetadata_u24lambda_u2410.getDependencies().get((Object)"implementation");
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"get(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl2 = false;
            List<String> list = metadata.getDependencies();
            String string = it;
            Intrinsics.checkNotNull((Object)string);
            list.add(string);
        }
        Set set3 = $this$setUpMetadata_u24lambda_u2410.getDependencies().get((Object)"api");
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"get(...)");
        $this$forEach$iv = set3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl3 = false;
            List<String> list = metadata.getDependencies();
            String string = it;
            Intrinsics.checkNotNull((Object)string);
            list.add(string);
        }
        $this$forEach$iv = $this$setUpMetadata_u24lambda_u2410.getClasspathEntries();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl4 = false;
            metadata.getClasspathEntries().add((String)it);
        }
        $this$forEach$iv = manifests;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl5 = false;
            INSTANCE.parseManifestForPermissions((File)it, metadata);
        }
        $this$forEach$iv = $this$setUpMetadata_u24lambda_u2410.getPlugins();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl6 = false;
            metadata.getPlugins().add((String)it);
        }
        $this$forEach$iv = $this$setUpMetadata_u24lambda_u2410.getTargetFiles();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl7 = false;
            metadata.getModifiedFiles().add((File)it);
        }
    }

    @VisibleForTesting
    public final int getRecipeMetadataCacheSize() {
        return recipeMetadataCache.size();
    }

    private final void parseManifestForPermissions(File file, RecipeMetadata metadata) {
        try {
            SAXParserFactory factory2 = SAXParserFactory.newInstance();
            SAXParser saxParser = factory2.newSAXParser();
            saxParser.parse(file, new DefaultHandler(metadata){
                final /* synthetic */ RecipeMetadata $metadata;
                {
                    this.$metadata = $metadata;
                }

                /*
                 * Unable to fully structure code
                 */
                public void startElement(String uri, String localName, String tagName, Attributes attributes) {
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                    Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
                    Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
                    switch (tagName.hashCode()) {
                        case 599862896: {
                            if (!tagName.equals("uses-permission")) {
                                break;
                            }
                            ** GOTO lbl16
                        }
                        case 1705921021: {
                            if (!tagName.equals("uses-permission-sdk-m")) {
                                break;
                            }
                            ** GOTO lbl16
                        }
                        case 1343942321: {
                            if (!tagName.equals("uses-permission-sdk-23")) break;
lbl16:
                            // 3 sources

                            v0 = attributes.getValue("android:name");
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getValue(...)");
                            permission = StringsKt.replace$default((String)v0, (String)"android.permission.", (String)"", (boolean)false, (int)4, null);
                            this.$metadata.getPermissions().add(permission);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            RecipeUtilsKt.access$getLog().warn("Failed to read permissions from AndroidManifest.xml", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Module> getAndroidModules(Project project) {
        void $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void module = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(AndroidFacet.getInstance((Module)module) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final void getRecipeMetadata$lambda$1$lambda$0(Pair $key) {
        recipeMetadataCache.remove($key);
    }

    private static final List getRecipeMetadata$lambda$1(Project $project, Function2 $recipe, Pair $key, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ImmutableList.Builder metadataBuilder = ImmutableList.builder();
        for (Module module : INSTANCE.getAndroidModules($project)) {
            metadataBuilder.add((Object)INSTANCE.getRecipeMetadata((Function2<? super RecipeExecutor, ? super TemplateData, Unit>)$recipe, module));
        }
        ImmutableList metadata = metadataBuilder.build();
        Disposer.register((Disposable)AndroidPluginDisposable.Companion.getProjectInstance($project), () -> RecipeUtils.getRecipeMetadata$lambda$1$lambda$0($key));
        return (List)metadata;
    }

    private static final List getRecipeMetadata$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void execute$lambda$3(Function2 $recipe, RenderingContext $context) {
        NewTemplateRendererKt.actuallyRender((Function2<? super RecipeExecutor, ? super TemplateData, Unit>)$recipe, $context);
    }
}

