/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.BorderlessTableCellRenderer;
import com.android.tools.adtui.stdui.TimelineTable;
import com.android.tools.adtui.stdui.TooltipLayeredPane;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModel;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.SelectionRangeDataFetcher;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.FontsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.LayoutKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00152\u00020\u0001:\u0006\u0010\u0011\u0012\u0013\u0014\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView;", "", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "parentPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "<init>", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;Lcom/android/tools/adtui/stdui/TooltipLayeredPane;)V", "threadsTable", "Ljavax/swing/JTable;", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "Column", "ThreadsTableModel", "TimelineRenderer", "ConnectionsInfoComponent", "TooltipView", "Companion", "app-inspection.inspectors.network.view"})
public final class ThreadsView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTable threadsTable;
    @NotNull
    private final AspectObserver observer;
    private static final int ROW_HEIGHT = com.android.tools.idea.appinspection.inspectors.network.view.ThreadsView$Companion.access$getSTATE_HEIGHT(Companion) + 2 * (com.android.tools.idea.appinspection.inspectors.network.view.ThreadsView$Companion.access$getSELECTION_OUTLINE_BORDER(Companion) + com.android.tools.idea.appinspection.inspectors.network.view.ThreadsView$Companion.access$getSELECTION_OUTLINE_PADDING(Companion));

    public ThreadsView(final @NotNull NetworkInspectorModel model, @NotNull TooltipLayeredPane parentPane) {
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)parentPane, (String)"parentPane");
        ThreadsTableModel tableModel2 = new ThreadsTableModel(model.getSelectionRangeDataFetcher());
        JBTable jBTable = TimelineTable.create((TableModel)tableModel2, (Timeline)model.getTimeline(), (String)Column.TIMELINE.getDisplayName(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jBTable, (String)"create(...)");
        this.threadsTable = (JTable)jBTable;
        final TimelineRenderer timelineRenderer = new TimelineRenderer(this.threadsTable, model);
        this.threadsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer((TableCellRenderer)new BorderlessTableCellRenderer());
        ((JBTable)this.threadsTable).getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer((TableCellRenderer)((Object)timelineRenderer));
        this.threadsTable.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        ((JBTable)this.threadsTable).setShowVerticalLines(true);
        ((JBTable)this.threadsTable).setShowHorizontalLines(false);
        this.threadsTable.setCellSelectionEnabled(false);
        this.threadsTable.setFocusable(false);
        this.threadsTable.setRowMargin(0);
        ((JBTable)this.threadsTable).setRowHeight(ROW_HEIGHT);
        this.threadsTable.setFocusTraversalKeys(0, null);
        this.threadsTable.setFocusTraversalKeys(1, null);
        this.threadsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                threadsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setPreferredWidth((int)((double)threadsTable.getWidth() * 1.0 / (double)8));
                threadsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setPreferredWidth((int)((double)threadsTable.getWidth() * 7.0 / (double)8));
            }
        });
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(tableModel2);
        sorter.setComparator(Column.NAME.ordinal(), Comparator.comparing(arg_0 -> ThreadsView._init_$lambda$1(ThreadsView::_init_$lambda$0, arg_0)));
        sorter.setComparator(Column.TIMELINE.ordinal(), Comparator.comparing(arg_0 -> ThreadsView._init_$lambda$3(ThreadsView::_init_$lambda$2, arg_0)));
        this.threadsTable.setRowSorter((RowSorter<? extends TableModel>)sorter);
        this.threadsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Range range = timelineRenderer.getActiveRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getActiveRange(...)");
                Range selection2 = range;
                ConnectionData data2 = Companion.findHttpDataUnderCursor(threadsTable, selection2, e);
                if (data2 != null) {
                    model.setSelectedConnection(data2);
                    model.setDetailContent(NetworkInspectorModel.DetailContent.CONNECTION);
                    e.consume();
                }
            }
        });
        Range range = timelineRenderer.getActiveRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getActiveRange(...)");
        this.threadsTable.addMouseMotionListener(new TooltipView(this.threadsTable, parentPane, range));
        this.observer = new AspectObserver();
        model.getAspect().addDependency(this.observer).onChange((Enum)NetworkInspectorAspect.SELECTED_CONNECTION, () -> ThreadsView._init_$lambda$4(timelineRenderer, this));
    }

    @NotNull
    public final JComponent getComponent() {
        return this.threadsTable;
    }

    private static final String _init_$lambda$0(String obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj;
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Long _init_$lambda$2(List data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return ((ConnectionData)data2.get(0)).getRequestStartTimeUs();
    }

    private static final Long _init_$lambda$3(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$4(TimelineRenderer $timelineRenderer, ThreadsView this$0) {
        $timelineRenderer.updateRows();
        this$0.threadsTable.repaint();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$Column;", "", "displayName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "NAME", "TIMELINE", "app-inspection.inspectors.network.view"})
    private static final class Column
    extends Enum<Column> {
        @NotNull
        private final String displayName;
        public static final /* enum */ Column NAME = new Column("Initiating thread");
        public static final /* enum */ Column TIMELINE = new Column("Timeline");
        private static final /* synthetic */ Column[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Column(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value2) {
            return Enum.valueOf(Column.class, value2);
        }

        @NotNull
        public static EnumEntries<Column> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = columnArray = new Column[]{Column.NAME, Column.TIMELINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$Companion;", "", "<init>", "()V", "STATE_HEIGHT", "", "getSTATE_HEIGHT", "()I", "SELECTION_OUTLINE_PADDING", "getSELECTION_OUTLINE_PADDING", "SELECTION_OUTLINE_BORDER", "getSELECTION_OUTLINE_BORDER", "ROW_HEIGHT", "findHttpDataUnderCursor", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "table", "Ljavax/swing/JTable;", "range", "Lcom/android/tools/adtui/model/Range;", "e", "Ljava/awt/event/MouseEvent;", "positionToRange", "", "x", "width", "app-inspection.inspectors.network.view"})
    public static final class Companion {
        private Companion() {
        }

        private final int getSTATE_HEIGHT() {
            return JBUI.scale((int)15);
        }

        private final int getSELECTION_OUTLINE_PADDING() {
            return JBUI.scale((int)3);
        }

        private final int getSELECTION_OUTLINE_BORDER() {
            return JBUI.scale((int)2);
        }

        private final ConnectionData findHttpDataUnderCursor(JTable table2, Range range, MouseEvent e) {
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), table2);
            int row = table2.rowAtPoint(p);
            int column2 = table2.columnAtPoint(p);
            if (row == -1 || column2 == -1) {
                return null;
            }
            if (column2 == Column.TIMELINE.ordinal()) {
                Rectangle cellBounds = table2.getCellRect(row, column2, false);
                int modelIndex = table2.convertRowIndexToModel(row);
                Object object = table2.getModel().getValueAt(modelIndex, 1);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData>");
                List dataList = (List)object;
                double at = this.positionToRange(p.x - cellBounds.x, cellBounds.getWidth(), range);
                for (ConnectionData data2 : dataList) {
                    if (!((double)data2.getRequestStartTimeUs() <= at) || !(at <= (double)data2.getConnectionEndTimeUs())) continue;
                    return data2;
                }
            }
            return null;
        }

        private final double positionToRange(double x, double width, Range range) {
            return x * range.getLength() / width + range.getMin();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ConnectionsInfoComponent;", "Ljavax/swing/JComponent;", "table", "Ljavax/swing/JTable;", "dataList", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "range", "Lcom/android/tools/adtui/model/Range;", "<init>", "(Ljavax/swing/JTable;Ljava/util/List;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;Lcom/android/tools/adtui/model/Range;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "drawState", "g2d", "Ljava/awt/Graphics2D;", "data", "endLimit", "", "drawConnectionName", "drawSelection", "rangeToPosition", "r", "Companion", "app-inspection.inspectors.network.view"})
    private static final class ConnectionsInfoComponent
    extends JComponent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JTable table;
        @NotNull
        private final List<ConnectionData> dataList;
        @NotNull
        private final NetworkInspectorModel model;
        @NotNull
        private final Range range;
        private static final int NAME_PADDING = 6;

        public ConnectionsInfoComponent(@NotNull JTable table2, @NotNull List<? extends ConnectionData> dataList, @NotNull NetworkInspectorModel model, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.table = table2;
            this.dataList = dataList;
            this.model = model;
            this.range = range;
            this.setFont(FontsKt.getSMALL_FONT());
            this.setForeground((Color)JBColor.BLACK);
            this.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int n = ((Collection)this.dataList).size();
            for (int i = 0; i < n; ++i) {
                ConnectionData data2 = this.dataList.get(i);
                double endLimit = i + 1 < this.dataList.size() ? this.rangeToPosition(this.dataList.get(i + 1).getRequestStartTimeUs()) : (double)this.getWidth();
                this.drawState(g2d, data2, endLimit);
                this.drawConnectionName(g2d, data2, endLimit);
            }
            if (this.model.getSelectedConnection() != null && CollectionsKt.contains((Iterable)this.dataList, (Object)this.model.getSelectedConnection())) {
                ConnectionData connectionData = this.model.getSelectedConnection();
                Intrinsics.checkNotNull((Object)connectionData);
                this.drawSelection(g2d, connectionData, this.getWidth());
            }
            g2d.dispose();
        }

        private final void drawState(Graphics2D g2d, ConnectionData data2, double endLimit) {
            double prev = this.rangeToPosition(data2.getRequestStartTimeUs());
            g2d.setColor(ColorsKt.getNETWORK_SENDING_COLOR());
            if (data2.getResponseStartTimeUs() > 0L) {
                double download = this.rangeToPosition(data2.getResponseStartTimeUs());
                g2d.fill(new Rectangle2D.Double(prev, (double)(this.getHeight() - Companion.getSTATE_HEIGHT()) / 2.0, download - prev, Companion.getSTATE_HEIGHT()));
                g2d.setColor(ColorsKt.getNETWORK_RECEIVING_COLOR());
                prev = download;
            }
            double end = data2.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data2.getConnectionEndTimeUs()) : endLimit;
            g2d.fill(new Rectangle2D.Double(prev, (double)(this.getHeight() - Companion.getSTATE_HEIGHT()) / 2.0, end - prev, Companion.getSTATE_HEIGHT()));
        }

        private final void drawConnectionName(Graphics2D g2d, ConnectionData data2, double endLimit) {
            g2d.setFont(this.getFont());
            g2d.setColor(this.getForeground());
            double start2 = this.rangeToPosition(data2.getRequestStartTimeUs());
            double end = data2.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data2.getConnectionEndTimeUs()) : endLimit;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            String string = data2.getName();
            Intrinsics.checkNotNull((Object)metrics);
            String text2 = AdtUiUtils.shrinkToFit$default((String)string, (FontMetrics)metrics, (float)((float)(end - start2 - (double)12)), null, (int)8, null);
            double availableSpace = end - start2 - (double)metrics.stringWidth(text2);
            g2d.drawString(text2, (float)(start2 + availableSpace / 2.0), (float)((double)(this.getHeight() - metrics.getHeight()) * 0.5 + (double)metrics.getAscent()));
        }

        private final void drawSelection(Graphics2D g2d, ConnectionData data2, double endLimit) {
            double start2 = this.rangeToPosition(data2.getRequestStartTimeUs());
            double end = data2.getConnectionEndTimeUs() > 0L ? this.rangeToPosition(data2.getConnectionEndTimeUs()) : endLimit;
            g2d.setStroke(new BasicStroke(Companion.getSELECTION_OUTLINE_BORDER()));
            g2d.setColor(this.table.getSelectionBackground());
            Rectangle2D.Double rect = new Rectangle2D.Double(start2 - (double)Companion.getSELECTION_OUTLINE_PADDING(), (double)(this.getHeight() - Companion.getSTATE_HEIGHT()) / 2.0 - (double)Companion.getSELECTION_OUTLINE_PADDING(), end - start2 + (double)(2 * Companion.getSELECTION_OUTLINE_PADDING()), (double)Companion.getSTATE_HEIGHT() + (double)2 * (double)Companion.getSELECTION_OUTLINE_PADDING());
            g2d.draw(rect);
        }

        private final double rangeToPosition(double r) {
            return (r - this.range.getMin()) / this.range.getLength() * (double)this.getWidth();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ConnectionsInfoComponent$Companion;", "", "<init>", "()V", "NAME_PADDING", "", "app-inspection.inspectors.network.view"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ThreadsTableModel;", "Ljavax/swing/table/AbstractTableModel;", "selectionRangeDataFetcher", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/SelectionRangeDataFetcher;", "<init>", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/SelectionRangeDataFetcher;)V", "threads", "", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "dataChanged", "", "dataList", "getRowCount", "", "getColumnCount", "getColumnName", "", "column", "getValueAt", "", "rowIndex", "columnIndex", "app-inspection.inspectors.network.view"})
    @SourceDebugExtension(value={"SMAP\nThreadsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadsView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ThreadsTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,423:1\n774#2:424\n865#2,2:425\n1491#2:427\n1516#2,3:428\n1519#2,3:438\n382#3,7:431\n*S KotlinDebug\n*F\n+ 1 ThreadsView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$ThreadsTableModel\n*L\n148#1:424\n148#1:425,2\n148#1:427\n148#1:428,3\n148#1:438,3\n148#1:431,7\n*E\n"})
    private static final class ThreadsTableModel
    extends AbstractTableModel {
        @NotNull
        private final List<List<ConnectionData>> threads;

        public ThreadsTableModel(@NotNull SelectionRangeDataFetcher selectionRangeDataFetcher) {
            Intrinsics.checkNotNullParameter((Object)selectionRangeDataFetcher, (String)"selectionRangeDataFetcher");
            this.threads = new ArrayList();
            selectionRangeDataFetcher.addOnChangedListener((Function1<? super List<? extends ConnectionData>, Unit>)((Function1)arg_0 -> ThreadsTableModel._init_$lambda$0(this, arg_0)));
        }

        /*
         * WARNING - void declaration
         */
        private final void dataChanged(List<? extends ConnectionData> dataList) {
            void $this$groupByTo$iv$iv;
            ConnectionData it;
            Iterable $this$filterTo$iv$iv;
            this.threads.clear();
            if (dataList.isEmpty()) {
                this.fireTableDataChanged();
                return;
            }
            Iterable $this$filter$iv = dataList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ConnectionData)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !((Collection)it.getThreads()).isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (ConnectionData)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.getThreads().get(0).getId();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object groupedThreads = destination$iv$iv;
            Function1[] function1Array = new Function1[]{ThreadsTableModel::dataChanged$lambda$3, ThreadsTableModel::dataChanged$lambda$4};
            this.threads.addAll(CollectionsKt.sortedWith((Iterable)groupedThreads.values(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.threads.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @NotNull
        public String getColumnName(int column2) {
            return ((Column)((Object)Column.getEntries().get(column2))).getDisplayName();
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == Column.NAME.ordinal() ? this.threads.get(rowIndex).get(0).getThreads().get(0).getName() : this.threads.get(rowIndex);
        }

        private static final Unit _init_$lambda$0(ThreadsTableModel this$0, List list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            this$0.dataChanged(list);
            return Unit.INSTANCE;
        }

        private static final Comparable dataChanged$lambda$3(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Comparable)((Object)((ConnectionData)it.get(0)).getThreads().get(0).getName());
        }

        private static final Comparable dataChanged$lambda$4(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Long.valueOf(((ConnectionData)it.get(0)).getThreads().get(0).getId());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$TimelineRenderer;", "Lcom/android/tools/adtui/stdui/TimelineTable$CellRenderer;", "Ljavax/swing/event/TableModelListener;", "table", "Ljavax/swing/JTable;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "<init>", "(Ljavax/swing/JTable;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;)V", "connectionsInfo", "", "Ljavax/swing/JComponent;", "tableChanged", "", "e", "Ljavax/swing/event/TableModelEvent;", "updateRows", "getTableCellRendererComponent", "Ljava/awt/Component;", "isSelected", "", "row", "", "app-inspection.inspectors.network.view"})
    private static final class TimelineRenderer
    extends TimelineTable.CellRenderer
    implements TableModelListener {
        @NotNull
        private final JTable table;
        @NotNull
        private final NetworkInspectorModel model;
        @NotNull
        private final List<JComponent> connectionsInfo;

        public TimelineRenderer(@NotNull JTable table2, @NotNull NetworkInspectorModel model) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            super(model.getTimeline(), true);
            this.table = table2;
            this.model = model;
            this.connectionsInfo = new ArrayList();
            this.table.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.table.getModel()));
        }

        @Override
        public void tableChanged(@NotNull TableModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.updateRows();
        }

        public final void updateRows() {
            this.connectionsInfo.clear();
            int n = this.table.getModel().getRowCount();
            for (int index = 0; index < n; ++index) {
                Object object = this.table.getModel().getValueAt(index, 1);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData>");
                List data2 = (List)object;
                Range range = this.getActiveRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getActiveRange(...)");
                this.connectionsInfo.add(new ConnectionsInfoComponent(this.table, data2, this.model, range));
            }
        }

        @NotNull
        protected Component getTableCellRendererComponent(boolean isSelected, int row) {
            return this.connectionsInfo.get(this.table.convertRowIndexToModel(row));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$TooltipView;", "Ljava/awt/event/MouseAdapter;", "table", "Ljavax/swing/JTable;", "parentPane", "Lcom/android/tools/adtui/stdui/TooltipLayeredPane;", "range", "Lcom/android/tools/adtui/model/Range;", "<init>", "(Ljavax/swing/JTable;Lcom/android/tools/adtui/stdui/TooltipLayeredPane;Lcom/android/tools/adtui/model/Range;)V", "content", "Ljavax/swing/JPanel;", "tooltipComponent", "Lcom/android/tools/adtui/TooltipComponent;", "Lorg/jetbrains/annotations/NotNull;", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "showTooltip", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "addToContent", "component", "Ljavax/swing/JComponent;", "newTooltipLabel", "Ljavax/swing/JLabel;", "text", "", "app-inspection.inspectors.network.view"})
    @SourceDebugExtension(value={"SMAP\nThreadsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadsView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/ThreadsView$TooltipView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n1#2:424\n*E\n"})
    private static final class TooltipView
    extends MouseAdapter {
        @NotNull
        private final JTable table;
        @NotNull
        private final Range range;
        @NotNull
        private final JPanel content;
        @NotNull
        private final TooltipComponent tooltipComponent;

        /*
         * WARNING - void declaration
         */
        public TooltipView(@NotNull JTable table2, @NotNull TooltipLayeredPane parentPane, @NotNull Range range) {
            void $this$tooltipComponent_u24lambda_u241;
            void $this$content_u24lambda_u240;
            JPanel jPanel;
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parentPane, (String)"parentPane");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.table = table2;
            this.range = range;
            JPanel jPanel2 = jPanel = new JPanel((LayoutManager)new TabularLayout("*", "*"));
            TooltipView tooltipView = this;
            boolean $i$a$-apply-ThreadsView$TooltipView$content$22 = false;
            $this$content_u24lambda_u240.setBorder(LayoutKt.getTOOLTIP_BORDER());
            $this$content_u24lambda_u240.setBackground(ColorsKt.getTOOLTIP_BACKGROUND());
            $this$content_u24lambda_u240.setFont(com.android.tools.adtui.TooltipView.TOOLTIP_BODY_FONT);
            tooltipView.content = jPanel;
            JPanel $i$a$-apply-ThreadsView$TooltipView$content$22 = jPanel2 = new TooltipComponent.Builder((JComponent)this.content, (JComponent)this.table, (JComponent)parentPane).build();
            tooltipView = this;
            boolean bl = false;
            $this$tooltipComponent_u24lambda_u241.registerListenersOn((Component)this.table);
            $this$tooltipComponent_u24lambda_u241.setVisible(false);
            JPanel jPanel3 = jPanel2;
            Intrinsics.checkNotNullExpressionValue((Object)jPanel3, (String)"apply(...)");
            tooltipView.tooltipComponent = jPanel3;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            block0: {
                ConnectionData data2;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.tooltipComponent.setVisible(false);
                ConnectionData connectionData = data2 = Companion.findHttpDataUnderCursor(this.table, this.range, e);
                if (connectionData == null) break block0;
                ConnectionData it = connectionData;
                boolean bl = false;
                this.showTooltip(it);
            }
        }

        private final void showTooltip(ConnectionData data2) {
            this.tooltipComponent.setVisible(true);
            String urlName = data2.getName();
            long duration = data2.getConnectionEndTimeUs() - data2.getRequestStartTimeUs();
            this.content.removeAll();
            this.addToContent(this.newTooltipLabel(urlName));
            String string = TimeFormatter.getSingleUnitDurationString((long)duration);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSingleUnitDurationString(...)");
            JLabel durationLabel = this.newTooltipLabel(string);
            durationLabel.setForeground(ColorsKt.getTOOLTIP_TEXT());
            this.addToContent(durationLabel);
            if (data2.getThreads().size() > 1) {
                JPanel divider = new JPanel();
                divider.setPreferredSize(new Dimension(0, 5));
                divider.setBorder(JBUI.Borders.customLineBottom((Color)ColorsKt.getNETWORK_THREADS_VIEW_TOOLTIP_DIVIDER()));
                divider.setBackground(this.content.getBackground());
                this.content.add((Component)divider, new TabularLayout.Constraint(this.content.getComponentCount(), 0, 0, 4, null));
                JLabel alsoAccessedByLabel = this.newTooltipLabel("Also accessed by:");
                alsoAccessedByLabel.setFont(alsoAccessedByLabel.getFont().deriveFont(MapsKt.mapOf((Pair)TuplesKt.to((Object)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD))));
                this.addToContent(alsoAccessedByLabel);
                int n = data2.getThreads().size();
                for (int i = 1; i < n; ++i) {
                    JLabel label2 = this.newTooltipLabel(data2.getThreads().get(i).getName());
                    this.addToContent(label2);
                    if (i != data2.getThreads().size() - 1) continue;
                    label2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
                }
            }
        }

        private final void addToContent(JComponent component) {
            component.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            this.content.add((Component)component, new TabularLayout.Constraint(this.content.getComponentCount(), 0, 0, 4, null));
        }

        private final JLabel newTooltipLabel(String text2) {
            JLabel label2 = new JLabel(text2);
            label2.setForeground(ColorsKt.getTOOLTIP_TEXT());
            label2.setFont(com.android.tools.adtui.TooltipView.TOOLTIP_BODY_FONT);
            return label2;
        }
    }
}

