/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.ide.ui;

import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/appinspection/ide/ui/RecentProcess;", "", "deviceSerialNumber", "", "packageName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDeviceSerialNumber", "()Ljava/lang/String;", "getPackageName", "matches", "", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "Companion", "app-inspection.ide"})
public final class RecentProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String deviceSerialNumber;
    @NotNull
    private final String packageName;
    @NotNull
    private static final Key<RecentProcess> RECENT_PROCESS_KEY;

    public RecentProcess(@NotNull String deviceSerialNumber, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.deviceSerialNumber = deviceSerialNumber;
        this.packageName = packageName;
    }

    @NotNull
    public final String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    public final boolean matches(@NotNull ProcessDescriptor process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        return Intrinsics.areEqual((Object)process2.getDevice().getSerial(), (Object)this.deviceSerialNumber) && Intrinsics.areEqual((Object)process2.getPackageName(), (Object)this.packageName);
    }

    static {
        Key key = Key.create((String)"AppInspection.Recent.Process");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RECENT_PROCESS_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/appinspection/ide/ui/RecentProcess$Companion;", "", "<init>", "()V", "RECENT_PROCESS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/appinspection/ide/ui/RecentProcess;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "get", "project", "Lcom/intellij/openapi/project/Project;", "set", "", "process", "isRecentProcess", "", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "app-inspection.ide"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RecentProcess get(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (RecentProcess)project.getUserData(RECENT_PROCESS_KEY);
        }

        public final void set(@NotNull Project project, @Nullable RecentProcess process2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            project.putUserData(RECENT_PROCESS_KEY, (Object)process2);
        }

        public final boolean isRecentProcess(@NotNull ProcessDescriptor process2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            RecentProcess recentProcess = this.get(project);
            return recentProcess != null ? recentProcess.matches(process2) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

