/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.paths;

import com.android.tools.idea.apk.paths.PathNode;
import com.android.tools.idea.apk.paths.PathNodeParent;
import com.google.common.base.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PathTree
extends PathNodeParent {
    @Nullable
    public PathNode addPath(@NotNull String path, char pathSeparator) {
        if (!path.isEmpty()) {
            return this.addChild(PathTree.split(path), 0, pathSeparator);
        }
        return null;
    }

    @NotNull
    private static List<String> split(@NotNull String path) {
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        return Splitter.on((char)'/').splitToList((CharSequence)systemIndependentPath);
    }

    @TestOnly
    @NotNull
    String print() {
        StringBuilder buffer = new StringBuilder();
        for (PathNode child : this.getChildren()) {
            child.print(buffer, 0);
        }
        return buffer.toString();
    }
}

