/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.tools.idea.apk.debugging.ApkClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApkPackage {
    @NotNull
    private final String myName;
    @NotNull
    private final String myFqn;
    @Nullable
    private final ApkPackage myParent;
    @NotNull
    private final Map<String, ApkPackage> mySubpackagesByName = new HashMap<String, ApkPackage>();
    @NotNull
    private final Map<String, ApkClass> myClassesByName = new HashMap<String, ApkClass>();

    public ApkPackage(@NotNull String name2, @Nullable ApkPackage parent) {
        this.myName = name2;
        this.myParent = parent;
        this.myFqn = this.myParent != null ? this.myParent.getFqn() + "." + this.myName : this.myName;
    }

    @NotNull
    public Collection<ApkPackage> getSubpackages() {
        return this.mySubpackagesByName.values();
    }

    @Nullable
    public ApkPackage findSubpackage(@NotNull String name2) {
        return this.mySubpackagesByName.get(name2);
    }

    @NotNull
    public Collection<ApkClass> getClasses() {
        return this.myClassesByName.values();
    }

    @Nullable
    public ApkClass findClass(@NotNull String name2) {
        return this.myClassesByName.get(name2);
    }

    @Nullable
    public ApkPackage getParent() {
        return this.myParent;
    }

    @NotNull
    public ApkPackage addSubpackage(@NotNull String name2) {
        return this.mySubpackagesByName.computeIfAbsent(name2, k -> new ApkPackage(name2, this));
    }

    @NotNull
    public ApkClass addClass(@NotNull String name2) {
        return this.myClassesByName.computeIfAbsent(name2, s -> new ApkClass(name2, this));
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getFqn() {
        return this.myFqn;
    }

    public boolean doSubpackagesHaveClasses() {
        for (ApkPackage subpackage : this.getSubpackages()) {
            if (subpackage.getClasses().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApkPackage)) {
            return false;
        }
        ApkPackage that = (ApkPackage)o;
        return Objects.equals(this.myName, that.myName) && Objects.equals(this.myFqn, that.myFqn) && Objects.equals(this.myParent, that.myParent);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myFqn, this.myParent);
    }

    public String toString() {
        return this.getFqn();
    }
}

