/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adblib;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.adblib.AdbUsageTracker;
import com.android.ide.common.util.DeviceUtils;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.wireless.android.sdk.stats.AdbUsageEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\f\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\f\u001a\u00020\u0011*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/adblib/AndroidAdbUsageTracker;", "Lcom/android/adblib/AdbUsageTracker;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "logUsage", "", "event", "Lcom/android/adblib/AdbUsageTracker$Event;", "toAndroidStudioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "toProtoEnum", "Lcom/google/wireless/android/sdk/stats/AdbUsageEvent$AdbDeviceStateChangeEvent$DeviceState;", "Lcom/android/adblib/AdbUsageTracker$DeviceState;", "Lcom/google/wireless/android/sdk/stats/AdbUsageEvent$JdwpProcessPropertiesCollectorEvent$FailureType;", "Lcom/android/adblib/AdbUsageTracker$JdwpProcessPropertiesCollectorFailureType;", "Lcom/google/wireless/android/sdk/stats/AdbUsageEvent$AppInfoProcessPropertiesCollectorEvent$EventType;", "Lcom/android/adblib/AdbUsageTracker$AppInfoProcessPropertiesCollectorEventType;", "toProto", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "Lcom/android/adblib/AdbUsageTracker$DeviceInfo;", "LOCAL_EMULATOR_REGEX", "Lkotlin/text/Regex;", "intellij.android.adb"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidAdbUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidAdbUsageTracker.kt\ncom/android/tools/idea/adblib/AndroidAdbUsageTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n24#2:169\n1#3:170\n*S KotlinDebug\n*F\n+ 1 AndroidAdbUsageTracker.kt\ncom/android/tools/idea/adblib/AndroidAdbUsageTracker\n*L\n31#1:169\n*E\n"})
public final class AndroidAdbUsageTracker
implements AdbUsageTracker {
    @NotNull
    private final Logger log;
    @NotNull
    private final Regex LOCAL_EMULATOR_REGEX;
    public static final int $stable = 8;

    public AndroidAdbUsageTracker() {
        AndroidAdbUsageTracker $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AndroidAdbUsageTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.LOCAL_EMULATOR_REGEX = new Regex("emulator-(\\d+)");
    }

    public void logUsage(@NotNull AdbUsageTracker.Event event) {
        AndroidStudioEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            builder = this.toAndroidStudioEvent(event);
        }
        catch (Throwable t) {
            this.log.warn("Could not build `AndroidStudioEvent` from `AdbUsageTracker.Event`", t);
            return;
        }
        AndroidStudioEvent.Builder studioEvent = builder;
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }

    private final AndroidStudioEvent.Builder toAndroidStudioEvent(AdbUsageTracker.Event $this$toAndroidStudioEvent) {
        AdbUsageTracker.JdwpProcessPropertiesCollectorEvent it;
        AndroidStudioEvent.Builder androidStudioEvent = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ADB_USAGE_EVENT);
        AdbUsageTracker.DeviceInfo deviceInfo2 = $this$toAndroidStudioEvent.getDeviceInfo();
        if (deviceInfo2 != null && (deviceInfo2 = this.toProto(deviceInfo2)) != null) {
            AdbUsageTracker.DeviceInfo it2 = deviceInfo2;
            boolean bl = false;
            androidStudioEvent.setDeviceInfo((DeviceInfo)it2);
        }
        AdbUsageTracker.JdwpProcessPropertiesCollectorEvent jdwpProcessPropertiesCollectorEvent = $this$toAndroidStudioEvent.getJdwpProcessPropertiesCollector();
        if (jdwpProcessPropertiesCollectorEvent != null) {
            AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType previousFailureType;
            AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType failureType;
            it = jdwpProcessPropertiesCollectorEvent;
            boolean bl = false;
            androidStudioEvent.getAdbUsageEventBuilder().getProcessPropertiesEventBuilder().setSuccess(it.isSuccess()).setPreviouslyFailedCount(it.getPreviouslyFailedCount());
            AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType jdwpProcessPropertiesCollectorFailureType = it.getFailureType();
            AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType failureType2 = failureType = jdwpProcessPropertiesCollectorFailureType != null ? this.toProtoEnum(jdwpProcessPropertiesCollectorFailureType) : null;
            if (failureType != null) {
                androidStudioEvent.getAdbUsageEventBuilder().getProcessPropertiesEventBuilder().setFailureType(failureType);
            }
            AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType jdwpProcessPropertiesCollectorFailureType2 = it.getPreviousFailureType();
            AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType failureType3 = previousFailureType = jdwpProcessPropertiesCollectorFailureType2 != null ? this.toProtoEnum(jdwpProcessPropertiesCollectorFailureType2) : null;
            if (previousFailureType != null) {
                androidStudioEvent.getAdbUsageEventBuilder().getProcessPropertiesEventBuilder().setPreviousFailureType(previousFailureType);
            }
        }
        AdbUsageTracker.AppInfoProcessPropertiesCollectorEvent appInfoProcessPropertiesCollectorEvent = $this$toAndroidStudioEvent.getAppInfoProcessPropertiesCollector();
        if (appInfoProcessPropertiesCollectorEvent != null) {
            it = appInfoProcessPropertiesCollectorEvent;
            boolean bl = false;
            androidStudioEvent.getAdbUsageEventBuilder().getAppInfoProcessPropertiesEventBuilder().setEventType(this.toProtoEnum(it.getEventType()));
        }
        AdbUsageTracker.AdbDeviceStateChangeEvent adbDeviceStateChangeEvent = $this$toAndroidStudioEvent.getAdbDeviceStateChange();
        if (adbDeviceStateChangeEvent != null) {
            AdbUsageTracker.AdbDeviceStateChangeEvent deviceStateChange = adbDeviceStateChangeEvent;
            boolean bl = false;
            AdbUsageEvent.AdbDeviceStateChangeEvent.Builder builder = androidStudioEvent.getAdbUsageEventBuilder().getDeviceStateChangeEventBuilder();
            builder.setDeviceState(this.toProtoEnum(deviceStateChange.getDeviceState()));
            AdbUsageTracker.DeviceState deviceState2 = deviceStateChange.getPreviousDeviceState();
            if (deviceState2 != null) {
                AdbUsageTracker.DeviceState it3 = deviceState2;
                boolean bl2 = false;
                builder.setPreviousDeviceState(this.toProtoEnum(it3));
            }
            Long l = deviceStateChange.getLastOnlineMs();
            if (l != null) {
                long it4 = ((Number)l).longValue();
                boolean bl3 = false;
                builder.setLastOnlineMs(it4);
            }
        }
        Intrinsics.checkNotNull((Object)androidStudioEvent);
        return androidStudioEvent;
    }

    private final AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState toProtoEnum(AdbUsageTracker.DeviceState $this$toProtoEnum) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toProtoEnum.ordinal()]) {
            case 1 -> AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState.BOOTLOADER;
            case 2 -> AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState.AUTHORIZING;
            case 3 -> AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState.CONNECTING;
            case 4 -> AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState.OFFLINE;
            case 5 -> AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState.ONLINE;
            case 6 -> AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState.DISCONNECTED;
            case 7 -> AdbUsageEvent.AdbDeviceStateChangeEvent.DeviceState.OTHER;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType toProtoEnum(AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType $this$toProtoEnum) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toProtoEnum.ordinal()]) {
            case 1 -> AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType.NO_RESPONSE;
            case 2 -> AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType.CLOSED_CHANNEL_EXCEPTION;
            case 3 -> AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType.CONNECTION_CLOSED_ERROR;
            case 4 -> AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType.IO_EXCEPTION;
            case 5 -> AdbUsageEvent.JdwpProcessPropertiesCollectorEvent.FailureType.OTHER_ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final AdbUsageEvent.AppInfoProcessPropertiesCollectorEvent.EventType toProtoEnum(AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType $this$toProtoEnum) {
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toProtoEnum.ordinal()]) {
            case 1 -> AdbUsageEvent.AppInfoProcessPropertiesCollectorEvent.EventType.TRACK_APP_VALUE_COLLECTED;
            case 2 -> AdbUsageEvent.AppInfoProcessPropertiesCollectorEvent.EventType.VM_INFO_VALUE_COLLECTED;
            case 3 -> AdbUsageEvent.AppInfoProcessPropertiesCollectorEvent.EventType.TRACK_APP_IO_EXCEPTION;
            case 4 -> AdbUsageEvent.AppInfoProcessPropertiesCollectorEvent.EventType.TRACK_APP_OTHER_EXCEPTION;
            case 5 -> AdbUsageEvent.AppInfoProcessPropertiesCollectorEvent.EventType.VM_INFO_IO_EXCEPTION;
            case 6 -> AdbUsageEvent.AppInfoProcessPropertiesCollectorEvent.EventType.VM_INFO_OTHER_EXCEPTION;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final DeviceInfo toProto(AdbUsageTracker.DeviceInfo $this$toProto) {
        DeviceInfo.MdnsConnectionType mdnsConnectionType = DeviceUtils.isMdnsAutoConnectUnencrypted((String)$this$toProto.getSerialNumber()) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_UNENCRYPTED : (DeviceUtils.isMdnsAutoConnectTls((String)$this$toProto.getSerialNumber()) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_TLS : DeviceInfo.MdnsConnectionType.MDNS_NONE);
        DeviceInfo.DeviceType deviceType = this.LOCAL_EMULATOR_REGEX.matches((CharSequence)$this$toProto.getSerialNumber()) ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL;
        DeviceInfo deviceInfo2 = DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)$this$toProto.getSerialNumber())).setBuildTags($this$toProto.getBuildTags()).setBuildType($this$toProto.getBuildType()).setBuildVersionRelease($this$toProto.getBuildVersionRelease()).setBuildApiLevelFull($this$toProto.getBuildApiLevelFull()).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)$this$toProto.getCpuAbi())).setManufacturer($this$toProto.getManufacturer()).setDeviceType(deviceType).setMdnsConnectionType(mdnsConnectionType).addAllCharacteristics((Iterable)$this$toProto.getAllCharacteristics()).setModel($this$toProto.getModel()).build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceInfo2, (String)"build(...)");
        return deviceInfo2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[AdbUsageTracker.DeviceState.values().length];
            try {
                nArray[AdbUsageTracker.DeviceState.BOOTLOADER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.DeviceState.AUTHORIZING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.DeviceState.CONNECTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.DeviceState.OFFLINE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.DeviceState.ONLINE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.DeviceState.DISCONNECTED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.DeviceState.OTHER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType.values().length];
            try {
                nArray[AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType.NO_RESPONSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType.CLOSED_CHANNEL_EXCEPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType.CONNECTION_CLOSED_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType.IO_EXCEPTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.JdwpProcessPropertiesCollectorFailureType.OTHER_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType.values().length];
            try {
                nArray[AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType.TRACK_APP_VALUE_COLLECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType.VM_INFO_VALUE_COLLECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType.TRACK_APP_IO_EXCEPTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType.TRACK_APP_OTHER_EXCEPTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType.VM_INFO_IO_EXCEPTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbUsageTracker.AppInfoProcessPropertiesCollectorEventType.VM_INFO_OTHER_EXCEPTION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

