/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.adb.wireless.EditorPaneUtils;
import com.android.tools.idea.adb.wireless.UIColors;
import com.android.utils.HtmlBuilder;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

@UiThread
public class WiFiPairingCenterPanel {
    @NotNull
    private JPanel myContentPanel;
    @NotNull
    private JPanel myErrorContainerPanel;
    @NotNull
    private JEditorPane myErrorText;
    @NotNull
    private JPanel myRoot;
    @NotNull
    private JBScrollPane myScrollPane;
    @NotNull
    private JPanel myErrorTopPanel;
    @NotNull
    private JPanel myErrorBottomPanel;
    @NotNull
    private JPanel myErrorTextPanel;

    public WiFiPairingCenterPanel(HyperlinkListener hyperlinkListener) {
        this.setupUI();
        this.myContentPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myErrorTextPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myErrorText.setFont((Font)AdtUiUtils.EMPTY_TOOL_WINDOW_FONT);
        this.myErrorText.setForeground(UIColors.ERROR_TEXT);
        this.myErrorText.addHyperlinkListener(hyperlinkListener);
        CustomLineBorder line = new CustomLineBorder(UIColors.ONE_PIXEL_DIVIDER, 1, 0, 0, 0);
        CompoundBorder c = new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)5, (int)0));
        this.myErrorTopPanel.setBorder(c);
        this.myErrorTopPanel.setMinimumSize((Dimension)new JBDimension(0, 30));
        CustomLineBorder line2 = new CustomLineBorder(UIColors.ONE_PIXEL_DIVIDER, 0, 0, 1, 0);
        CompoundBorder c2 = new CompoundBorder((Border)line2, (Border)JBUI.Borders.empty((int)5, (int)0));
        this.myErrorBottomPanel.setBorder(c2);
        this.myErrorBottomPanel.setMinimumSize((Dimension)new JBDimension(0, 30));
        this.myErrorTextPanel.setBorder((Border)new CustomLineBorder(UIColors.ONE_PIXEL_DIVIDER, 1, 1, 1, 1));
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRoot;
    }

    public void setContentComponent(@NotNull JComponent component) {
        this.myContentPanel.removeAll();
        this.myContentPanel.add((Component)component, "Center");
    }

    public void showEmptyContent() {
        this.showError(new HtmlBuilder());
    }

    public void showError(@NotNull HtmlBuilder html) {
        EditorPaneUtils.setHtml(this.myErrorText, html, null);
        this.myScrollPane.setVisible(false);
        this.myErrorContainerPanel.setVisible(true);
    }

    public void showContent() {
        this.myErrorText.setText("");
        this.myScrollPane.setVisible(true);
        this.myErrorContainerPanel.setVisible(false);
    }

    private void createUIComponents() {
        this.myErrorText = EditorPaneUtils.createHtmlEditorPane();
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRoot = new JPanel();
        this.myRoot.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myScrollPane = new JBScrollPane();
        this.myRoot.add((Component)this.myScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout(new BorderLayout(0, 0));
        this.myScrollPane.setViewportView((Component)this.myContentPanel);
        this.myErrorContainerPanel = new JPanel();
        this.myErrorContainerPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myRoot.add((Component)this.myErrorContainerPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.myErrorTopPanel = new JPanel();
        this.myErrorTopPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myErrorContainerPanel.add((Component)this.myErrorTopPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setHorizontalAlignment(0);
        jBLabel1.setHorizontalTextPosition(0);
        jBLabel1.setText("");
        this.myErrorTopPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 4, null, null, null, 0, false));
        this.myErrorTextPanel = new JPanel();
        this.myErrorTextPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myErrorContainerPanel.add((Component)this.myErrorTextPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myErrorText.setName("errorText");
        this.myErrorText.setText("");
        this.myErrorTextPanel.add((Component)this.myErrorText, new GridConstraints(1, 1, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myErrorTextPanel.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myErrorTextPanel.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myErrorTextPanel.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 1, new Dimension(50, 0), null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myErrorTextPanel.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 1, new Dimension(50, 0), null, null, 0, false));
        this.myErrorBottomPanel = new JPanel();
        this.myErrorBottomPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myErrorContainerPanel.add((Component)this.myErrorBottomPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(0);
        jBLabel2.setHorizontalTextPosition(0);
        jBLabel2.setText("");
        this.myErrorBottomPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 4, null, null, null, 0, false));
    }
}

