/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.FutureUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/adb/PackageNameProvider;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getPackageName", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "project", "Lcom/intellij/openapi/project/Project;", "deviceSerialNumber", "processName", "intellij.android.adb"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPackageNameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageNameProvider.kt\ncom/android/tools/idea/adb/PackageNameProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class PackageNameProvider {
    @NotNull
    public static final PackageNameProvider INSTANCE = new PackageNameProvider();
    @NotNull
    private static final Logger logger;
    private static final ExecutorService taskExecutor;
    public static final int $stable;

    private PackageNameProvider() {
    }

    @NotNull
    public final ListenableFuture<String> getPackageName(@NotNull Project project, @NotNull String deviceSerialNumber, @NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)deviceSerialNumber, (String)"deviceSerialNumber");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        File file = AdbFileProvider.Companion.fromProject(project).get();
        if (file == null) {
            throw new IllegalStateException("adb not found");
        }
        File adb = file;
        ListenableFuture<AndroidDebugBridge> listenableFuture = AdbService.getInstance().getDebugBridge(adb);
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"getDebugBridge(...)");
        ExecutorService executorService = taskExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"taskExecutor");
        return FutureUtils.transform(listenableFuture, (Executor)executorService, arg_0 -> PackageNameProvider.getPackageName$lambda$1(processName, deviceSerialNumber, arg_0));
    }

    private static final String getPackageName$lambda$1(String $processName, String $deviceSerialNumber, AndroidDebugBridge androidDebugBridge) {
        String string;
        Object object;
        block4: {
            IDevice[] iDeviceArray = androidDebugBridge.getDevices();
            Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"getDevices(...)");
            for (Object object2 : (Object[])iDeviceArray) {
                IDevice it = (IDevice)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$deviceSerialNumber, (Object)it.getSerialNumber())) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        IDevice device2 = (IDevice)object;
        if (device2 == null) {
            logger.info("Can't find device from serial number.");
            return $processName;
        }
        Client client = device2.getClient($processName);
        String packageName = client.getClientData().getPackageName();
        if (packageName == null) {
            logger.info("Can't find package name.");
            string = $processName;
        } else {
            string = packageName;
        }
        return string;
    }

    static {
        Logger logger = Logger.getInstance(PackageNameProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PackageNameProvider.logger = logger;
        taskExecutor = PooledThreadExecutor.INSTANCE;
        $stable = 8;
    }
}

