/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.ddmlib.Log;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbLogOutput {

    public static class ToStringLogger
    implements Log.ILogOutput {
        private final StringBuilder sb = new StringBuilder(100);

        public void printLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            this.append(message);
        }

        public void printAndPromptLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            this.append(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void append(String message) {
            if (!StringUtil.isEmpty((String)message)) {
                StringBuilder stringBuilder = this.sb;
                synchronized (stringBuilder) {
                    this.sb.append(message).append('\n');
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public String getOutput() {
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                return this.sb.toString();
            }
        }
    }

    public static class SystemLogRedirecter
    implements Log.ILogOutput {
        private static final NotificationGroup EVENT_LOG = NotificationGroupManager.getInstance().getNotificationGroup("ADB Logs");
        private static final Logger LOG = Logger.getInstance((String)"#com.android.ddmlib");

        public void printLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message);
        }

        public void printAndPromptLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message);
        }

        public static Logger getLogger() {
            return LOG;
        }

        private static void reportAdbLog(@Nullable Log.LogLevel logLevel, @Nullable String tag, @Nullable String message) {
            if (StringUtil.isEmpty((String)message)) {
                return;
            }
            if (logLevel == null) {
                logLevel = Log.LogLevel.DEBUG;
            }
            switch (logLevel) {
                case VERBOSE: 
                case DEBUG: {
                    LOG.debug(message);
                    break;
                }
                case INFO: {
                    LOG.info(message);
                    break;
                }
                case WARN: {
                    LOG.warn(message);
                    break;
                }
                case ERROR: 
                case ASSERT: {
                    LOG.warn(message);
                    EVENT_LOG.createNotification(message, MessageType.WARNING).notify(null);
                }
            }
        }
    }
}

