/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.componenttree.api.BadgeItem;
import com.android.tools.componenttree.treetable.Cell;
import com.android.tools.componenttree.treetable.IntTableCellRendererKt;
import com.android.tools.componenttree.treetable.TreeTableImplKt;
import com.intellij.ui.NewUI;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0014\u0010\u0019\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/componenttree/treetable/BadgeRenderer;", "Ljavax/swing/table/TableCellRenderer;", "Lcom/intellij/ui/components/JBLabel;", "badge", "Lcom/android/tools/componenttree/api/BadgeItem;", "emptyIcon", "Ljavax/swing/Icon;", "<init>", "(Lcom/android/tools/componenttree/api/BadgeItem;Ljavax/swing/Icon;)V", "getBadge", "()Lcom/android/tools/componenttree/api/BadgeItem;", "getEmptyIcon", "()Ljavax/swing/Icon;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "white", "focused", "intellij.android.layout-ui"})
public final class BadgeRenderer
extends JBLabel
implements TableCellRenderer {
    @NotNull
    private final BadgeItem badge;
    @NotNull
    private final Icon emptyIcon;

    public BadgeRenderer(@NotNull BadgeItem badge, @NotNull Icon emptyIcon) {
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        Intrinsics.checkNotNullParameter((Object)emptyIcon, (String)"emptyIcon");
        this.badge = badge;
        this.emptyIcon = emptyIcon;
        this.setHorizontalAlignment(0);
        this.setText(null);
        this.setBorder(IntTableCellRendererKt.createBorder(this.badge));
    }

    @NotNull
    public final BadgeItem getBadge() {
        return this.badge;
    }

    @NotNull
    public final Icon getEmptyIcon() {
        return this.emptyIcon;
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        boolean focused = isSelected && table2.hasFocus();
        Cell hoverCell = TreeTableImplKt.getHoverCell(table2);
        this.setBackground(UIUtil.getTreeBackground((boolean)isSelected, (boolean)focused));
        Cell cell = hoverCell;
        Icon hoverIcon = (cell != null ? cell.equalTo(row, column2) : false) ? this.badge.getHoverIcon(value2) : null;
        Icon icon2 = hoverIcon;
        if (icon2 == null) {
            icon2 = icon = this.badge.getIcon(value2);
        }
        if (icon2 == null || (icon = this.white(icon, focused)) == null) {
            icon = this.emptyIcon;
        }
        this.setIcon(icon);
        this.setToolTipText(this.badge.getTooltipText(value2));
        return (Component)((Object)this);
    }

    private final Icon white(Icon $this$white, boolean focused) {
        return focused && !NewUI.isEnabled() ? ColoredIconGenerator.generateWhiteIcon((Icon)$this$white) : $this$white;
    }
}

