/*
 * Decompiled with CFR 0.152.
 */
package com.android.sync.analyzer;

import com.android.build.attribution.analytics.BuildAttributionAnalyticsManagerKt;
import com.android.build.output.DownloadsInfoPresentableBuildEvent;
import com.android.sync.analyzer.SyncAnalyzerDataManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.SyncAnalyzerManager;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010\u0010\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/sync/analyzer/SyncAnalyzerManagerImpl;", "Lcom/android/tools/idea/gradle/project/sync/SyncAnalyzerManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "updateSyncStatsData", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "syncStats", "Lcom/google/wireless/android/sdk/stats/GradleSyncStats$Builder;", "onSyncStarted", "onSyncFinished", "setUpDownloadsInfoNodeOnBuildOutput", "dataHolder", "Lcom/android/sync/analyzer/SyncAnalyzerDataManager$DataHolder;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nSyncAnalyzerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncAnalyzerManagerImpl.kt\ncom/android/sync/analyzer/SyncAnalyzerManagerImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,124:1\n30#2,2:125\n30#2,2:127\n30#2,2:129\n*S KotlinDebug\n*F\n+ 1 SyncAnalyzerManagerImpl.kt\ncom/android/sync/analyzer/SyncAnalyzerManagerImpl\n*L\n51#1:125,2\n59#1:127,2\n66#1:129,2\n*E\n"})
public final class SyncAnalyzerManagerImpl
implements SyncAnalyzerManager {
    @NotNull
    private final Project project;

    public SyncAnalyzerManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void updateSyncStatsData(@Nullable ExternalSystemTaskId id2, @NotNull GradleSyncStats.Builder syncStats) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)syncStats, (String)"syncStats");
            if (id2 == null) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<SyncAnalyzerDataManager> serviceClass$iv = SyncAnalyzerDataManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            SyncAnalyzerDataManager.DataHolder dataHolder = ((SyncAnalyzerDataManager)object).getDataForTaskIfExists(id2);
            if (dataHolder == null) break block2;
            SyncAnalyzerDataManager.DataHolder downloadsData = dataHolder;
            boolean bl = false;
            syncStats.setDownloadsData(BuildAttributionAnalyticsManagerKt.transformDownloadsAnalyzerData(downloadsData.getDownloadsStatsAccumulator().getRepositoryResults()));
        }
    }

    @Override
    public void onSyncStarted(@Nullable ExternalSystemTaskId id2) {
        if (id2 == null) {
            return;
        }
        if (StudioFlags.isBuildOutputShowsDownloadInfo().booleanValue()) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<SyncAnalyzerDataManager> serviceClass$iv = SyncAnalyzerDataManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            SyncAnalyzerDataManager.DataHolder data2 = ((SyncAnalyzerDataManager)object).getOrCreateDataForTask(id2);
            this.setUpDownloadsInfoNodeOnBuildOutput(this.project, id2, data2);
        }
    }

    @Override
    public void onSyncFinished(@Nullable ExternalSystemTaskId id2) {
        if (id2 == null) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<SyncAnalyzerDataManager> serviceClass$iv = SyncAnalyzerDataManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((SyncAnalyzerDataManager)object).clearDataForTask(id2);
    }

    private final void setUpDownloadsInfoNodeOnBuildOutput(Project $this$setUpDownloadsInfoNodeOnBuildOutput, ExternalSystemTaskId id2, SyncAnalyzerDataManager.DataHolder dataHolder) {
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion($this$setUpDownloadsInfoNodeOnBuildOutput);
        DownloadsInfoPresentableBuildEvent rootDownloadEvent = new DownloadsInfoPresentableBuildEvent(id2, dataHolder.getBuildDisposable(), dataHolder.getBuildStartTimestampMs(), gradleVersion2, dataHolder.getDownloadsInfoDataModel());
        SyncViewManager viewManager = (SyncViewManager)$this$setUpDownloadsInfoNodeOnBuildOutput.getService(SyncViewManager.class);
        viewManager.onEvent((Object)id2, (BuildEvent)rootDownloadEvent);
    }
}

