/*
 * Decompiled with CFR 0.152.
 */
package com.android.flags;

import com.android.flags.Flag;
import com.android.flags.FlagValueContainer;
import com.android.flags.FlagValueProvider;
import com.android.flags.overrides.InMemoryFlagValueContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.VisibleForTesting;

public final class Flags {
    private final Map<String, Flag<?>> registeredFlags = Collections.synchronizedMap(new HashMap());
    private final FlagValueProvider fileBasedDefaultProvider;
    private final FlagValueContainer userOverrides;
    private final FlagValueProvider[] fallbackProviders;

    public Flags(FlagValueProvider fileBasedDefaultProvider, FlagValueContainer userOverrides, FlagValueProvider ... fallbackProviders) {
        this.fileBasedDefaultProvider = fileBasedDefaultProvider;
        this.userOverrides = userOverrides;
        this.fallbackProviders = fallbackProviders;
    }

    @VisibleForTesting
    public Flags(FlagValueProvider ... immutableOverrides) {
        this((FlagValueProvider)new InMemoryFlagValueContainer(), new InMemoryFlagValueContainer(), immutableOverrides);
    }

    public FlagValueContainer getUserOverrides() {
        return this.userOverrides;
    }

    String getValue(Flag<?> flag) {
        String flagValue = this.userOverrides.get(flag);
        if (flagValue != null) {
            return flagValue;
        }
        for (FlagValueProvider flagOverrides : this.fallbackProviders) {
            flagValue = flagOverrides.get(flag);
            if (flagValue == null) continue;
            return flagValue;
        }
        return this.fileBasedDefaultProvider.get(flag);
    }

    void register(Flag<?> flag) {
        Flag<?> existingFlag = this.registeredFlags.putIfAbsent(flag.getId(), flag);
        if (existingFlag != null) {
            throw new IllegalArgumentException(String.format("Flag \"%s\" shares duplicate ID \"%s\" with flag \"%s\"", flag.getDisplayName(), flag.getId(), existingFlag.getDisplayName()));
        }
    }

    public Flag<?> getFlag(String id2) {
        return this.registeredFlags.get(id2);
    }

    public void validate() {
        for (Flag<?> flag : this.registeredFlags.values()) {
            flag.validate();
        }
    }
}

