/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface CriticalPathChartLegend {
    public static final ChartColor OTHER_TASKS_COLOR = new ChartColor(new Color(10674174));
    public static final Color OTHER_TASKS_TEXT_COLOR = Color.BLACK;
    public static final ChartColor androidPluginColor = new ChartColor(new Color(10674174));
    public static final ChartColor externalPluginColor = new ChartColor(new Color(38901));
    public static final ChartColor buildscriptPluginColor = new ChartColor(new Color(10980313));
    public static final ChartColor[] categoricalGooglePalette = new ChartColor[]{new ChartColor(new Color(9941440)), new ChartColor(new Color(10674174)), new ChartColor(new Color(16227438)), new ChartColor(new Color(7660168)), new ChartColor(new Color(10980313)), new ChartColor(new Color(15101850)), new ChartColor(new Color(5432783)), new ChartColor(new Color(14666911)), new ChartColor(new Color(37844)), new ChartColor(new Color(1412991)), new ChartColor(new Color(8539103)), new ChartColor(new Color(12670746)), new ChartColor(new Color(3365529)), new ChartColor(new Color(11381816)), new ChartColor(new Color(12073102)), new ChartColor(new Color(1735423))};
    public static final PluginColorPalette pluginColorPalette = new PluginColorPalette();

    public static ChartColor resolveTaskColor(TaskUiData taskData) {
        switch (taskData.getSourceType()) {
            case BUILD_SCRIPT: {
                return buildscriptPluginColor;
            }
            case ANDROID_PLUGIN: {
                return androidPluginColor;
            }
            case THIRD_PARTY: {
                return externalPluginColor;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)taskData.getSourceType()));
    }

    public static class ChartColor {
        public final Color baseColor;
        public final Color selectionColor;

        public ChartColor(Color baseColor) {
            this.baseColor = baseColor;
            this.selectionColor = new Color(baseColor.getRed() / 2, baseColor.getGreen() / 2, baseColor.getBlue() / 2);
        }
    }

    public static class PluginColorPalette {
        private int paletteCursor = 0;
        private Map<String, ChartColor> pluginToColorMapping = new HashMap<String, ChartColor>();

        public void reset() {
            this.paletteCursor = 0;
            this.pluginToColorMapping.clear();
        }

        @NotNull
        public ChartColor getColor(@NotNull String name2) {
            return this.pluginToColorMapping.computeIfAbsent(name2, key -> categoricalGooglePalette[Math.min(this.paletteCursor++, categoricalGooglePalette.length - 1)]);
        }

        @NotNull
        public ChartColor getOneColorForAll(@NotNull ArrayList<CriticalPathPluginUiData> aggregatedPlugins) {
            ChartColor otherPluginsGroupColor = this.getColor("Other");
            aggregatedPlugins.forEach(plugin -> this.pluginToColorMapping.put(plugin.getName(), otherPluginsGroupColor));
            return otherPluginsGroupColor;
        }
    }
}

