/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.tools.idea.flags.StudioFlags;
import com.android.utils.HtmlBuilder;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a$\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\u000f\u001a\u00020\r*\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"taskDetailsPage", "Ljavax/swing/JComponent;", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "NO_PLUGIN_INFO_HELP_TEXT", "", "pluginNameHtml", "taskDetailsPanelHtml", "linksHandler", "Lcom/android/build/attribution/ui/HtmlLinksHandler;", "createWarningsSection", "", "Lcom/android/utils/HtmlBuilder;", "createReasonsSection", "reasons", "", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAttributionPanels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAttributionPanels.kt\ncom/android/build/attribution/ui/panels/BuildAttributionPanelsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1869#2,2:133\n1869#2,2:135\n*S KotlinDebug\n*F\n+ 1 BuildAttributionPanels.kt\ncom/android/build/attribution/ui/panels/BuildAttributionPanelsKt\n*L\n109#1:133,2\n125#1:135,2\n*E\n"})
public final class BuildAttributionPanelsKt {
    @NotNull
    private static final String NO_PLUGIN_INFO_HELP_TEXT = "Gradle did not provide plugin information for this task due to Configuration cache being enabled and its entry being reused.";

    @NotNull
    public static final JComponent taskDetailsPage(@NotNull TaskUiData taskData, @NotNull ViewActionHandlers actionHandlers) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        JPanel $this$taskDetailsPage_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$taskDetailsPage_u24lambda_u240.setLayout(new BoxLayout($this$taskDetailsPage_u24lambda_u240, 1));
        HtmlLinksHandler linksHandler = new HtmlLinksHandler(actionHandlers);
        String detailsPanelHtml = BuildAttributionPanelsKt.taskDetailsPanelHtml(taskData, actionHandlers, linksHandler);
        JEditorPane htmlLabel = BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(detailsPanelHtml, linksHandler);
        htmlLabel.setAlignmentX(0.0f);
        $this$taskDetailsPage_u24lambda_u240.add(htmlLabel);
        return jPanel;
    }

    private static final String pluginNameHtml(TaskUiData taskData) {
        return taskData.getPluginUnknownBecauseOfCC() ? "N/A " + BuildAttributionUIUtilKt.helpIcon(NO_PLUGIN_INFO_HELP_TEXT) : taskData.getPluginName();
    }

    @NotNull
    public static final String taskDetailsPanelHtml(@NotNull TaskUiData taskData, @NotNull ViewActionHandlers actionHandlers, @NotNull HtmlLinksHandler linksHandler) {
        HtmlBuilder htmlBuilder;
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        Intrinsics.checkNotNullParameter((Object)linksHandler, (String)"linksHandler");
        HtmlBuilder $this$taskDetailsPanelHtml_u24lambda_u242 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        $this$taskDetailsPanelHtml_u24lambda_u242.addBold(taskData.getTaskPath()).newline();
        if (taskData.getOnLogicalCriticalPath()) {
            $this$taskDetailsPanelHtml_u24lambda_u242.add("This task frequently determines build duration because of dependencies").newline().add("between its inputs/outputs and other tasks.").newline();
        } else if (taskData.getOnExtendedCriticalPath()) {
            $this$taskDetailsPanelHtml_u24lambda_u242.add("This task occasionally determines build duration because of parallelism constraints").newline().add("introduced by number of cores or other tasks in the same module.").newline();
        }
        $this$taskDetailsPanelHtml_u24lambda_u242.newline();
        $this$taskDetailsPanelHtml_u24lambda_u242.addBold("Duration:").addHtml("  " + BuildAttributionUIUtilKt.durationStringHtml(taskData.getExecutionTime()) + " / " + BuildAttributionUIUtilKt.percentageStringHtml(taskData.getExecutionTime())).newline();
        $this$taskDetailsPanelHtml_u24lambda_u242.add("Sub-project: " + taskData.getModule()).newline();
        $this$taskDetailsPanelHtml_u24lambda_u242.addHtml("Plugin: " + BuildAttributionPanelsKt.pluginNameHtml(taskData)).newline();
        $this$taskDetailsPanelHtml_u24lambda_u242.add("Type: " + taskData.getTaskType()).newline();
        if (((Boolean)StudioFlags.BUILD_ANALYZER_CATEGORY_ANALYSIS.get()).booleanValue()) {
            List taskCategories = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)taskData.getPrimaryTaskCategory()), (Iterable)taskData.getSecondaryTaskCategories());
            $this$taskDetailsPanelHtml_u24lambda_u242.add("Task Execution Categories: " + CollectionsKt.joinToString$default((Iterable)taskCategories, null, null, null, (int)0, null, BuildAttributionPanelsKt::taskDetailsPanelHtml$lambda$2$lambda$1, (int)31, null)).newline();
        }
        $this$taskDetailsPanelHtml_u24lambda_u242.newline();
        BuildAttributionPanelsKt.createWarningsSection($this$taskDetailsPanelHtml_u24lambda_u242, taskData, actionHandlers, linksHandler);
        BuildAttributionPanelsKt.createReasonsSection($this$taskDetailsPanelHtml_u24lambda_u242, taskData.getReasonsToRun());
        String string = htmlBuilder.getHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHtml(...)");
        return string;
    }

    private static final void createWarningsSection(HtmlBuilder $this$createWarningsSection, TaskUiData taskData, ViewActionHandlers actionHandlers, HtmlLinksHandler linksHandler) {
        $this$createWarningsSection.addBold("Warnings").newline();
        if (taskData.getIssues().isEmpty() && taskData.getRelatedTaskCategoryIssues().isEmpty()) {
            $this$createWarningsSection.add("No warnings found").newline();
            v0 = $this$createWarningsSection.newline();
        } else {
            if (taskData.getSourceType() != PluginSourceType.BUILD_SCRIPT && !((Collection)taskData.getIssues()).isEmpty()) {
                String generateReportLink = linksHandler.actionLink("Generate report", "generateReport", () -> BuildAttributionPanelsKt.createWarningsSection$lambda$3(actionHandlers, taskData));
                $this$createWarningsSection.addHtml("Consider filing a bug to report this issue to the plugin developer. " + generateReportLink);
            }
            $this$createWarningsSection.beginTable();
            if (!((Collection)taskData.getRelatedTaskCategoryIssues()).isEmpty()) {
                String redirectLink = linksHandler.actionLink(BuildAttributionUIUtilKt.displayName(taskData.getPrimaryTaskCategory()), taskData.getPrimaryTaskCategory().name(), () -> BuildAttributionPanelsKt.createWarningsSection$lambda$4(actionHandlers, taskData));
                String[] stringArray = new String[]{"<icon alt='Warning' src='AllIcons.General.BalloonWarning'>", "This task is impacted by " + BuildAttributionUIUtilKt.withPluralization(taskData.getRelatedTaskCategoryIssues().size(), "issue") + " found in the " + redirectLink + " category."};
                $this$createWarningsSection.addTableRow(stringArray);
            }
            Iterable $this$forEach$iv = taskData.getIssues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskIssueUiData issue2 = (TaskIssueUiData)element$iv;
                boolean bl = false;
                String description2 = issue2.getExplanation() + "\n" + linksHandler.externalLink("Learn more", issue2.getHelpLink());
                String[] stringArray = new String[]{"<icon alt='Warning' src='AllIcons.General.BalloonWarning'>", "<B>" + issue2.getType().getUiName() + "</B>"};
                $this$createWarningsSection.addTableRow(stringArray);
                stringArray = new String[]{"", StringsKt.replace$default((String)description2, (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null)};
                $this$createWarningsSection.addTableRow(stringArray);
                stringArray = new String[]{"", "<B>Recommendation:</B> " + StringsKt.replace$default((String)issue2.getBuildSrcRecommendation(), (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null)};
                $this$createWarningsSection.addTableRow(stringArray);
            }
            v0 = $this$createWarningsSection.endTable();
        }
    }

    private static final void createReasonsSection(HtmlBuilder $this$createReasonsSection, List<String> reasons) {
        $this$createReasonsSection.addBold("Reason task ran").newline();
        if (reasons.isEmpty()) {
            $this$createReasonsSection.add("No info");
        } else {
            Iterable $this$forEach$iv = reasons;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                $this$createReasonsSection.addHtml(StringsKt.replace$default((String)it, (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null)).newline();
            }
        }
    }

    private static final CharSequence taskDetailsPanelHtml$lambda$2$lambda$1(TaskCategory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildAttributionUIUtilKt.displayName(it);
    }

    private static final void createWarningsSection$lambda$3(ViewActionHandlers $actionHandlers, TaskUiData $taskData) {
        $actionHandlers.generateReportClicked($taskData);
    }

    private static final void createWarningsSection$lambda$4(ViewActionHandlers $actionHandlers, TaskUiData $taskData) {
        $actionHandlers.redirectToTaskCategoryWarningsPage($taskData.getPrimaryTaskCategory());
    }
}

