/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.CriticalPathEntriesUiData;
import com.android.build.attribution.ui.data.CriticalPathEntryUiData;
import com.android.build.attribution.ui.data.CriticalPathTaskCategoriesUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.EntryDetailsNodeDescriptor;
import com.android.build.attribution.ui.model.TaskDetailsNodeDescriptor;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksFilter;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreeNode;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.TimeDistributionBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/android/build/attribution/ui/model/TasksTreeStructure;", "", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "<init>", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;)V", "getReportData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "pageIdToNode", "", "Lcom/android/build/attribution/ui/model/TasksPageId;", "Lcom/android/build/attribution/ui/model/TasksTreeNode;", "getPageIdToNode", "()Ljava/util/Map;", "treeRoot", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getTreeRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "treeStats", "Lcom/android/build/attribution/ui/model/TasksTreeStructure$TreeStats;", "getTreeStats", "()Lcom/android/build/attribution/ui/model/TasksTreeStructure$TreeStats;", "setTreeStats", "(Lcom/android/build/attribution/ui/model/TasksTreeStructure$TreeStats;)V", "treeNode", "descriptor", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "updateStructure", "", "grouping", "Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "filter", "Lcom/android/build/attribution/ui/model/TasksFilter;", "createUngroupedNodes", "createGroupedByEntryNodes", "criticalPathEntry", "Lcom/android/build/attribution/ui/data/CriticalPathEntriesUiData;", "TreeStats", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTasksDataPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/TasksTreeStructure\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,436:1\n1#2:437\n1321#3,2:438\n1869#4:440\n774#4:441\n865#4,2:442\n1869#4,2:444\n1870#4:446\n*S KotlinDebug\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/TasksTreeStructure\n*L\n258#1:438,2\n266#1:440\n267#1:441\n267#1:442,2\n270#1:444,2\n266#1:446\n*E\n"})
final class TasksTreeStructure {
    @NotNull
    private final BuildAttributionReportUiData reportData;
    @NotNull
    private final Map<TasksPageId, TasksTreeNode> pageIdToNode;
    @NotNull
    private final DefaultMutableTreeNode treeRoot;
    @NotNull
    private TreeStats treeStats;

    public TasksTreeStructure(@NotNull BuildAttributionReportUiData reportData) {
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        this.reportData = reportData;
        this.pageIdToNode = new LinkedHashMap();
        this.treeRoot = new DefaultMutableTreeNode();
        this.treeStats = new TreeStats();
    }

    @NotNull
    public final BuildAttributionReportUiData getReportData() {
        return this.reportData;
    }

    @NotNull
    public final Map<TasksPageId, TasksTreeNode> getPageIdToNode() {
        return this.pageIdToNode;
    }

    @NotNull
    public final DefaultMutableTreeNode getTreeRoot() {
        return this.treeRoot;
    }

    @NotNull
    public final TreeStats getTreeStats() {
        return this.treeStats;
    }

    public final void setTreeStats(@NotNull TreeStats treeStats) {
        Intrinsics.checkNotNullParameter((Object)treeStats, (String)"<set-?>");
        this.treeStats = treeStats;
    }

    private final TasksTreeNode treeNode(TasksTreePresentableNodeDescriptor descriptor2) {
        TasksTreeNode tasksTreeNode;
        TasksTreeNode $this$treeNode_u24lambda_u240 = tasksTreeNode = new TasksTreeNode(descriptor2);
        boolean bl = false;
        this.pageIdToNode.put(descriptor2.getPageId(), $this$treeNode_u24lambda_u240);
        return tasksTreeNode;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateStructure(@NotNull TasksDataPageModel.Grouping grouping, @NotNull TasksFilter filter2) {
        long l;
        Intrinsics.checkNotNullParameter((Object)((Object)grouping), (String)"grouping");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        this.pageIdToNode.clear();
        this.treeStats = new TreeStats();
        this.treeRoot.removeAllChildren();
        switch (WhenMappings.$EnumSwitchMapping$0[grouping.ordinal()]) {
            case 1: {
                this.createUngroupedNodes(filter2, this.treeStats);
                break;
            }
            case 2: {
                this.createGroupedByEntryNodes(filter2, this.treeStats, this.reportData.getCriticalPathPlugins(), grouping);
                break;
            }
            case 3: {
                CriticalPathTaskCategoriesUiData criticalPathTaskCategoriesUiData = this.reportData.getCriticalPathTaskCategories();
                Intrinsics.checkNotNull((Object)criticalPathTaskCategoriesUiData);
                this.createGroupedByEntryNodes(filter2, this.treeStats, criticalPathTaskCategoriesUiData, grouping);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.treeStats.setFiltersAreApplied(!Intrinsics.areEqual((Object)filter2, (Object)TasksFilter.Companion.getDEFAULT()));
        this.treeStats.getFilteredTaskTimesDistribution().seal();
        Iterable iterable = this.reportData.getCriticalPathTasks().getTasks();
        TreeStats treeStats = this.treeStats;
        long l2 = 0L;
        for (Object t : iterable) {
            void it;
            TaskUiData taskUiData = (TaskUiData)t;
            l = l2;
            boolean bl = false;
            long l3 = it.getExecutionTime().getTimeMs();
            l2 = l + l3;
        }
        l = l2;
        treeStats.setTotalTasksTimeMs(l);
    }

    private final void createUngroupedNodes(TasksFilter filter2, TreeStats treeStats) {
        this.treeRoot.removeAllChildren();
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.reportData.getCriticalPathTasks().getTasks()), arg_0 -> TasksTreeStructure.createUngroupedNodes$lambda$2(filter2, arg_0)), arg_0 -> TasksTreeStructure.createUngroupedNodes$lambda$3(treeStats, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskDetailsNodeDescriptor it = (TaskDetailsNodeDescriptor)element$iv;
            boolean bl = false;
            this.treeRoot.add(this.treeNode(it));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createGroupedByEntryNodes(TasksFilter filter2, TreeStats treeStats, CriticalPathEntriesUiData criticalPathEntry, TasksDataPageModel.Grouping grouping) {
        this.treeRoot.removeAllChildren();
        TimeDistributionBuilder filteredEntryTimesDistribution = new TimeDistributionBuilder();
        Iterable $this$forEach$iv = criticalPathEntry.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            CriticalPathEntryUiData entryUiData = (CriticalPathEntryUiData)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = entryUiData.getCriticalPathTasks();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TaskUiData it = (TaskUiData)element$iv$iv;
                boolean bl2 = false;
                if (!filter2.acceptTask(it, grouping)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredTasksForEntry = (List)destination$iv$iv;
            if (!(!((Collection)filteredTasksForEntry).isEmpty())) continue;
            TasksTreeNode entryNode = this.treeNode(new EntryDetailsNodeDescriptor(entryUiData, filteredTasksForEntry, filteredEntryTimesDistribution));
            Iterable $this$forEach$iv2 = filteredTasksForEntry;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TaskUiData it = (TaskUiData)element$iv2;
                boolean bl3 = false;
                entryNode.add(this.treeNode(new TaskDetailsNodeDescriptor(it, entryUiData.getModelGrouping(), treeStats.getFilteredTaskTimesDistribution())));
            }
            this.treeRoot.add(entryNode);
        }
        filteredEntryTimesDistribution.seal();
    }

    private static final boolean createUngroupedNodes$lambda$2(TasksFilter $filter, TaskUiData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filter.acceptTask(it, TasksDataPageModel.Grouping.UNGROUPED);
    }

    private static final TaskDetailsNodeDescriptor createUngroupedNodes$lambda$3(TreeStats $treeStats, TaskUiData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new TaskDetailsNodeDescriptor(it, TasksDataPageModel.Grouping.UNGROUPED, $treeStats.getFilteredTaskTimesDistribution());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/android/build/attribution/ui/model/TasksTreeStructure$TreeStats;", "", "<init>", "()V", "totalTasksTimeMs", "", "getTotalTasksTimeMs", "()J", "setTotalTasksTimeMs", "(J)V", "filteredTaskTimesDistribution", "Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;", "getFilteredTaskTimesDistribution", "()Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;", "filtersAreApplied", "", "getFiltersAreApplied", "()Z", "setFiltersAreApplied", "(Z)V", "filteredTasksTimeMs", "getFilteredTasksTimeMs", "intellij.android.build-attribution"})
    public static final class TreeStats {
        private long totalTasksTimeMs;
        @NotNull
        private final TimeDistributionBuilder filteredTaskTimesDistribution = new TimeDistributionBuilder();
        private boolean filtersAreApplied;

        public final long getTotalTasksTimeMs() {
            return this.totalTasksTimeMs;
        }

        public final void setTotalTasksTimeMs(long l) {
            this.totalTasksTimeMs = l;
        }

        @NotNull
        public final TimeDistributionBuilder getFilteredTaskTimesDistribution() {
            return this.filteredTaskTimesDistribution;
        }

        public final boolean getFiltersAreApplied() {
            return this.filtersAreApplied;
        }

        public final void setFiltersAreApplied(boolean bl) {
            this.filtersAreApplied = bl;
        }

        public final long getFilteredTasksTimeMs() {
            return this.filteredTaskTimesDistribution.getTotalTime();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TasksDataPageModel.Grouping.values().length];
            try {
                nArray[TasksDataPageModel.Grouping.UNGROUPED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TasksDataPageModel.Grouping.BY_PLUGIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TasksDataPageModel.Grouping.BY_TASK_CATEGORY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

