/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.model.BuildOverviewPageModel;
import com.android.build.attribution.ui.model.DownloadsInfoPageModel;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksDataPageModelImpl;
import com.android.build.attribution.ui.model.WarningsDataPageModel;
import com.android.build.attribution.ui.model.WarningsDataPageModelImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel;", "", "reportUiData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "warningSuppressions", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "<init>", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lcom/android/build/attribution/BuildAttributionWarningsFilter;)V", "getReportUiData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "getWarningSuppressions", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "availableDataSets", "", "Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;", "getAvailableDataSets", "()Ljava/util/List;", "dataSetSelectionListener", "Lkotlin/Function0;", "", "getDataSetSelectionListener", "()Lkotlin/jvm/functions/Function0;", "setDataSetSelectionListener", "(Lkotlin/jvm/functions/Function0;)V", "value", "selectedData", "getSelectedData", "()Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;", "setSelectedData", "(Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;)V", "overviewPageModel", "Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "getOverviewPageModel", "()Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "tasksPageModel", "Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "getTasksPageModel", "()Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "warningsPageModel", "Lcom/android/build/attribution/ui/model/WarningsDataPageModel;", "getWarningsPageModel", "()Lcom/android/build/attribution/ui/model/WarningsDataPageModel;", "downloadsInfoPageModel", "Lcom/android/build/attribution/ui/model/DownloadsInfoPageModel;", "getDownloadsInfoPageModel", "()Lcom/android/build/attribution/ui/model/DownloadsInfoPageModel;", "DataSet", "intellij.android.build-attribution"})
public final class BuildAnalyzerViewModel {
    @NotNull
    private final BuildAttributionReportUiData reportUiData;
    @NotNull
    private final BuildAttributionWarningsFilter warningSuppressions;
    @Nullable
    private Function0<Unit> dataSetSelectionListener;
    @NotNull
    private DataSet selectedData;
    @NotNull
    private final BuildOverviewPageModel overviewPageModel;
    @NotNull
    private final TasksDataPageModel tasksPageModel;
    @NotNull
    private final WarningsDataPageModel warningsPageModel;
    @NotNull
    private final DownloadsInfoPageModel downloadsInfoPageModel;

    public BuildAnalyzerViewModel(@NotNull BuildAttributionReportUiData reportUiData, @NotNull BuildAttributionWarningsFilter warningSuppressions) {
        Intrinsics.checkNotNullParameter((Object)reportUiData, (String)"reportUiData");
        Intrinsics.checkNotNullParameter((Object)warningSuppressions, (String)"warningSuppressions");
        this.reportUiData = reportUiData;
        this.warningSuppressions = warningSuppressions;
        this.selectedData = this.reportUiData.getJetifierData().getCheckJetifierBuild() ? DataSet.WARNINGS : DataSet.OVERVIEW;
        this.overviewPageModel = new BuildOverviewPageModel(this.reportUiData, this.warningSuppressions);
        this.tasksPageModel = new TasksDataPageModelImpl(this.reportUiData);
        this.warningsPageModel = new WarningsDataPageModelImpl(this.reportUiData);
        this.downloadsInfoPageModel = new DownloadsInfoPageModel(this.reportUiData.getDownloadsData());
    }

    @NotNull
    public final BuildAttributionReportUiData getReportUiData() {
        return this.reportUiData;
    }

    @NotNull
    public final BuildAttributionWarningsFilter getWarningSuppressions() {
        return this.warningSuppressions;
    }

    @NotNull
    public final List<DataSet> getAvailableDataSets() {
        DataSet[] dataSetArray = new DataSet[]{DataSet.OVERVIEW, DataSet.TASKS, DataSet.WARNINGS, !Intrinsics.areEqual((Object)this.reportUiData.getDownloadsData(), (Object)DownloadsAnalyzer.AnalyzerIsDisabled.INSTANCE) ? DataSet.DOWNLOADS : null};
        return CollectionsKt.listOfNotNull((Object[])dataSetArray);
    }

    @Nullable
    public final Function0<Unit> getDataSetSelectionListener() {
        return this.dataSetSelectionListener;
    }

    public final void setDataSetSelectionListener(@Nullable Function0<Unit> function0) {
        this.dataSetSelectionListener = function0;
    }

    @NotNull
    public final DataSet getSelectedData() {
        return this.selectedData;
    }

    public final void setSelectedData(@NotNull DataSet value2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            if (value2 == this.selectedData) break block1;
            this.selectedData = value2;
            Function0<Unit> function0 = this.dataSetSelectionListener;
            if (function0 != null) {
                function0.invoke();
            }
        }
    }

    @NotNull
    public final BuildOverviewPageModel getOverviewPageModel() {
        return this.overviewPageModel;
    }

    @NotNull
    public final TasksDataPageModel getTasksPageModel() {
        return this.tasksPageModel;
    }

    @NotNull
    public final WarningsDataPageModel getWarningsPageModel() {
        return this.warningsPageModel;
    }

    @NotNull
    public final DownloadsInfoPageModel getDownloadsInfoPageModel() {
        return this.downloadsInfoPageModel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;", "", "uiName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getUiName", "()Ljava/lang/String;", "OVERVIEW", "TASKS", "WARNINGS", "DOWNLOADS", "intellij.android.build-attribution"})
    public static final class DataSet
    extends Enum<DataSet> {
        @NotNull
        private final String uiName;
        public static final /* enum */ DataSet OVERVIEW = new DataSet("Overview");
        public static final /* enum */ DataSet TASKS = new DataSet("Tasks");
        public static final /* enum */ DataSet WARNINGS = new DataSet("Warnings");
        public static final /* enum */ DataSet DOWNLOADS = new DataSet("Downloads");
        private static final /* synthetic */ DataSet[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DataSet(String uiName) {
            this.uiName = uiName;
        }

        @NotNull
        public final String getUiName() {
            return this.uiName;
        }

        public static DataSet[] values() {
            return (DataSet[])$VALUES.clone();
        }

        public static DataSet valueOf(String value2) {
            return Enum.valueOf(DataSet.class, value2);
        }

        @NotNull
        public static EnumEntries<DataSet> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dataSetArray = new DataSet[]{DataSet.OVERVIEW, DataSet.TASKS, DataSet.WARNINGS, DataSet.DOWNLOADS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

