/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.system.OS;
import com.intellij.util.text.ReverseCharSequence;
import com.jetbrains.cidr.execution.CidrPathConsoleFilter;
import com.jetbrains.cidr.execution.DimmableFilter;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n*\u0002\u0013\u0016\b\u0016\u0018\u0000 -2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002-.B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0014J\"\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0004J \u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0014J\u0012\u0010+\u001a\u0004\u0018\u00010%2\u0006\u0010,\u001a\u00020\u001bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/execution/CidrPathConsoleFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/jetbrains/cidr/execution/DimmableFilter;", "myProject", "Lcom/intellij/openapi/project/Project;", "myEnvironment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "myBaseDir", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Ljava/nio/file/Path;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "myDimHighlighting", "", "dimHighlighting", "", "environmentConsoleRegexMaster", "com/jetbrains/cidr/execution/CidrPathConsoleFilter$environmentConsoleRegexMaster$1", "Lcom/jetbrains/cidr/execution/CidrPathConsoleFilter$environmentConsoleRegexMaster$1;", "localConsoleRegexMaster", "com/jetbrains/cidr/execution/CidrPathConsoleFilter$localConsoleRegexMaster$1", "Lcom/jetbrains/cidr/execution/CidrPathConsoleFilter$localConsoleRegexMaster$1;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "regexMaster", "Lcom/jetbrains/cidr/execution/CidrPathConsoleFilter$ConsoleRegexMaster;", "processMatch", "Lcom/intellij/execution/filters/HyperlinkInfo;", "matchedPath", "column", "processLocalPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "localPath", "isAbsolute", "isHomePath", "createHyperlinkInfo", "file", "findSingleFileByName", "name", "Companion", "ConsoleRegexMaster", "intellij.cidr.execution"})
@SourceDebugExtension(value={"SMAP\nCidrPathConsoleFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrPathConsoleFilter.kt\ncom/jetbrains/cidr/execution/CidrPathConsoleFilter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1321#2,2:439\n774#3:441\n865#3,2:442\n*S KotlinDebug\n*F\n+ 1 CidrPathConsoleFilter.kt\ncom/jetbrains/cidr/execution/CidrPathConsoleFilter\n*L\n98#1:439,2\n260#1:441\n260#1:442,2\n*E\n"})
public class CidrPathConsoleFilter
implements Filter,
DumbAware,
DimmableFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @Nullable
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final Path myBaseDir;
    private boolean myDimHighlighting;
    @NotNull
    private final environmentConsoleRegexMaster.1 environmentConsoleRegexMaster;
    @NotNull
    private final localConsoleRegexMaster.1 localConsoleRegexMaster;
    public static final long MAX_TIME_PER_LINE_MILLIS = 250L;
    @Language(value="RegExp")
    @NotNull
    private static final String LINE_NUMBER = "\\d{1,5}";
    @Language(value="RegExp")
    @NotNull
    private static final String COLUMN_NUMBER = "\\d{1,5}";
    @Language(value="RegExp")
    @NotNull
    private static final String MSVC_LINE_GROUP = "msvcLine";
    @Language(value="RegExp")
    @NotNull
    private static final String MSVC_COLUMN_GROUP = "msvcColumn";
    @Language(value="RegExp")
    @NotNull
    private static final String LINE_GROUP = "line";
    @Language(value="RegExp")
    @NotNull
    private static final String COLUMN_GROUP = "column";
    @JvmField
    @Language(value="RegExp")
    @NotNull
    public static final String LINE_PATTERN_TEXT = " ?\\((?<msvcLine>\\d{1,5})(?:,(?<msvcColumn>" + COLUMN_NUMBER + "))?\\)|:(?<line>\\d{1,5})";
    @NotNull
    private static final Regex LINE_NUMBER_PATTERN = new Regex("[^:](?:" + LINE_PATTERN_TEXT + "(?::(?<column>" + COLUMN_NUMBER + "))?(?::?\\b|_))");

    public CidrPathConsoleFilter(@NotNull Project myProject, @Nullable CidrToolEnvironment myEnvironment, @Nullable Path myBaseDir) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myEnvironment = myEnvironment;
        this.myBaseDir = myBaseDir;
        this.environmentConsoleRegexMaster = new ConsoleRegexMaster(this){
            final /* synthetic */ CidrPathConsoleFilter this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean canBeWindowsPath() {
                return CidrPathConsoleFilter.access$getMyEnvironment$p(this.this$0) != null ? CidrPathConsoleFilter.access$getMyEnvironment$p(this.this$0).getHostMachine().getOS() == OS.Windows : SystemInfo.isWindows;
            }

            public String toLocalPath(String path) {
                String string;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (CidrPathConsoleFilter.access$getMyEnvironment$p(this.this$0) == null || CidrPathConsoleFilter.access$getMyBaseDir$p(this.this$0) == null) {
                    string = CidrPathConsoleFilter.access$getLocalConsoleRegexMaster$p(this.this$0).toLocalPath(path);
                } else {
                    String string2 = CidrPathConsoleFilter.access$getMyEnvironment$p(this.this$0).toLocalPath(CidrPathConsoleFilter.access$getMyBaseDir$p(this.this$0).toFile(), path);
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                }
                return string;
            }
        };
        this.localConsoleRegexMaster = new ConsoleRegexMaster(){

            public boolean canBeWindowsPath() {
                return SystemInfo.isWindows;
            }

            public String toLocalPath(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return path;
            }
        };
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @Override
    public void dimHighlighting() {
        this.myDimHighlighting = true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)LINE_GROUP);
        Filter.Result result = this.applyFilter(this.localConsoleRegexMaster, line, entireLength);
        if (result == null) {
            result = this.applyFilter(this.environmentConsoleRegexMaster, line, entireLength);
        }
        return result;
    }

    private final Filter.Result applyFilter(ConsoleRegexMaster regexMaster, String line, int entireLength) {
        if (!StringUtil.containsAnyChar((String)line, (String)":(")) {
            return null;
        }
        CharSequence expiringLine = CidrPathConsoleFilter.Companion.timeLimitedSequence(line);
        Matcher fm = null;
        SmartList results = null;
        Ref.IntRef lineNumberSearchPosition = new Ref.IntRef();
        int pathSearchPosition = 0;
        int lineStart = entireLength - line.length();
        try {
            Sequence matches2;
            Sequence $this$forEach$iv = matches2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MatchResult>, Continuation<? super Unit>, Object>(expiringLine, lineNumberSearchPosition, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ CharSequence $expiringLine;
                final /* synthetic */ Ref.IntRef $lineNumberSearchPosition;
                {
                    this.$expiringLine = $expiringLine;
                    this.$lineNumberSearchPosition = $lineNumberSearchPosition;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (SequenceScope)this.L$0;
                    var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
lbl7:
                            // 3 sources

                            while ((match = CidrPathConsoleFilter.access$getLINE_NUMBER_PATTERN$cp().find(this.$expiringLine, this.$lineNumberSearchPosition.element)) != null) {
                                this.L$0 = $this$sequence;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)match);
                                this.label = 1;
                                v0 = $this$sequence.yield((Object)match, (Continuation)this);
                                if (v0 != var4_3) continue;
                                return var4_3;
                            }
                            break;
                        }
                        case 1: {
                            match = (MatchResult)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl7
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super MatchResult> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MatchResult parentDirectoryPrefixMatch;
                String filename;
                int columnNumber;
                Integer lineNumber;
                int hyperlinkEndPosition;
                boolean msvcMode;
                MatchResult match;
                block11: {
                    match = (MatchResult)element$iv;
                    boolean bl = false;
                    msvcMode = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)MSVC_LINE_GROUP) != null;
                    String lineNumberGroup = msvcMode ? MSVC_LINE_GROUP : LINE_GROUP;
                    MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)lineNumberGroup);
                    Intrinsics.checkNotNull((Object)matchGroup);
                    lineNumberSearchPosition.element = matchGroup.getRange().getStart();
                    MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)lineNumberGroup);
                    Intrinsics.checkNotNull((Object)matchGroup2);
                    hyperlinkEndPosition = matchGroup2.getRange().getLast() + 1;
                    lineNumber = CidrPathConsoleFilter.Companion.zeroBased(CidrPathConsoleFilter.Companion.groupValueAsInt(match, lineNumberGroup));
                    if (lineNumber == null) continue;
                    columnNumber = 0;
                    String columnNumberGroup = msvcMode ? MSVC_COLUMN_GROUP : COLUMN_GROUP;
                    MatchGroup columnNumberRaw = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)columnNumberGroup);
                    if (columnNumberRaw != null) {
                        try {
                            Integer n = CidrPathConsoleFilter.Companion.zeroBased(Integer.parseInt(columnNumberRaw.getValue()));
                            Intrinsics.checkNotNull((Object)n);
                            columnNumber = n;
                            lineNumberSearchPosition.element = columnNumberRaw.getRange().getStart();
                            hyperlinkEndPosition = columnNumberRaw.getRange().getLast() + 1;
                            break block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    columnNumber = 0;
                }
                if (msvcMode) {
                    ++hyperlinkEndPosition;
                }
                if (fm == null) {
                    fm = regexMaster.getREVERSE_FILE_PATH_PATTERN().matcher((CharSequence)new ReverseCharSequence(expiringLine));
                }
                fm.region(line.length() - match.getRange().getStart() - 1, line.length() - pathSearchPosition);
                if (!fm.find()) continue;
                int pathStart = line.length() - fm.end();
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(pathStart, line.length() - fm.start()), (String)"substring(...)");
                HyperlinkInfo link = this.processMatch(regexMaster, filename, lineNumber, columnNumber);
                if (link == null && !(((CharSequence)filename).length() == 0) && filename.charAt(0) == '.' && (parentDirectoryPrefixMatch = Regex.find$default((Regex)regexMaster.getParentDirsPrefix(), (CharSequence)filename, (int)0, (int)2, null)) != null) {
                    String string = filename.substring(parentDirectoryPrefixMatch.getRange().getLast() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    link = this.processMatch(regexMaster, string, lineNumber, columnNumber);
                }
                if (link == null) continue;
                if (results == null) {
                    results = new SmartList();
                }
                ((List)results).add(new Filter.ResultItem(lineStart + pathStart, lineStart + hyperlinkEndPosition, link, this.myDimHighlighting));
                pathSearchPosition = lineNumberSearchPosition.element;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return results == null || ((List)results).isEmpty() ? null : new Filter.Result((List)results);
    }

    @Nullable
    protected HyperlinkInfo processMatch(@NotNull ConsoleRegexMaster regexMaster, @NotNull String matchedPath, int line, int column) {
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)regexMaster, (String)"regexMaster");
        Intrinsics.checkNotNullParameter((Object)matchedPath, (String)"matchedPath");
        String localPath = regexMaster.toLocalPath(matchedPath);
        boolean isAbsolute = this.localConsoleRegexMaster.canBeWindowsPath() ? this.localConsoleRegexMaster.getWindowsPathPrefixChecker().matches((CharSequence)matchedPath) : StringsKt.startsWith$default((String)matchedPath, (String)"/", (boolean)false, (int)2, null);
        boolean isHomePath = !isAbsolute && !this.localConsoleRegexMaster.canBeWindowsPath() && StringsKt.startsWith$default((String)matchedPath, (String)"~", (boolean)false, (int)2, null);
        VirtualFile virtualFile = file = this.processLocalPath(localPath, isAbsolute, isHomePath);
        return virtualFile == null ? null : this.createHyperlinkInfo(virtualFile, line, column);
    }

    @Nullable
    protected final VirtualFile processLocalPath(@NotNull String localPath, boolean isAbsolute, boolean isHomePath) {
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        if (isAbsolute) {
            Path path;
            try {
                Path path2 = Paths.get(localPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                path = path2;
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
            Path path3 = path;
            return CidrPathConsoleFilter.Companion.fileByIOFile(path3);
        }
        if (isHomePath) {
            Object object;
            String userHome = System.getProperty("user.home");
            try {
                Intrinsics.checkNotNull((Object)userHome);
                object = userHome;
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)localPath.substring(1), (String)"substring(...)");
                Path path = Paths.get((String)object, Arrays.copyOf(stringArray, stringArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                object = path;
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
            Object path = object;
            return CidrPathConsoleFilter.Companion.fileByIOFile((Path)path);
        }
        if (this.myBaseDir == null) {
            v2 = null;
        } else {
            String string;
            try {
                string = ((Object)this.myBaseDir.resolve(localPath)).toString();
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
            String absolutePath = string;
            v2 = file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)absolutePath));
        }
        if (file == null) {
            return this.findSingleFileByName(localPath);
        }
        return file;
    }

    @NotNull
    protected HyperlinkInfo createHyperlinkInfo(@NotNull VirtualFile file, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, line, column);
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findSingleFileByName(String name) {
        Path path = Paths.get(name, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path filePath = path;
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            boolean caseSensitive = !this.localConsoleRegexMaster.canBeWindowsPath();
            FilenameIndex.processFilesByName((String)PathsKt.getName((Path)filePath), (boolean)caseSensitive, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (Processor)((Processor)processor));
            Collection collection = processor.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
            Iterable iterable = CollectionsKt.filterNotNull((Iterable)collection);
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path candidatePath;
                VirtualFile virtualFileCandidate = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileCandidate.toNioPath(), (String)"toNioPath(...)");
                if (!candidatePath.endsWith(filePath)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List results = (List)destination$iv$iv;
            return (VirtualFile)CollectionsKt.singleOrNull((List)results);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            return null;
        }
    }

    public static final /* synthetic */ Regex access$getLINE_NUMBER_PATTERN$cp() {
        return LINE_NUMBER_PATTERN;
    }

    public static final /* synthetic */ CidrToolEnvironment access$getMyEnvironment$p(CidrPathConsoleFilter $this) {
        return $this.myEnvironment;
    }

    public static final /* synthetic */ Path access$getMyBaseDir$p(CidrPathConsoleFilter $this) {
        return $this.myBaseDir;
    }

    public static final /* synthetic */ localConsoleRegexMaster.1 access$getLocalConsoleRegexMaster$p(CidrPathConsoleFilter $this) {
        return $this.localConsoleRegexMaster;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000b\u0010\u0015\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0003\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0003\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/execution/CidrPathConsoleFilter$Companion;", "", "<init>", "()V", "MAX_TIME_PER_LINE_MILLIS", "", "LINE_NUMBER", "", "Lorg/jetbrains/annotations/NonNls;", "COLUMN_NUMBER", "MSVC_LINE_GROUP", "MSVC_COLUMN_GROUP", "LINE_GROUP", "COLUMN_GROUP", "LINE_PATTERN_TEXT", "LINE_NUMBER_PATTERN", "Lkotlin/text/Regex;", "groupValueAsInt", "", "matcher", "Lkotlin/text/MatchResult;", "groupName", "(Lkotlin/text/MatchResult;Ljava/lang/String;)Ljava/lang/Integer;", "zeroBased", "oneBasedValue", "(Ljava/lang/Integer;)Ljava/lang/Integer;", "timeLimitedSequence", "", "line", "fileByIOFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "nioPath", "Ljava/nio/file/Path;", "intellij.cidr.execution"})
    public static final class Companion {
        private Companion() {
        }

        @Contract(pure=true)
        private final Integer groupValueAsInt(MatchResult matcher, String groupName) {
            MatchGroup rawValue = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matcher.getGroups(), (String)groupName);
            if (rawValue == null) {
                return null;
            }
            try {
                return Integer.parseInt(rawValue.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Contract(value="null -> null; !null -> !null", pure=true)
        private final Integer zeroBased(Integer oneBasedValue) {
            return oneBasedValue == null ? null : Integer.valueOf(Math.max(0, oneBasedValue - 1));
        }

        private final CharSequence timeLimitedSequence(String line) {
            long expirationTimeMillis = System.currentTimeMillis() + 250L;
            return (CharSequence)new StringUtil.BombedCharSequence(line, expirationTimeMillis){
                final /* synthetic */ long $expirationTimeMillis;
                {
                    this.$expirationTimeMillis = $expirationTimeMillis;
                    super((CharSequence)$line);
                }

                protected void checkCanceled() {
                    if (System.currentTimeMillis() > this.$expirationTimeMillis) {
                        throw new ProcessCanceledException();
                    }
                }
            };
        }

        private final VirtualFile fileByIOFile(Path nioPath) {
            return LocalFileSystem.getInstance().findFileByNioFile(nioPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b$\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0010\u0010\u0015\u001a\u00020\u00078\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/execution/CidrPathConsoleFilter$ConsoleRegexMaster;", "", "<init>", "()V", "canBeWindowsPath", "", "toLocalPath", "", "path", "fileSeparator", "Lcom/jetbrains/cidr/lang/toolchains/CidrFileSeparators;", "fileSeparatorChars", "", "", "fileSeparatorSelectionSubRegex", "windowsPathPrefixChecker", "Lkotlin/text/Regex;", "getWindowsPathPrefixChecker", "()Lkotlin/text/Regex;", "parentDirsPrefix", "getParentDirsPrefix", "STARTING_CHARS", "FILE_CHARS", "Lorg/jetbrains/annotations/NonNls;", "WS", "FILE_CHARS_CLASS", "FILE_CHARS_WS_CLASS", "STARTING_CHARS_CLASS", "WS_CLASS", "REVERSE_ABSOLUTE_PATH_PREFIX", "SINGLE_WORD_PATH_COMPONENT", "MULTI_WORD_PATH_COMPONENT", "PATH_COMPONENT", "REVERSE_RELATIVE_PATH", "REVERSE_FILE_PATH_PATTERN", "Ljava/util/regex/Pattern;", "getREVERSE_FILE_PATH_PATTERN", "()Ljava/util/regex/Pattern;", "intellij.cidr.execution"})
    protected static abstract class ConsoleRegexMaster {
        @NotNull
        private final CidrFileSeparators fileSeparator = this.canBeWindowsPath() ? CidrFileSeparators.WINDOWS_UNIX : CidrFileSeparators.UNIX;
        @NotNull
        private final List<Character> fileSeparatorChars = this.fileSeparator.chars();
        @NotNull
        private final String fileSeparatorSelectionSubRegex = "[" + Regex.Companion.escape(CollectionsKt.joinToString$default((Iterable)this.fileSeparatorChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)) + "]";
        @NotNull
        private final Regex windowsPathPrefixChecker = new Regex("^(?:/|[A-Za-z]:" + this.fileSeparatorSelectionSubRegex + ").*");
        @NotNull
        private final Regex parentDirsPrefix = new Regex("^(?:[.](?:" + this.fileSeparatorSelectionSubRegex + ")+)?(?:[.]{2}(?:" + this.fileSeparatorSelectionSubRegex + ")+)+");
        @Language(value="RegExp")
        @NotNull
        private final String STARTING_CHARS;
        @NotNull
        private final String FILE_CHARS = this.STARTING_CHARS + "\\{\\}\\(\\)\\[\\]";
        @NotNull
        private final String WS;
        @NotNull
        private final String FILE_CHARS_CLASS = "[" + this.FILE_CHARS + "]";
        @NotNull
        private final String FILE_CHARS_WS_CLASS = "[" + this.FILE_CHARS + this.WS + "]";
        @NotNull
        private final String STARTING_CHARS_CLASS = "[" + this.STARTING_CHARS + "]";
        @NotNull
        private final String WS_CLASS = "[" + this.WS + "]";
        @NotNull
        private final String REVERSE_ABSOLUTE_PATH_PREFIX = this.canBeWindowsPath() ? "(?::[A-Za-z])?" : "";
        @NotNull
        private final String SINGLE_WORD_PATH_COMPONENT = this.FILE_CHARS_CLASS + "*" + this.STARTING_CHARS_CLASS;
        @NotNull
        private final String MULTI_WORD_PATH_COMPONENT = "(?:" + this.FILE_CHARS_CLASS + this.FILE_CHARS_WS_CLASS + "*|)" + this.STARTING_CHARS_CLASS + this.WS_CLASS + "*" + this.fileSeparatorSelectionSubRegex + "+";
        @NotNull
        private final String PATH_COMPONENT = this.MULTI_WORD_PATH_COMPONENT + "|" + this.SINGLE_WORD_PATH_COMPONENT;
        @NotNull
        private final String REVERSE_RELATIVE_PATH = "^(?:" + this.PATH_COMPONENT + ")+";
        @NotNull
        private final Pattern REVERSE_FILE_PATH_PATTERN;

        public ConsoleRegexMaster() {
            this.STARTING_CHARS = "-+\\p{LC}\\d~._|@";
            this.WS = "\\t ";
            Pattern pattern = Pattern.compile(this.REVERSE_RELATIVE_PATH + this.REVERSE_ABSOLUTE_PATH_PREFIX);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            this.REVERSE_FILE_PATH_PATTERN = pattern;
        }

        public abstract boolean canBeWindowsPath();

        @NotNull
        public abstract String toLocalPath(@NotNull String var1);

        @NotNull
        public final Regex getWindowsPathPrefixChecker() {
            return this.windowsPathPrefixChecker;
        }

        @NotNull
        public final Regex getParentDirsPrefix() {
            return this.parentDirsPrefix;
        }

        @NotNull
        public final Pattern getREVERSE_FILE_PATH_PATTERN() {
            return this.REVERSE_FILE_PATH_PATTERN;
        }
    }
}

