/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.execution.testing.CTestingBundle;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestIndexingTask
implements Disposable.Default {
    private final Ref<Task.Backgroundable> myUIProgressTask;
    private volatile ProgressSuspender myUIProgressTaskSuspender;
    private volatile ProgressIndicator myUIProgressIndicator;
    private volatile boolean myIsSuspended;
    private final Project myProject;
    private final HashSet<CidrTestListUpdater> myUpdaters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTextInfo(@NlsContexts.ProgressText @Nullable String progressText, @NlsContexts.ProgressDetails @Nullable String progressDetails) {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (this.myUIProgressIndicator != null) {
                double min = 1.0;
                for (CidrTestListUpdater updater : this.myUpdaters) {
                    double fraction = updater.getFraction();
                    if (!updater.isIndexing() || !(fraction < min)) continue;
                    min = fraction;
                }
                if (this.myUIProgressIndicator.isIndeterminate()) {
                    this.myUIProgressIndicator.setIndeterminate(false);
                }
                this.myUIProgressIndicator.setFraction(min);
                if (progressText != null) {
                    this.myUIProgressIndicator.setText(progressText);
                }
                if (progressDetails != null) {
                    this.myUIProgressIndicator.setText2(progressDetails);
                }
            }
        }
    }

    public static CidrTestIndexingTask getInstance(@NotNull Project project) {
        if (project == null) {
            CidrTestIndexingTask.$$$reportNull$$$0(0);
        }
        return (CidrTestIndexingTask)project.getService(CidrTestIndexingTask.class);
    }

    protected CidrTestIndexingTask(@NotNull Project project) {
        if (project == null) {
            CidrTestIndexingTask.$$$reportNull$$$0(1);
        }
        this.myUIProgressTask = Ref.create();
        this.myUIProgressTaskSuspender = null;
        this.myUIProgressIndicator = null;
        this.myIsSuspended = false;
        this.myUpdaters = new HashSet();
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

            public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (oldValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (newValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ("cidr.test.framework.showIndexingAsTask".equals(id)) {
                    if (CidrTestListUpdater.showTestIndexingProgress()) {
                        CidrTestIndexingTask.this.updateVisibilityStatus(true, false);
                    } else {
                        CidrTestIndexingTask.this.hideSuspendableTestIndexingTask();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "id";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldValue";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newValue";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/testing/CidrTestIndexingTask$1";
                objectArray[2] = "advancedSettingChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(@NotNull CidrTestListUpdater updater) {
        if (updater == null) {
            CidrTestIndexingTask.$$$reportNull$$$0(2);
        }
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            this.myUpdaters.add(updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(@NotNull CidrTestListUpdater updater) {
        if (updater == null) {
            CidrTestIndexingTask.$$$reportNull$$$0(3);
        }
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            this.myUpdaters.remove(updater);
            this.updateVisibilityStatus(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVisibilityStatus(boolean showIfNeed, boolean hideIfNeed) {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            for (CidrTestListUpdater updater : this.myUpdaters) {
                if (!updater.isIndexing()) continue;
                if (showIfNeed) {
                    this.showSuspendableTestIndexingTask();
                }
                return;
            }
            if (hideIfNeed) {
                this.hideSuspendableTestIndexingTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            return this.myIsSuspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            return this.doIsVisible();
        }
    }

    private boolean doIsVisible() {
        return this.myUIProgressTask.get() != null && this.myUIProgressTaskSuspender != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (this.myIsSuspended) {
                this.doResume();
                this.doSyncSuspenderStateInUI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (!this.myIsSuspended) {
                this.doSuspend(true);
                this.doSyncSuspenderStateInUI();
            }
        }
    }

    private void doResume() {
        CidrTestListUpdater.log("Resume Test Indexing", new Object[0]);
        this.myIsSuspended = false;
        this.myUpdaters.forEach(updater -> updater.scheduleUpdatePass());
    }

    private void doSuspend(boolean cleanupUpdateQueue) {
        CidrTestListUpdater.log("Suspend Test Indexing with cleanup update queue: " + cleanupUpdateQueue, new Object[0]);
        this.myIsSuspended = true;
        this.myUpdaters.forEach(updater -> {
            updater.suspendedUpdatePass();
            if (cleanupUpdateQueue) {
                updater.cancelTestIndexing(false, true);
            }
        });
    }

    private void doSyncSuspenderStateInUI() {
        if (this.doIsVisible()) {
            if (this.myIsSuspended) {
                this.myUIProgressTaskSuspender.suspendProcess(CTestingBundle.message("test.project.indexing.tests.cancel", new Object[0]));
            } else {
                this.myUIProgressTaskSuspender.resumeProcess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSuspendableTestIndexingTask() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            if (this.myUIProgressTask.get() == null) {
                MySubProgressTask subProgressTask = new MySubProgressTask();
                this.myUIProgressTask.set((Object)subProgressTask);
                ApplicationUtil.invokeLaterSomewhere((EdtReplacementThread)EdtReplacementThread.EDT, (ModalityState)ModalityState.nonModal(), () -> subProgressTask.setCancelText(CTestingBundle.message("test.project.indexing.tests.cancel", new Object[0])).setCancelTooltipText(CTestingBundle.message("test.project.indexing.tests.cancel.tooltip", new Object[0])).queue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideSuspendableTestIndexingTask() {
        Ref<Task.Backgroundable> ref = this.myUIProgressTask;
        synchronized (ref) {
            this.myUIProgressTask.set(null);
            this.myUIProgressTask.notifyAll();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestIndexingTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "subscribe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unsubscribe";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MySubProgressTask
    extends Task.Backgroundable {
        private MySubProgressTask() {
            super(CidrTestIndexingTask.this.myProject, CTestingBundle.message("test.project.indexing.tests", new Object[0]), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MySubProgressTask.$$$reportNull$$$0(0);
            }
            if (this.myProject == null || this.myProject.isDisposed()) {
                return;
            }
            Disposable taskLiveTime = Disposer.newDisposable();
            Disposer.register((Disposable)CidrTestIndexingTask.this, (Disposable)taskLiveTime);
            Ref<Task.Backgroundable> ref = CidrTestIndexingTask.this.myUIProgressTask;
            synchronized (ref) {
                try {
                    CidrTestIndexingTask.this.myUIProgressIndicator = indicator;
                    CidrTestIndexingTask.this.updateTextInfo(null, null);
                    String message = CTestingBundle.message("test.project.indexing.tests.paused", new Object[0]);
                    CidrTestIndexingTask.this.myUIProgressTaskSuspender = ProgressSuspender.markSuspendable((ProgressIndicator)indicator, (String)message);
                    if (CidrTestIndexingTask.this.myIsSuspended) {
                        CidrTestIndexingTask.this.myUIProgressTaskSuspender.suspendProcess(message);
                    }
                    MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(taskLiveTime);
                    connection.subscribe(ProgressSuspender.TOPIC, (Object)new MySuspenderListener());
                    while (CidrTestIndexingTask.this.myUIProgressTask.get() != null) {
                        try {
                            CidrTestIndexingTask.this.myUIProgressTask.wait(250L);
                            if (!indicator.isCanceled()) continue;
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
                finally {
                    if (indicator.isCanceled()) {
                        CidrTestIndexingTask.this.doSuspend(true);
                    }
                    CidrTestIndexingTask.this.myUIProgressIndicator = null;
                    CidrTestIndexingTask.this.myUIProgressTaskSuspender.close();
                    CidrTestIndexingTask.this.myUIProgressTaskSuspender = null;
                    CidrTestIndexingTask.this.myUIProgressTask.set(null);
                    Disposer.dispose((Disposable)taskLiveTime);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/execution/testing/CidrTestIndexingTask$MySubProgressTask", "run"));
        }
    }

    private class MySuspenderListener
    implements ProgressSuspender.SuspenderListener {
        private MySuspenderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendedStatusChanged(@NotNull ProgressSuspender changedSuspender) {
            if (changedSuspender == null) {
                MySuspenderListener.$$$reportNull$$$0(0);
            }
            Ref<Task.Backgroundable> ref = CidrTestIndexingTask.this.myUIProgressTask;
            synchronized (ref) {
                if (CidrTestIndexingTask.this.myUIProgressTaskSuspender == changedSuspender) {
                    if (CidrTestIndexingTask.this.myUIProgressTaskSuspender.isSuspended()) {
                        CidrTestIndexingTask.this.doSuspend(false);
                    } else {
                        CidrTestIndexingTask.this.doResume();
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedSuspender", "com/jetbrains/cidr/execution/testing/CidrTestIndexingTask$MySuspenderListener", "suspendedStatusChanged"));
        }
    }
}

