/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.AnonymousUsageTrackerWriter;
import com.android.tools.analytics.NullUsageTracker;
import com.android.tools.analytics.UsageTrackerWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.GeneratedMessageV3;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020%2\u0006\u0010@\u001a\u00020AH\u0007J\u0016\u0010B\u001a\u00020>2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020>0DH\u0003J\u0010\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020\u0017H\u0007J\u0010\u0010E\u001a\u00020>2\u0006\u0010F\u001a\u00020GH\u0007J\u0018\u0010E\u001a\u00020>2\u0006\u0010H\u001a\u00020%2\u0006\u0010F\u001a\u00020\u0017H\u0007J\b\u0010I\u001a\u00020>H\u0002J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010K\u001a\u00020LH\u0007J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010K\u001a\u00020LH\u0007J\b\u0010N\u001a\u00020>H\u0007J\b\u0010O\u001a\u00020>H\u0007J\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0007J\b\u0010R\u001a\u00020>H\u0007J\u0010\u0010S\u001a\u00020>2\u0006\u0010K\u001a\u00020LH\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b \u0010\u0003\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R&\u0010&\u001a\u00020%2\u0006\u0010\b\u001a\u00020%8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u0003\u001a\u0004\b(\u0010)R&\u0010*\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0003\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010\u0014R$\u0010.\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b/\u0010\u0003\u001a\u0004\b0\u0010\f\"\u0004\b1\u00102R$\u00103\u001a\u0002048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b5\u0010\u0003\u001a\u0004\b6\u00107\"\u0004\b8\u00109R \u0010:\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b;\u0010\u0003\u001a\u0004\b<\u0010\u001aR5\u0010T\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\bV\u0012\b\bW\u0012\u0004\b\b(X\u0012\u0004\u0012\u00020>0UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\\u00a8\u0006]"}, d2={"Lcom/android/tools/analytics/UsageTracker;", "", "<init>", "()V", "gate", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "value", "", "initialized", "getInitialized", "()Z", "exceptionThrown", "sessionId", "", "getSessionId$annotations", "getSessionId", "()Ljava/lang/String;", "setSessionId", "(Ljava/lang/String;)V", "writer", "Lcom/android/tools/analytics/UsageTrackerWriter;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "getWriter$annotations", "getWriter", "()Lcom/android/tools/analytics/UsageTrackerWriter;", "setWriter", "(Lcom/android/tools/analytics/UsageTrackerWriter;)V", "isTesting", "maxJournalSize", "", "getMaxJournalSize$annotations", "getMaxJournalSize", "()I", "setMaxJournalSize", "(I)V", "", "maxJournalTime", "getMaxJournalTime$annotations", "getMaxJournalTime", "()J", "version", "getVersion$annotations", "getVersion", "setVersion", "ideaIsInternal", "getIdeaIsInternal$annotations", "getIdeaIsInternal", "setIdeaIsInternal", "(Z)V", "ideBrand", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;", "getIdeBrand$annotations", "getIdeBrand", "()Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;", "setIdeBrand", "(Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$IdeBrand;)V", "writerForTest", "getWriterForTest$annotations", "getWriterForTest", "setMaxJournalTime", "", "duration", "unit", "Ljava/util/concurrent/TimeUnit;", "runIfUsageTrackerUsable", "callback", "Lkotlin/Function0;", "log", "studioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent;", "eventTimeMs", "ensureInitialized", "initialize", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "initializeIfNotPresent", "disable", "deinitialize", "setWriterForTest", "tracker", "cleanAfterTesting", "initializeTrackerWriter", "listener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "event", "getListener", "()Lkotlin/jvm/functions/Function1;", "setListener", "(Lkotlin/jvm/functions/Function1;)V", "analytics-tracker"})
public final class UsageTracker {
    @NotNull
    public static final UsageTracker INSTANCE = new UsageTracker();
    @NotNull
    private static final Object gate = new Object();
    private static final Logger LOG = Logger.getLogger(INSTANCE.getClass().getName());
    private static boolean initialized;
    private static boolean exceptionThrown;
    @NotNull
    private static String sessionId;
    @NotNull
    private static UsageTrackerWriter<AndroidStudioEvent.Builder> writer;
    private static boolean isTesting;
    private static int maxJournalSize;
    private static long maxJournalTime;
    @Nullable
    private static String version;
    private static boolean ideaIsInternal;
    @NotNull
    private static AndroidStudioEvent.IdeBrand ideBrand;
    @NotNull
    private static Function1<? super AndroidStudioEvent.Builder, Unit> listener;

    private UsageTracker() {
    }

    public final boolean getInitialized() {
        return initialized;
    }

    @NotNull
    public static final String getSessionId() {
        return sessionId;
    }

    public static final void setSessionId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        sessionId = string;
    }

    @VisibleForTesting
    @JvmStatic
    public static /* synthetic */ void getSessionId$annotations() {
    }

    @NotNull
    public static final UsageTrackerWriter<AndroidStudioEvent.Builder> getWriter() {
        return writer;
    }

    public static final void setWriter(@NotNull UsageTrackerWriter<AndroidStudioEvent.Builder> usageTrackerWriter) {
        Intrinsics.checkNotNullParameter(usageTrackerWriter, (String)"<set-?>");
        writer = usageTrackerWriter;
    }

    @JvmStatic
    @VisibleForTesting
    public static /* synthetic */ void getWriter$annotations() {
    }

    public static final int getMaxJournalSize() {
        return maxJournalSize;
    }

    public static final void setMaxJournalSize(int n) {
        maxJournalSize = n;
    }

    @JvmStatic
    public static /* synthetic */ void getMaxJournalSize$annotations() {
    }

    public static final long getMaxJournalTime() {
        return maxJournalTime;
    }

    @JvmStatic
    public static /* synthetic */ void getMaxJournalTime$annotations() {
    }

    @Nullable
    public static final String getVersion() {
        return version;
    }

    public static final void setVersion(@Nullable String string) {
        version = string;
    }

    @JvmStatic
    public static /* synthetic */ void getVersion$annotations() {
    }

    public static final boolean getIdeaIsInternal() {
        return ideaIsInternal;
    }

    public static final void setIdeaIsInternal(boolean bl) {
        ideaIsInternal = bl;
    }

    @JvmStatic
    public static /* synthetic */ void getIdeaIsInternal$annotations() {
    }

    @NotNull
    public static final AndroidStudioEvent.IdeBrand getIdeBrand() {
        return ideBrand;
    }

    public static final void setIdeBrand(@NotNull AndroidStudioEvent.IdeBrand ideBrand) {
        Intrinsics.checkNotNullParameter((Object)ideBrand, (String)"<set-?>");
        UsageTracker.ideBrand = ideBrand;
    }

    @JvmStatic
    public static /* synthetic */ void getIdeBrand$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public static final UsageTrackerWriter<AndroidStudioEvent.Builder> getWriterForTest() {
        Object object = gate;
        synchronized (object) {
            boolean bl = false;
            UsageTrackerWriter<AndroidStudioEvent.Builder> usageTrackerWriter = writer;
            return usageTrackerWriter;
        }
    }

    @JvmStatic
    public static /* synthetic */ void getWriterForTest$annotations() {
    }

    @JvmStatic
    public static final void setMaxJournalTime(long duration, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        UsageTracker.runIfUsageTrackerUsable((Function0<Unit>)((Function0)() -> UsageTracker.setMaxJournalTime$lambda$1(unit, duration)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final void runIfUsageTrackerUsable(Function0<Unit> callback) {
        Object object;
        Throwable throwable = null;
        Object object2 = object = gate;
        synchronized (object2) {
            boolean bl = false;
            if (exceptionThrown) {
                return;
            }
            INSTANCE.ensureInitialized();
            try {
                callback.invoke();
            }
            catch (Throwable t) {
                exceptionThrown = true;
                throwable = t;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (throwable != null) {
            try {
                LOG.log(Level.SEVERE, throwable, UsageTracker::runIfUsageTrackerUsable$lambda$3);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    @JvmStatic
    public static final void log(@NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkNotNullParameter((Object)studioEvent, (String)"studioEvent");
        UsageTracker.runIfUsageTrackerUsable((Function0<Unit>)((Function0)() -> UsageTracker.log$lambda$4(studioEvent)));
    }

    @JvmStatic
    public static final void log(@NotNull AndroidStudioEvent studioEvent) {
        Intrinsics.checkNotNullParameter((Object)studioEvent, (String)"studioEvent");
        UsageTracker.runIfUsageTrackerUsable((Function0<Unit>)((Function0)() -> UsageTracker.log$lambda$5(studioEvent)));
    }

    @JvmStatic
    public static final void log(long eventTimeMs, @NotNull AndroidStudioEvent.Builder studioEvent) {
        Intrinsics.checkNotNullParameter((Object)studioEvent, (String)"studioEvent");
        UsageTracker.runIfUsageTrackerUsable((Function0<Unit>)((Function0)() -> UsageTracker.log$lambda$6(eventTimeMs, studioEvent)));
    }

    private final void ensureInitialized() {
        if (!initialized && Boolean.getBoolean("idea.is.internal")) {
            throw new RuntimeException("call to UsageTracker before initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final UsageTrackerWriter<AndroidStudioEvent.Builder> initialize(@NotNull ScheduledExecutorService scheduler) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        if (isTesting) {
            return writer;
        }
        Object object = gate;
        synchronized (object) {
            boolean bl = false;
            UsageTrackerWriter<AndroidStudioEvent.Builder> oldInstance = writer;
            INSTANCE.initializeTrackerWriter(scheduler);
            try {
                oldInstance.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to close usage tracker", ex);
            }
            initialized = true;
            UsageTrackerWriter<AndroidStudioEvent.Builder> usageTrackerWriter = writer;
            return usageTrackerWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final UsageTrackerWriter<AndroidStudioEvent.Builder> initializeIfNotPresent(@NotNull ScheduledExecutorService scheduler) {
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Object object = gate;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (!initialized) break block4;
                UsageTrackerWriter<AndroidStudioEvent.Builder> usageTrackerWriter = writer;
                return usageTrackerWriter;
            }
            INSTANCE.initializeTrackerWriter(scheduler);
            initialized = true;
            UsageTrackerWriter<AndroidStudioEvent.Builder> usageTrackerWriter = writer;
            return usageTrackerWriter;
        }
    }

    @JvmStatic
    public static final void disable() {
        INSTANCE.deinitialize();
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void deinitialize() {
        Object object = gate;
        synchronized (object) {
            boolean bl = false;
            initialized = false;
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to close usage tracker", ex);
            }
            finally {
                writer = NullUsageTracker.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @VisibleForTesting
    @JvmStatic
    @NotNull
    public static final UsageTrackerWriter<AndroidStudioEvent.Builder> setWriterForTest(@NotNull UsageTrackerWriter<AndroidStudioEvent.Builder> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        Object object = gate;
        synchronized (object) {
            void var3_3;
            boolean bl = false;
            isTesting = true;
            initialized = true;
            exceptionThrown = false;
            UsageTrackerWriter<AndroidStudioEvent.Builder> old = writer;
            writer = tracker;
            void var4_5 = var3_3;
            return var4_5;
        }
    }

    @VisibleForTesting
    @JvmStatic
    public static final void cleanAfterTesting() {
        isTesting = false;
        writer = NullUsageTracker.INSTANCE;
        initialized = false;
        exceptionThrown = false;
    }

    private final void initializeTrackerWriter(ScheduledExecutorService scheduler) {
        if (AnalyticsSettings.getOptedIn()) {
            try {
                Path path = Paths.get(AnalyticsPaths.getSpoolDirectory(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                writer = new AnonymousUsageTrackerWriter(scheduler, path);
            }
            catch (RuntimeException ex) {
                writer = NullUsageTracker.INSTANCE;
                throw ex;
            }
        } else {
            writer = NullUsageTracker.INSTANCE;
        }
    }

    @NotNull
    public final Function1<AndroidStudioEvent.Builder, Unit> getListener() {
        return listener;
    }

    public final void setListener(@NotNull Function1<? super AndroidStudioEvent.Builder, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        listener = function1;
    }

    private static final Unit setMaxJournalTime$lambda$1(TimeUnit $unit, long $duration) {
        maxJournalTime = $unit.toNanos($duration);
        writer.scheduleJournalTimeout(maxJournalTime);
        return Unit.INSTANCE;
    }

    private static final String runIfUsageTrackerUsable$lambda$3() {
        return "UsageTracker call failed";
    }

    private static final Unit log$lambda$4(AndroidStudioEvent.Builder $studioEvent) {
        writer.logNow((AndroidStudioEvent.Builder)((GeneratedMessageV3.Builder)$studioEvent));
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$5(AndroidStudioEvent $studioEvent) {
        AndroidStudioEvent.Builder builder = $studioEvent.toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"toBuilder(...)");
        writer.logNow((AndroidStudioEvent.Builder)((GeneratedMessageV3.Builder)builder));
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$6(long $eventTimeMs, AndroidStudioEvent.Builder $studioEvent) {
        writer.logAt($eventTimeMs, (AndroidStudioEvent.Builder)((GeneratedMessageV3.Builder)$studioEvent));
        return Unit.INSTANCE;
    }

    private static final Unit listener$lambda$11(AndroidStudioEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    static {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        sessionId = string;
        writer = NullUsageTracker.INSTANCE;
        ideBrand = AndroidStudioEvent.IdeBrand.UNKNOWN_IDE_BRAND;
        listener = UsageTracker::listener$lambda$11;
    }
}

