/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.utils.ILogger;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\r\u0018\u0000 <2\u00020\u0001:\u0002<=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\"\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001c\u0010-\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010'\"\u0004\b/\u0010)R(\u00100\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u000b\"\u0004\b8\u0010\rR\u001a\u00109\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010!\"\u0004\b;\u0010#\u00a8\u0006>"}, d2={"Lcom/android/tools/analytics/AnalyticsSettingsData;", "", "<init>", "()V", "saveSettings", "", "logger", "Lcom/android/utils/ILogger;", "userId", "", "getUserId", "()Ljava/lang/String;", "setUserId", "(Ljava/lang/String;)V", "optedIn", "", "getOptedIn", "()Z", "setOptedIn", "(Z)V", "value", "debugDisablePublishing", "getDebugDisablePublishing", "saltValue", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "getSaltValue", "()Ljava/math/BigInteger;", "setSaltValue", "(Ljava/math/BigInteger;)V", "saltSkew", "", "getSaltSkew", "()I", "setSaltSkew", "(I)V", "lastSentimentQuestionDate", "Ljava/util/Date;", "getLastSentimentQuestionDate", "()Ljava/util/Date;", "setLastSentimentQuestionDate", "(Ljava/util/Date;)V", "lastSentimentAnswerDate", "getLastSentimentAnswerDate", "setLastSentimentAnswerDate", "nextFeatureSurveyDate", "getNextFeatureSurveyDate", "setNextFeatureSurveyDate", "nextFeatureSurveyDateMap", "", "getNextFeatureSurveyDateMap", "()Ljava/util/Map;", "setNextFeatureSurveyDateMap", "(Ljava/util/Map;)V", "lastOptinPromptVersion", "getLastOptinPromptVersion", "setLastOptinPromptVersion", "popSentimentQuestionFrequency", "getPopSentimentQuestionFrequency", "setPopSentimentQuestionFrequency", "Companion", "DataTypeAdapter", "analytics-shared"})
public final class AnalyticsSettingsData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String userId;
    private boolean optedIn;
    private boolean debugDisablePublishing;
    private BigInteger saltValue = BigInteger.valueOf(0L);
    private int saltSkew = -1;
    @Nullable
    private Date lastSentimentQuestionDate;
    @Nullable
    private Date lastSentimentAnswerDate;
    @Nullable
    private Date nextFeatureSurveyDate;
    @Nullable
    private Map<String, Date> nextFeatureSurveyDateMap;
    @Nullable
    private String lastOptinPromptVersion;
    private int popSentimentQuestionFrequency;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveSettings(@Nullable ILogger logger) {
        File file = AnalyticsSettings.INSTANCE.getSettingsFile$analytics_shared();
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            Closeable closeable = new RandomAccessFile(file, "rw");
            Throwable throwable = null;
            try {
                RandomAccessFile settingsFile = (RandomAccessFile)closeable;
                boolean bl = false;
                Closeable closeable2 = settingsFile.getChannel();
                Throwable throwable2 = null;
                try {
                    FileChannel channel = (FileChannel)closeable2;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable = channel.tryLock();
                    Throwable throwable3 = null;
                    try {
                        AnalyticsSettingsData existingData;
                        FileLock lock = (FileLock)autoCloseable;
                        boolean bl3 = false;
                        if (lock == null) {
                            throw new IOException("Unable to lock settings file " + file);
                        }
                        Intrinsics.checkNotNull((Object)channel);
                        AnalyticsSettingsData analyticsSettingsData = existingData = Companion.parseSettingsData(channel, file, null);
                        boolean bl4 = analyticsSettingsData != null ? analyticsSettingsData.saltSkew == this.saltSkew : false;
                        if (bl4) {
                            this.saltValue = existingData.saltValue;
                        }
                        channel.truncate(0L);
                        OutputStream outputStream = Channels.newOutputStream(channel);
                        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                        DataTypeAdapter.INSTANCE.write(new JsonWriter((Writer)writer), this);
                        writer.flush();
                        outputStream.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new IOException("Unable to lock settings file " + file, e);
        }
    }

    public static /* synthetic */ void saveSettings$default(AnalyticsSettingsData analyticsSettingsData, ILogger iLogger, int n, Object object) {
        if ((n & 1) != 0) {
            iLogger = null;
        }
        analyticsSettingsData.saveSettings(iLogger);
    }

    @Nullable
    public final String getUserId() {
        return this.userId;
    }

    public final void setUserId(@Nullable String string) {
        this.userId = string;
    }

    public final boolean getOptedIn() {
        return this.optedIn;
    }

    public final void setOptedIn(boolean bl) {
        this.optedIn = bl;
    }

    public final boolean getDebugDisablePublishing() {
        return this.debugDisablePublishing;
    }

    public final BigInteger getSaltValue() {
        return this.saltValue;
    }

    public final void setSaltValue(BigInteger bigInteger) {
        this.saltValue = bigInteger;
    }

    public final int getSaltSkew() {
        return this.saltSkew;
    }

    public final void setSaltSkew(int n) {
        this.saltSkew = n;
    }

    @Nullable
    public final Date getLastSentimentQuestionDate() {
        return this.lastSentimentQuestionDate;
    }

    public final void setLastSentimentQuestionDate(@Nullable Date date) {
        this.lastSentimentQuestionDate = date;
    }

    @Nullable
    public final Date getLastSentimentAnswerDate() {
        return this.lastSentimentAnswerDate;
    }

    public final void setLastSentimentAnswerDate(@Nullable Date date) {
        this.lastSentimentAnswerDate = date;
    }

    @Nullable
    public final Date getNextFeatureSurveyDate() {
        return this.nextFeatureSurveyDate;
    }

    public final void setNextFeatureSurveyDate(@Nullable Date date) {
        this.nextFeatureSurveyDate = date;
    }

    @Nullable
    public final Map<String, Date> getNextFeatureSurveyDateMap() {
        return this.nextFeatureSurveyDateMap;
    }

    public final void setNextFeatureSurveyDateMap(@Nullable Map<String, Date> map) {
        this.nextFeatureSurveyDateMap = map;
    }

    @Nullable
    public final String getLastOptinPromptVersion() {
        return this.lastOptinPromptVersion;
    }

    public final void setLastOptinPromptVersion(@Nullable String string) {
        this.lastOptinPromptVersion = string;
    }

    public final int getPopSentimentQuestionFrequency() {
        return this.popSentimentQuestionFrequency;
    }

    public final void setPopSentimentQuestionFrequency(int n) {
        this.popSentimentQuestionFrequency = n;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/analytics/AnalyticsSettingsData$Companion;", "", "<init>", "()V", "parseSettingsData", "Lcom/android/tools/analytics/AnalyticsSettingsData;", "channel", "Ljava/nio/channels/FileChannel;", "file", "Ljava/io/File;", "logger", "Lcom/android/utils/ILogger;", "analytics-shared"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AnalyticsSettingsData parseSettingsData(@NotNull FileChannel channel, @NotNull File file, @Nullable ILogger logger) {
            AnalyticsSettingsData analyticsSettingsData;
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (channel.size() == 0L) {
                return null;
            }
            InputStream inputStream = Channels.newInputStream(channel);
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
                reader.setLenient(true);
                analyticsSettingsData = DataTypeAdapter.INSTANCE.read(reader);
            }
            catch (Throwable t) {
                ILogger iLogger = logger;
                if (iLogger != null) {
                    Object[] objectArray = new Object[]{file.toString(), t};
                    iLogger.warning("Unable to parse settings file %s: %s", objectArray);
                }
                analyticsSettingsData = null;
            }
            return analyticsSettingsData;
        }

        public static /* synthetic */ AnalyticsSettingsData parseSettingsData$default(Companion companion, FileChannel fileChannel, File file, ILogger iLogger, int n, Object object) {
            if ((n & 4) != 0) {
                iLogger = null;
            }
            return companion.parseSettingsData(fileChannel, file, iLogger);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/analytics/AnalyticsSettingsData$DataTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/tools/analytics/AnalyticsSettingsData;", "<init>", "()V", "datePatternJava8", "Ljava/text/SimpleDateFormat;", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "data", "format", "", "it", "Ljava/util/Date;", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "parseDate", "string", "analytics-shared"})
    @SourceDebugExtension(value={"SMAP\nAnalyticsSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsSettings.kt\ncom/android/tools/analytics/AnalyticsSettingsData$DataTypeAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,582:1\n1#2:583\n216#3,2:584\n*S KotlinDebug\n*F\n+ 1 AnalyticsSettings.kt\ncom/android/tools/analytics/AnalyticsSettingsData$DataTypeAdapter\n*L\n523#1:584,2\n*E\n"})
    public static final class DataTypeAdapter
    extends TypeAdapter<AnalyticsSettingsData> {
        @NotNull
        public static final DataTypeAdapter INSTANCE = new DataTypeAdapter();
        @NotNull
        private static final SimpleDateFormat datePatternJava8 = new SimpleDateFormat("MMM d, y h:mm:ss a", Locale.US);

        private DataTypeAdapter() {
        }

        public void write(@NotNull JsonWriter writer, @NotNull AnalyticsSettingsData data) {
            Object it;
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            writer.beginObject();
            String string = data.getUserId();
            if (string != null) {
                it = string;
                boolean bl = false;
                writer.name("userId").value((String)it);
            }
            writer.name("hasOptedIn").value(data.getOptedIn());
            writer.name("debugDisablePublishing").value(data.getDebugDisablePublishing());
            writer.name("saltValue").value((Number)data.getSaltValue());
            writer.name("saltSkew").value((Number)data.getSaltSkew());
            Date date = data.getLastSentimentQuestionDate();
            if (date != null) {
                it = date;
                boolean bl = false;
                writer.name("lastSentimentQuestionDate").value(INSTANCE.format((Date)it));
            }
            Date date2 = data.getLastSentimentAnswerDate();
            if (date2 != null) {
                it = date2;
                boolean bl = false;
                writer.name("lastSentimentAnswerDate").value(INSTANCE.format((Date)it));
            }
            Date date3 = data.getNextFeatureSurveyDate();
            if (date3 != null) {
                it = date3;
                boolean bl = false;
                writer.name("lastFeatureSurveyDate").value(INSTANCE.format((Date)it));
            }
            Map<String, Date> map = data.getNextFeatureSurveyDateMap();
            if (map != null) {
                it = map;
                boolean bl = false;
                writer.name("lastFeatureSurveyDateMap");
                writer.beginObject();
                Object $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String key = (String)entry.getKey();
                    Date value = (Date)entry.getValue();
                    writer.name(key).value(INSTANCE.format(value));
                }
                writer.endObject();
            }
            String string2 = data.getLastOptinPromptVersion();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                writer.name("lastOptinPromptVersion").value((String)it);
            }
            writer.endObject();
        }

        private final String format(Date it) {
            String string = datePatternJava8.format(it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public AnalyticsSettingsData read(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            AnalyticsSettingsData data = new AnalyticsSettingsData();
            if (!reader.hasNext()) {
                return data;
            }
            reader.beginObject();
            block24: while (reader.hasNext()) {
                block38: {
                    String string = reader.nextName();
                    if (string == null) break block38;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1802167259: {
                            if (string.equals("lastSentimentAnswerDate")) {
                                n = 1;
                            }
                            break;
                        }
                        case -945556526: {
                            if (string.equals("lastOptinPromptVersion")) {
                                n = 2;
                            }
                            break;
                        }
                        case 673137165: {
                            if (string.equals("lastSentimentQuestionDate")) {
                                n = 3;
                            }
                            break;
                        }
                        case 1597825896: {
                            if (string.equals("debugDisablePublishing")) {
                                n = 4;
                            }
                            break;
                        }
                        case 782781277: {
                            if (string.equals("hasOptedIn")) {
                                n = 5;
                            }
                            break;
                        }
                        case 319596219: {
                            if (string.equals("saltValue")) {
                                n = 6;
                            }
                            break;
                        }
                        case 1949892224: {
                            if (string.equals("saltSkew")) {
                                n = 7;
                            }
                            break;
                        }
                        case -836030906: {
                            if (string.equals("userId")) {
                                n = 8;
                            }
                            break;
                        }
                        case 1568219764: {
                            if (string.equals("lastFeatureSurveyDateMap")) {
                                n = 9;
                            }
                            break;
                        }
                        case 2012665288: {
                            if (string.equals("lastFeatureSurveyDate")) {
                                n = 10;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 8: {
                            data.setUserId(reader.nextString());
                            continue block24;
                        }
                        case 5: {
                            data.setOptedIn(reader.nextBoolean());
                            continue block24;
                        }
                        case 4: {
                            data.debugDisablePublishing = reader.nextBoolean();
                            continue block24;
                        }
                        case 6: {
                            data.setSaltValue(new BigInteger(reader.nextString()));
                            continue block24;
                        }
                        case 7: {
                            data.setSaltSkew(reader.nextInt());
                            continue block24;
                        }
                        case 3: {
                            String string2 = reader.nextString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                            data.setLastSentimentQuestionDate(this.parseDate(string2));
                            continue block24;
                        }
                        case 1: {
                            String string3 = reader.nextString();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"nextString(...)");
                            data.setLastSentimentAnswerDate(this.parseDate(string3));
                            continue block24;
                        }
                        case 10: {
                            String string4 = reader.nextString();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"nextString(...)");
                            data.setNextFeatureSurveyDate(this.parseDate(string4));
                            continue block24;
                        }
                        case 9: {
                            Map map = data.getNextFeatureSurveyDateMap();
                            if (map == null) {
                                map = new LinkedHashMap();
                            }
                            Map map2 = map;
                            reader.beginObject();
                            while (reader.hasNext()) {
                                Map map3 = map2;
                                String string5 = reader.nextName();
                                String string6 = reader.nextString();
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"nextString(...)");
                                Date date = this.parseDate(string6);
                                map3.put(string5, date);
                            }
                            reader.endObject();
                            data.setNextFeatureSurveyDateMap(map2);
                            continue block24;
                        }
                        case 2: {
                            data.setLastOptinPromptVersion(reader.nextString());
                            continue block24;
                        }
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return data;
        }

        private final Date parseDate(String string) {
            Date date = datePatternJava8.parse(string);
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"parse(...)");
            return date;
        }
    }
}

