/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.internal.ArrayIterator;
import org.hamcrest.internal.SelfDescribingValueIterator;

public abstract class BaseDescription
implements Description {
    @Override
    public Description appendText(String text) {
        this.append(text);
        return this;
    }

    @Override
    public Description appendDescriptionOf(SelfDescribing value2) {
        value2.describeTo(this);
        return this;
    }

    @Override
    public Description appendValue(Object value2) {
        if (value2 == null) {
            this.append("null");
        } else if (value2 instanceof String) {
            this.toJavaSyntax((String)value2);
        } else if (value2 instanceof Character) {
            this.append('\"');
            this.toJavaSyntax(((Character)value2).charValue());
            this.append('\"');
        } else if (value2 instanceof Byte) {
            this.append('<');
            this.append(this.descriptionOf(value2));
            this.append("b>");
        } else if (value2 instanceof Short) {
            this.append('<');
            this.append(this.descriptionOf(value2));
            this.append("s>");
        } else if (value2 instanceof Long) {
            this.append('<');
            this.append(this.descriptionOf(value2));
            this.append("L>");
        } else if (value2 instanceof Float) {
            this.append('<');
            this.append(this.descriptionOf(value2));
            this.append("F>");
        } else if (value2.getClass().isArray()) {
            this.appendValueList("[", ", ", "]", new ArrayIterator(value2));
        } else {
            this.append('<');
            this.append(this.descriptionOf(value2));
            this.append('>');
        }
        return this;
    }

    private String descriptionOf(Object value2) {
        try {
            return String.valueOf(value2);
        }
        catch (Exception e) {
            return value2.getClass().getName() + "@" + Integer.toHexString(value2.hashCode());
        }
    }

    @Override
    @SafeVarargs
    public final <T> Description appendValueList(String start, String separator, String end, T ... values) {
        return this.appendValueList(start, separator, end, (Iterable<T>)Arrays.asList(values));
    }

    @Override
    public <T> Description appendValueList(String start, String separator, String end, Iterable<T> values) {
        return this.appendValueList(start, separator, end, values.iterator());
    }

    private <T> Description appendValueList(String start, String separator, String end, Iterator<T> values) {
        return this.appendList(start, separator, end, new SelfDescribingValueIterator<T>(values));
    }

    @Override
    public Description appendList(String start, String separator, String end, Iterable<? extends SelfDescribing> values) {
        return this.appendList(start, separator, end, values.iterator());
    }

    private Description appendList(String start, String separator, String end, Iterator<? extends SelfDescribing> i2) {
        boolean separate = false;
        this.append(start);
        while (i2.hasNext()) {
            if (separate) {
                this.append(separator);
            }
            this.appendDescriptionOf(i2.next());
            separate = true;
        }
        this.append(end);
        return this;
    }

    protected void append(String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            this.append(str.charAt(i2));
        }
    }

    protected abstract void append(char var1);

    private void toJavaSyntax(String unformatted) {
        this.append('\"');
        for (int i2 = 0; i2 < unformatted.length(); ++i2) {
            this.toJavaSyntax(unformatted.charAt(i2));
        }
        this.append('\"');
    }

    private void toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                this.append("\\\"");
                break;
            }
            case '\n': {
                this.append("\\n");
                break;
            }
            case '\r': {
                this.append("\\r");
                break;
            }
            case '\t': {
                this.append("\\t");
                break;
            }
            case '\\': {
                this.append("\\\\");
                break;
            }
            default: {
                this.append(ch);
            }
        }
    }
}

