/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Lists;

class IterableDiff<T> {
    private final ComparisonStrategy comparisonStrategy;
    List<T> unexpected;
    List<T> missing;

    IterableDiff(Iterable<T> actual, Iterable<T> expected, ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
        this.unexpected = this.unexpectedActualElements(actual, expected);
        this.missing = this.missingActualElements(actual, expected);
    }

    static <T> IterableDiff<T> diff(Iterable<T> actual, Iterable<T> expected, ComparisonStrategy comparisonStrategy) {
        return new IterableDiff<T>(actual, expected, comparisonStrategy);
    }

    static <T> IterableDiff<T> diff(Iterable<T> actual, Iterable<T> expected) {
        return IterableDiff.diff(actual, expected, StandardComparisonStrategy.instance());
    }

    boolean differencesFound() {
        return !this.unexpected.isEmpty() || !this.missing.isEmpty();
    }

    private List<T> unexpectedActualElements(Iterable<T> actual, Iterable<T> expected) {
        ArrayList<T> missingInFirst = new ArrayList<T>();
        ArrayList<T> copyOfExpected = Lists.newArrayList(expected);
        for (T elementInActual : actual) {
            if (this.isActualElementInExpected(elementInActual, copyOfExpected)) {
                this.iterablesRemoveFirst(copyOfExpected, elementInActual);
                continue;
            }
            missingInFirst.add(elementInActual);
        }
        return Collections.unmodifiableList(missingInFirst);
    }

    private boolean isActualElementInExpected(T elementInActual, List<T> copyOfExpected) {
        return copyOfExpected.stream().anyMatch(expectedElement -> this.comparisonStrategy.areEqual(elementInActual, expectedElement));
    }

    private List<T> missingActualElements(Iterable<T> actual, Iterable<T> expected) {
        ArrayList<T> missingInExpected = new ArrayList<T>();
        ArrayList<T> copyOfActual = Lists.newArrayList(actual);
        for (T expectedElement : expected) {
            if (this.iterableContains(copyOfActual, expectedElement)) {
                this.iterablesRemoveFirst(copyOfActual, expectedElement);
                continue;
            }
            missingInExpected.add(expectedElement);
        }
        return Collections.unmodifiableList(missingInExpected);
    }

    private boolean iterableContains(Iterable<?> actual, T expectedElement) {
        return this.comparisonStrategy.iterableContains(actual, expectedElement);
    }

    private void iterablesRemoveFirst(Iterable<?> actual, T value2) {
        this.comparisonStrategy.iterablesRemoveFirst(actual, value2);
    }
}

