/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import org.assertj.core.data.TemporalUnitOffset;

public class TemporalUnitWithinOffset
extends TemporalUnitOffset {
    public TemporalUnitWithinOffset(long value2, TemporalUnit unit) {
        super(value2, unit);
    }

    @Override
    public boolean isBeyondOffset(Temporal temporal1, Temporal temporal2) {
        try {
            return this.getDifference(temporal1, temporal2) > this.value;
        }
        catch (ArithmeticException e) {
            return this.getAbsoluteDuration(temporal1, temporal2).compareTo(Duration.of(this.value, this.unit)) > 0;
        }
    }

    @Override
    public String getBeyondOffsetDifferenceDescription(Temporal temporal1, Temporal temporal2) {
        return "within " + super.getBeyondOffsetDifferenceDescription(temporal1, temporal2);
    }
}

