/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.SoftAssertionsProvider;
import org.assertj.core.error.AssertionErrorCreator;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

class SoftAssertionsStatement {
    private SoftAssertionsProvider soft;
    private AssertionErrorCreator assertionErrorCreator = new AssertionErrorCreator();

    private SoftAssertionsStatement(SoftAssertionsProvider soft) {
        this.soft = soft;
    }

    public static Statement softAssertionsStatement(SoftAssertionsProvider softAssertions, Statement baseStatement) {
        return new SoftAssertionsStatement(softAssertions).build(baseStatement);
    }

    private Statement build(final Statement baseStatement) {
        return new Statement(){

            public void evaluate() throws Throwable {
                baseStatement.evaluate();
                List<AssertionError> errors2 = SoftAssertionsStatement.this.soft.assertionErrorsCollected();
                if (errors2.isEmpty()) {
                    return;
                }
                SoftAssertionsStatement.this.assertionErrorCreator.tryThrowingMultipleFailuresError(errors2);
                MultipleFailureException.assertEmpty(new ArrayList<AssertionError>(errors2));
            }
        };
    }
}

