/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XTestValueNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public interface OCDebuggingTestMixin {
    @NotNull
    public Project getProject();

    @NotNull
    public CidrDebuggingFixture<?> getDebuggingFixture();

    public long getStartupTimeout();

    public long getEvaluateTimeout();

    public BlockingQueue<CidrDebuggingFixture.DebuggerState> startDebugSessionAndWaitForPause() throws Exception;

    public BlockingQueue<CidrDebuggingFixture.DebuggerState> startDebugSessionAndWaitForPause(@Nullable String var1) throws Exception;

    default public void setDefaultSettings() {
        CidrDebuggerSettings.getInstance().setRenderersEnabled(true);
        CidrDebuggerSettings.getInstance().setCocoaRenderersEnabled(true);
        CidrDebuggerSettings.getInstance().setStlRenderersEnabled(true);
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(true);
        this.getProject().putUserData(CidrValue.DO_NOT_SHOW_ADDRESSES, (Object)true);
    }

    default public String getConsoleText() {
        return this.getDebuggingFixture().getConsoleText();
    }

    default public void assertFrame(XStackFrame stackFrame, @Nullable String method, @Nullable Integer line) {
        CidrStackFrame cidrStackFrame = (CidrStackFrame)stackFrame;
        LLFrame frame = cidrStackFrame.getFrame();
        if (method != null) {
            Assert.assertEquals((String)frame.toString(), (Object)method, (Object)frame.getFunction());
        }
        if (line != null) {
            Assert.assertEquals((String)frame.toString(), (long)line.intValue(), (long)frame.getLine());
        }
    }

    default public XTestValueNode computePresentation(@NotNull XValue value2) {
        if (value2 == null) {
            OCDebuggingTestMixin.$$$reportNull$$$0(0);
        }
        return this.computePresentation(value2, CidrExecutionFixture.TIMEOUT);
    }

    default public XTestValueNode computePresentation(XValue value2, long timeout) {
        XTestValueNode node = new XTestValueNode();
        if (value2 instanceof XNamedValue) {
            node.myName = ((XNamedValue)value2).getName();
        }
        value2.computePresentation((XValueNode)node, XValuePlace.TREE);
        node.waitFor(timeout);
        return node;
    }

    default public void toggleBreakpoint(Project project, VirtualFile file, int line) {
        WriteAction.runAndWait(() -> XDebuggerUtil.getInstance().toggleLineBreakpoint(project, file, line));
    }

    default public void assertVariable(Pair<XValue, String> varAndErrorMessage, @Nullable String name, @Nullable String type, @Nullable String value2, @Nullable Boolean hasChildren) {
        Assert.assertNull((Object)varAndErrorMessage.second);
        this.assertVariable((XValue)varAndErrorMessage.first, name, type, value2, hasChildren);
    }

    default public void assertVariable(Collection<XValue> vars, @Nullable String name, @Nullable String type, @Nullable String value2, @Nullable Boolean hasChildren) {
        this.assertVariable(XDebuggerTestUtil.findVar(vars, name), name, type, value2, hasChildren);
    }

    default public void assertVariable(XValue var, @Nullable String name, @Nullable String type, @Nullable String value2, @Nullable Boolean hasChildren) {
        XTestValueNode node = this.computePresentation(var);
        if (name != null) {
            Assert.assertEquals((Object)name, (Object)node.myName);
        }
        if (type != null) {
            Assert.assertEquals((Object)type, (Object)node.myType);
        }
        if (value2 != null) {
            Assert.assertEquals((Object)value2, (Object)node.myValue);
        }
        if (hasChildren != null) {
            Assert.assertEquals((Object)hasChildren, (Object)node.myHasChildren);
        }
    }

    default public List<XValue> collectVars(int frame) {
        XStackFrame frame1 = XDebuggerTestUtil.getFrameAt(this.getDebuggingFixture().getSession(), frame);
        return XDebuggerTestUtil.collectChildren((XValueContainer)frame1);
    }

    default public XExecutionStack getMainThread(List<XExecutionStack> threads) {
        return this.getDebuggingFixture().getMainThread(threads);
    }

    default public List<XExecutionStack> collectThreads() {
        return this.getDebuggingFixture().collectThreads();
    }

    default public XDebugSession getSession() {
        return this.getDebuggingFixture().getSession();
    }

    default public Pair<XValue, String> evaluate(String expression) {
        return XDebuggerTestUtil.evaluate(this.getSession(), expression, this.getEvaluateTimeout());
    }

    default public BlockingQueue<CidrDebuggingFixture.DebuggerState> startDebugSessionWithRestart(@Nullable String parameters) throws Exception {
        int simulatorRestartAttempts = this.getRestartAttempts();
        for (int attempt = 1; attempt <= simulatorRestartAttempts; ++attempt) {
            BlockingQueue<CidrDebuggingFixture.DebuggerState> stateQueue = this.getDebuggingFixture().startDebugSessionWithListener(parameters);
            CidrDebuggingFixture.DebuggerState state = CidrDebuggingFixture.waitFor(stateQueue, this.getStartupTimeout());
            if (attempt >= simulatorRestartAttempts || state == CidrDebuggingFixture.DebuggerState.PAUSED) {
                Assert.assertNotNull((String)("Timed out (" + this.getStartupTimeout() + ") at attempt #" + attempt + " while waiting for the debugger to pause"), (Object)state);
                Assert.assertEquals((String)("At attempt #" + attempt), (Object)CidrDebuggingFixture.DebuggerState.PAUSED, (Object)state);
                XDebuggerTestUtil.waitForSwing();
                return stateQueue;
            }
            this.shutdownSimulators();
            Thread.sleep(CidrExecutionFixture.TIMEOUT);
        }
        Assert.fail((String)"At least one attempt should be given");
        return null;
    }

    default public void shutdownSimulators() {
    }

    default public int getRestartAttempts() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/OCDebuggingTestMixin", "computePresentation"));
    }
}

