/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ResourceUtil;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInspectionUtil {
    private static final Logger LOG = Logger.getInstance(OCInspectionUtil.class);

    private OCInspectionUtil() {
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull Class<? extends LocalInspectionTool> inspectionClass, @Nullable InspectionProfile inspectionProfile, @Nullable PsiElement element, @Nullable HighlightSeverity defaultHighlightSeverity) {
        if (inspectionClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(0);
        }
        return element != null ? OCInspectionUtil.getHighlightSeverity(inspectionClass, inspectionProfile, element, element.getProject(), defaultHighlightSeverity) : defaultHighlightSeverity;
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull Class<? extends LocalInspectionTool> inspectionClass, @Nullable InspectionProfile inspectionProfile, @Nullable PsiElement element, @NotNull Project project, @Nullable HighlightSeverity defaultHighlightSeverity) {
        if (inspectionClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OCInspectionUtil.$$$reportNull$$$0(2);
        }
        if (OCInspectionBase.OtherObjCMarker.class.isAssignableFrom(inspectionClass) || OCInspectionBase.OtherCppMarker.class.isAssignableFrom(inspectionClass)) {
            return defaultHighlightSeverity;
        }
        String inspectionShortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (inspectionShortName == null) {
            return null;
        }
        return OCInspectionUtil.getHighlightSeverity(inspectionShortName, inspectionProfile, element, project, defaultHighlightSeverity);
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull String inspectionName, @Nullable InspectionProfile inspectionProfile, @Nullable PsiElement element, @NotNull Project project, @Nullable HighlightSeverity defaultHighlightSeverity) {
        HighlightDisplayKey highlightDisplayKey;
        if (inspectionName == null) {
            OCInspectionUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            OCInspectionUtil.$$$reportNull$$$0(4);
        }
        if (inspectionProfile == null) {
            inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        }
        if (!inspectionProfile.isToolEnabled(highlightDisplayKey = HighlightDisplayKey.find((String)inspectionName), element) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (highlightDisplayKey == null) {
            return defaultHighlightSeverity;
        }
        HighlightDisplayLevel highlightDisplayLevel = inspectionProfile.getErrorLevel(highlightDisplayKey, element);
        return highlightDisplayLevel.getSeverity();
    }

    @Nullable
    public static String getInspectionShortName(@NotNull Class<? extends InspectionProfileEntry> inspectionClass) {
        if (inspectionClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(5);
        }
        try {
            return inspectionClass.newInstance().getShortName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Cannot get inspection short name: " + String.valueOf(e));
            return null;
        }
    }

    @Nullable
    public static String getInspectionGroupDisplayName(@NotNull Class<? extends LocalInspectionTool> inspectionClass) {
        if (inspectionClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(6);
        }
        try {
            return inspectionClass.newInstance().getGroupDisplayName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Cannot get inspection group display name name: " + String.valueOf(e));
            return null;
        }
    }

    private static boolean isInspectionGroup(@NotNull Class<? extends InspectionProfileEntry> inspectionClass) {
        if (inspectionClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(7);
        }
        try {
            return inspectionClass.newInstance().getMainToolId() == null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Cannot get inspection group main tool id: " + String.valueOf(e));
            return false;
        }
    }

    @Nullable
    @Nls
    public static String getStaticDescription(@NotNull OCInspectionBase inspection) {
        String shortName;
        if (inspection == null) {
            OCInspectionUtil.$$$reportNull$$$0(8);
        }
        if ((shortName = OCInspectionUtil.getInspectionShortName(inspection.getInspectionClass())) != null) {
            try {
                InputStream descriptionStream = ResourceUtil.getResourceAsStream((ClassLoader)((Object)((Object)inspection)).getClass().getClassLoader(), (String)"inspectionDescriptions", (String)(shortName + ".html"));
                return descriptionStream != null ? ResourceUtil.loadText((InputStream)descriptionStream) : null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    public static boolean isInspectionEnabled(@NotNull Project project, @Nullable Class<? extends LocalInspectionTool> inspectionClass) {
        if (project == null) {
            OCInspectionUtil.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (inspectionClass == null) {
            return false;
        }
        String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        HighlightDisplayKey key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        return inspectionProfile.isToolEnabled(key, null);
    }

    public static void setInspectionEnabled(@NotNull Project project, @Nullable Class<? extends OCInspectionBase> inspectionClass, boolean enabled) {
        if (project == null) {
            OCInspectionUtil.$$$reportNull$$$0(10);
        }
        if (inspectionClass == null) {
            return;
        }
        String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (shortName != null) {
            InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            inspectionProfile.setToolEnabled(shortName, enabled, project);
        }
    }

    public static boolean isInspectionGroupEnabled(@NotNull PsiElement element, @NotNull Class<? extends LocalInspectionTool> groupClass, boolean checkInspectionGroup) {
        if (element == null) {
            OCInspectionUtil.$$$reportNull$$$0(11);
        }
        if (groupClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(12);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        for (InspectionToolWrapper wrapper : inspectionProfile.getInspectionTools(element)) {
            String shortName;
            HighlightDisplayKey highlightDisplayKey;
            Class<?> c = wrapper.getTool().getClass();
            if (!groupClass.isAssignableFrom(c) || checkInspectionGroup && OCInspectionUtil.isInspectionGroup(c) || (highlightDisplayKey = (shortName = OCInspectionUtil.getInspectionShortName(c)) != null ? HighlightDisplayKey.find((String)shortName) : null) == null || !inspectionProfile.isToolEnabled(highlightDisplayKey, element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement findSameElementInCopy(@NotNull SmartPsiElementPointer<? extends PsiElement> elementPointer, @NotNull PsiFile copy) {
        PsiElement element;
        if (elementPointer == null) {
            OCInspectionUtil.$$$reportNull$$$0(13);
        }
        if (copy == null) {
            OCInspectionUtil.$$$reportNull$$$0(14);
        }
        if ((element = elementPointer.getElement()) == null || !element.isValid()) {
            return null;
        }
        if (element.getContainingFile() instanceof PsiCodeFragment) {
            return element.copy();
        }
        return PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)copy);
    }

    @Nullable
    public static List<PsiElement> findSameElementsInCopy(@NotNull List<SmartPsiElementPointer> elementPointers, @NotNull PsiFile copyFile) {
        if (elementPointers == null) {
            OCInspectionUtil.$$$reportNull$$$0(15);
        }
        if (copyFile == null) {
            OCInspectionUtil.$$$reportNull$$$0(16);
        }
        ArrayList<PsiElement> copyElements = new ArrayList<PsiElement>(elementPointers.size());
        for (SmartPsiElementPointer pointer : elementPointers) {
            PsiElement element = pointer.getElement();
            if (element == null || !element.isValid()) {
                return null;
            }
            if (element.getContainingFile() instanceof PsiCodeFragment) {
                copyElements.add(element.copy());
                continue;
            }
            copyElements.add(PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)copyFile));
        }
        return copyElements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementPointer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementPointers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCInspectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighlightSeverity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInspectionShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInspectionGroupDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInspectionGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getStaticDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isInspectionEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setInspectionEnabled";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isInspectionGroupEnabled";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findSameElementInCopy";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findSameElementsInCopy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

