/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0002H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"HTTP_SCHEMES", "", "", "isValidUrl", "", "url", "isValidCustomScheme", "url-assistant"})
public final class UrlUtilsKt {
    @NotNull
    private static final List<String> HTTP_SCHEMES;

    public static final boolean isValidUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            new URL(((Object)StringsKt.trim((CharSequence)url)).toString());
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static final boolean isValidCustomScheme(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            URI uri = new URI(((Object)StringsKt.trim((CharSequence)url)).toString());
            CharSequence charSequence = uri.getScheme();
            return !(charSequence == null || charSequence.length() == 0) && !HTTP_SCHEMES.contains(uri.getScheme());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    static {
        Object[] objectArray = new String[]{"http", "https"};
        HTTP_SCHEMES = CollectionsKt.listOf((Object[])objectArray);
    }
}

