/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Sha256FingerprintUtils {
    private static Logger getLog() {
        return Logger.getInstance(Sha256FingerprintUtils.class);
    }

    @NotNull
    public static List<String> getAliases(@Nullable String filePath, @Nullable char[] password) {
        try {
            return Sha256FingerprintUtils.getAliasesOrThrowException(filePath, password);
        }
        catch (FileNotFoundException e) {
            Sha256FingerprintUtils.getLog().warn("Cannot find the keystore file.");
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        catch (WrongPasswordException e) {
            Sha256FingerprintUtils.getLog().warn("Incorrect password supplied for keystore: " + e.getMessage());
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.check.password", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Sha256FingerprintUtils.getLog().warn("Error when generating keystore fingerprint: " + e.getMessage());
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<String> getAliasesOrThrowException(@Nullable String filePath, @Nullable char[] password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, WrongPasswordException {
        ArrayList<String> arrayList;
        FileInputStream is = new FileInputStream(filePath);
        try {
            ArrayList<String> aliases = new ArrayList<String>();
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, password);
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                aliases.add(e.nextElement());
            }
            arrayList = aliases;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (e.getCause() instanceof UnrecoverableKeyException) {
                    throw new WrongPasswordException();
                }
                throw e;
            }
        }
        is.close();
        return arrayList;
    }

    @UiThread
    @NotNull
    public static String generateFingerprints(@Nullable String filePath, @Nullable String alias, @Nullable String password) {
        try {
            return Sha256FingerprintUtils.generateFingerprintsOrThrowException(filePath, alias, password);
        }
        catch (FileNotFoundException e) {
            Sha256FingerprintUtils.getLog().warn("Cannot find the keystore file.");
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        catch (AliasNotFoundException e) {
            Sha256FingerprintUtils.getLog().warn("Tried to generate keystore fingerprint for invalid alias: " + e.getMessage());
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.no.alias", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        catch (WrongPasswordException | IOException e) {
            Sha256FingerprintUtils.getLog().warn("Error when generating keystore fingerprint: " + e.getMessage());
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.check.password", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Sha256FingerprintUtils.getLog().warn("Error when generating keystore fingerprint: " + e.getMessage());
            Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
        }
        return "";
    }

    @NotNull
    public static String generateFingerprintsOrThrowException(@Nullable String filePath, @Nullable String alias, @Nullable String password) throws AliasNotFoundException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, WrongPasswordException {
        String string;
        FileInputStream is = new FileInputStream(filePath);
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] pass = password == null ? null : password.toCharArray();
            keystore.load(is, pass);
            if (alias == null) {
                alias = keystore.aliases().nextElement();
            }
            if (!keystore.containsAlias(alias)) {
                throw new AliasNotFoundException();
            }
            Certificate certificate = keystore.getCertificate(alias);
            if (certificate == null) {
                throw new WrongPasswordException();
            }
            byte[] encCertInfo = certificate.getEncoded();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(encCertInfo);
            string = Sha256FingerprintUtils.toHexString(digest);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (e.getCause() instanceof UnrecoverableKeyException) {
                    throw new WrongPasswordException();
                }
                throw e;
            }
        }
        is.close();
        return string;
    }

    @NotNull
    public static String toHexString(@NotNull byte[] array) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : array) {
            builder.append(String.format("%02x", b));
            builder.append(":");
        }
        return builder.deleteCharAt(builder.length() - 1).toString().toUpperCase(Locale.US);
    }

    public static class WrongPasswordException
    extends Exception {
        public WrongPasswordException() {
        }

        public WrongPasswordException(String message) {
            super(message);
        }
    }

    public static class AliasNotFoundException
    extends Exception {
        public AliasNotFoundException() {
        }

        public AliasNotFoundException(String message) {
            super(message);
        }
    }
}

