/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.InsertCodeHandler;
import com.google.urlassistant.util.InsertJavaCodeHandler;
import com.google.urlassistant.util.InsertKotlinCodeHandler;
import com.google.urlassistant.util.UnsupportedLanguageCodeHandler;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/google/urlassistant/util/InsertCodeHandlerFactory;", "", "<init>", "()V", "create", "Lcom/google/urlassistant/util/InsertCodeHandler;", "psiClass", "Lcom/intellij/psi/PsiClass;", "url-assistant"})
public final class InsertCodeHandlerFactory {
    @NotNull
    public static final InsertCodeHandlerFactory INSTANCE = new InsertCodeHandlerFactory();

    private InsertCodeHandlerFactory() {
    }

    @JvmStatic
    @NotNull
    public static final InsertCodeHandler create(@NotNull PsiClass psiClass) {
        InsertCodeHandler insertCodeHandler;
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Language language = psiClass.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            insertCodeHandler = new InsertJavaCodeHandler(psiClass);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            KtElement ktElement = ((KtLightClass)psiClass).getKotlinOrigin();
            Intrinsics.checkNotNull((Object)ktElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            insertCodeHandler = new InsertKotlinCodeHandler((KtClass)ktElement);
        } else {
            insertCodeHandler = new UnsupportedLanguageCodeHandler();
        }
        return insertCodeHandler;
    }
}

