/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.datalayer.feature.LinkInfoUtilsKt;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.DataTagCheckName;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.DataTagCheckResult;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.DataTagCheckSummary;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.IntentFilterCheckName;
import com.google.urlassistant.datalayer.model.validation.appchecksummary.intentfiltercheck.IntentFilterCheckResult;
import com.google.urlassistant.ui.models.DuplicateIntentFiltersAccordionInfo;
import com.google.urlassistant.ui.models.Explanation;
import com.google.urlassistant.ui.models.SingleIntentFilterAccordionInfo;
import com.google.urlassistant.util.TextFileSelection;
import com.google.urlassistant.util.UrlAssistantBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/google/urlassistant/ui/models/ManualIntentFilterFixModel;", "", "linksWithProblems", "", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "<init>", "(Ljava/util/List;)V", "singleIntentFilterAccordionInfos", "Lcom/google/urlassistant/ui/models/SingleIntentFilterAccordionInfo;", "getSingleIntentFilterAccordionInfos", "()Ljava/util/List;", "duplicatedLinks", "getDuplicatedLinks", "duplicatedIntentFilterAccordionInfos", "Lcom/google/urlassistant/ui/models/DuplicateIntentFiltersAccordionInfo;", "getDuplicatedIntentFilterAccordionInfos", "getSingleIntentFilterExplanations", "Lcom/google/urlassistant/ui/models/Explanation;", "linkInfo", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nManualIntentFilterFixModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualIntentFilterFixModel.kt\ncom/google/urlassistant/ui/models/ManualIntentFilterFixModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1563#2:160\n1634#2,3:161\n774#2:164\n865#2,2:165\n1491#2:167\n1516#2,3:168\n1519#2,3:178\n774#2:181\n865#2,2:182\n1563#2:184\n1634#2,2:185\n1563#2:187\n1634#2,3:188\n1636#2:191\n1761#2,3:192\n1374#2:195\n1460#2,2:196\n774#2:198\n865#2,2:199\n1617#2,9:201\n1869#2:210\n1870#2:212\n1626#2:213\n1563#2:214\n1634#2,3:215\n1462#2,3:218\n382#3,7:171\n1#4:211\n*S KotlinDebug\n*F\n+ 1 ManualIntentFilterFixModel.kt\ncom/google/urlassistant/ui/models/ManualIntentFilterFixModel\n*L\n58#1:160\n58#1:161,3\n64#1:164\n64#1:165,2\n70#1:167\n70#1:168,3\n70#1:178,3\n70#1:181\n70#1:182,2\n74#1:184\n74#1:185,2\n77#1:187\n77#1:188,3\n74#1:191\n96#1:192,3\n99#1:195\n99#1:196,2\n101#1:198\n101#1:199,2\n101#1:201,9\n101#1:210\n101#1:212\n101#1:213\n113#1:214\n113#1:215,3\n99#1:218,3\n70#1:171,7\n101#1:211\n*E\n"})
public final class ManualIntentFilterFixModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LinkInfo> linksWithProblems;
    @VisibleForTesting
    @NotNull
    public static final String DEEPLINKING_REFERENCE = "https://developer.android.com/training/app-links/deep-linking";
    @VisibleForTesting
    @NotNull
    private static final Explanation DUPLICATE_INTENT_FILTERS_EXPLANATION;
    @VisibleForTesting
    @NotNull
    public static final String INTENT_FILTER_REFERENCE = "https://developer.android.com/guide/topics/manifest/intent-filter-element";

    public ManualIntentFilterFixModel(@NotNull List<LinkInfo> linksWithProblems) {
        Intrinsics.checkNotNullParameter(linksWithProblems, (String)"linksWithProblems");
        this.linksWithProblems = linksWithProblems;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SingleIntentFilterAccordionInfo> getSingleIntentFilterAccordionInfos() {
        void $this$filterTo$iv$iv;
        SingleIntentFilterAccordionInfo it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.linksWithProblems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LinkInfo linkInfo = (LinkInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SingleIntentFilterAccordionInfo(((LinkInfo)((Object)it)).getInterpretedUrlPattern(), new TextFileSelection(((LinkInfo)((Object)it)).getManifestFileLocation(), ((LinkInfo)((Object)it)).getIntentFilterStartOffset(), 0, 4, null), this.getSingleIntentFilterExplanations((LinkInfo)((Object)it))));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleIntentFilterAccordionInfo)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getExplanations()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<LinkInfo>> getDuplicatedLinks() {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.linksWithProblems;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (LinkInfo)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = ((LinkInfo)it).getInterpretedUrlPattern();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DuplicateIntentFiltersAccordionInfo> getDuplicatedIntentFilterAccordionInfos() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getDuplicatedLinks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = (Iterable)it;
            String string = ((LinkInfo)CollectionsKt.first((List)it)).getInterpretedUrlPattern();
            boolean $i$f$map2 = false;
            void var13_13 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void linkInfo;
                LinkInfo linkInfo2 = (LinkInfo)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new TextFileSelection(linkInfo.getManifestFileLocation(), linkInfo.getIntentFilterStartOffset(), 0, 4, null));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            Explanation explanation = null;
            List list2 = (List)destination$iv$iv2;
            String string2 = string;
            collection.add(new DuplicateIntentFiltersAccordionInfo(string2, list2, explanation, n, defaultConstructorMarker));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Explanation> getSingleIntentFilterExplanations(LinkInfo linkInfo) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        boolean bl;
        Iterable $this$any$iv;
        List problems;
        block22: {
            problems = new ArrayList();
            if (!LinkInfoUtilsKt.isNullOrNumeric(linkInfo.getIntentFilterConfig().getOrder())) {
                String string = UrlAssistantBundle.message("manual.fix.order", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                problems.add(new Explanation(string, INTENT_FILTER_REFERENCE));
            }
            if (!LinkInfoUtilsKt.isNullOrNumeric(linkInfo.getIntentFilterConfig().getPriority())) {
                String string = UrlAssistantBundle.message("manual.fix.priority", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                problems.add(new Explanation(string, INTENT_FILTER_REFERENCE));
            }
            $this$any$iv = linkInfo.getAppCheckSummary().getIntentFilterCheckResults();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IntentFilterCheckResult it = (IntentFilterCheckResult)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCheckName() == IntentFilterCheckName.AUTO_VERIFY && !it.isCheckPassed())) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        if (bl) {
            String string = UrlAssistantBundle.message("accordion.content.auto.verify.failed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            problems.add(new Explanation(string, DEEPLINKING_REFERENCE));
        }
        $this$any$iv = linkInfo.getAppCheckSummary().getIntentFilterCheckResults();
        Collection collection = problems;
        boolean $i$f$flatMap = false;
        Iterator iterator2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            IntentFilterCheckResult intentFilterCheckResult = (IntentFilterCheckResult)element$iv$iv;
            boolean bl3 = false;
            if (intentFilterCheckResult.getSubCheckSummary() != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Object it;
                void $this$filterTo$iv$iv;
                DataTagCheckSummary subCheckSummary;
                boolean bl4 = false;
                Iterable $this$filter$iv = subCheckSummary.getDataTagCheckResults();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (DataTagCheckResult)element$iv$iv2;
                    boolean bl5 = false;
                    if (!(!((DataTagCheckResult)it).isCheckPassed())) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv3 = element$iv$iv$iv = it.next();
                    boolean bl6 = false;
                    DataTagCheckResult it2 = (DataTagCheckResult)element$iv$iv3;
                    boolean bl7 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[it2.getCheckName().ordinal()]) {
                        case 1: {
                            string = UrlAssistantBundle.message("manual.fix.scheme", new Object[0]);
                            break;
                        }
                        case 2: {
                            string = UrlAssistantBundle.message("manual.fix.webscheme.nohost", new Object[0]);
                            break;
                        }
                        case 3: {
                            string = UrlAssistantBundle.message("manual.fix.host", new Object[0]);
                            break;
                        }
                        case 4: {
                            string = UrlAssistantBundle.message("manual.fix.path", new Object[0]);
                            break;
                        }
                        case 5: {
                            string = UrlAssistantBundle.message("manual.fix.path.prefix", new Object[0]);
                            break;
                        }
                        case 6: {
                            string = UrlAssistantBundle.message("manual.fix.path.pattern", new Object[0]);
                            break;
                        }
                        case 7: {
                            string = UrlAssistantBundle.message("manual.fix.path.nohost", new Object[0]);
                            break;
                        }
                        case 8: {
                            string = UrlAssistantBundle.message("manual.fix.port", new Object[0]);
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    if (string == null) continue;
                    String it$iv$iv = string;
                    boolean bl8 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl9 = false;
                    collection2.add(new Explanation((String)it, DEEPLINKING_REFERENCE));
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    static {
        String string = UrlAssistantBundle.message("manual.fix.duplicate", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DUPLICATE_INTENT_FILTERS_EXPLANATION = new Explanation(string, DEEPLINKING_REFERENCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/google/urlassistant/ui/models/ManualIntentFilterFixModel$Companion;", "", "<init>", "()V", "DEEPLINKING_REFERENCE", "", "DUPLICATE_INTENT_FILTERS_EXPLANATION", "Lcom/google/urlassistant/ui/models/Explanation;", "getDUPLICATE_INTENT_FILTERS_EXPLANATION", "()Lcom/google/urlassistant/ui/models/Explanation;", "INTENT_FILTER_REFERENCE", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Explanation getDUPLICATE_INTENT_FILTERS_EXPLANATION() {
            return DUPLICATE_INTENT_FILTERS_EXPLANATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataTagCheckName.values().length];
            try {
                nArray[DataTagCheckName.SCHEME_EXISTENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTagCheckName.WEB_SCHEME_HAS_HOST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTagCheckName.HOST_EXISTENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTagCheckName.PROPERLY_FORMED_PATH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTagCheckName.PROPERLY_FORMED_PATH_PREFIX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTagCheckName.PROPERLY_FORMED_PATH_PATTERN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTagCheckName.PATH_HAS_HOST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataTagCheckName.PORT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

