/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.lint.checks.AppLinksValidDetector;
import com.google.urlassistant.lint.LintUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.urlassistant.util.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AnyThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J$\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0017J%\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/google/urlassistant/LaunchAppLinksAssistantIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "startInWriteAction", "", "getFamilyName", "", "getText", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nLaunchAppLinksAssistantIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchAppLinksAssistantIntentionAction.kt\ncom/google/urlassistant/LaunchAppLinksAssistantIntentionAction\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,79:1\n80#2:80\n183#3,2:81\n12637#4,2:83\n*S KotlinDebug\n*F\n+ 1 LaunchAppLinksAssistantIntentionAction.kt\ncom/google/urlassistant/LaunchAppLinksAssistantIntentionAction\n*L\n56#1:80\n56#1:81,2\n61#1:83,2\n*E\n"})
public final class LaunchAppLinksAssistantIntentionAction
implements IntentionAction,
Iconable {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = UrlAssistantBundle.message("intention.action.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        String string = UrlAssistantBundle.message("intention.action.call.to.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @RequiresReadLock
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        boolean bl;
        block10: {
            Object v1;
            XmlTag it;
            Sequence $this$firstOrNull$iv;
            block9: {
                PsiElement elementUnderCaret;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (!(file instanceof XmlFile)) {
                    return false;
                }
                if (editor == null) {
                    return false;
                }
                PsiElement psiElement = ((XmlFile)file).findElementAt(editor.getCaretModel().getOffset());
                if (psiElement == null) {
                    return false;
                }
                PsiElement $this$parentsOfType_u24default$iv = elementUnderCaret = psiElement;
                boolean withSelf$iv = true;
                boolean $i$f$parentsOfType = false;
                $this$firstOrNull$iv = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, XmlTag.class, (boolean)withSelf$iv);
                boolean $i$f$firstOrNull = false;
                for (Object e : $this$firstOrNull$iv) {
                    it = (XmlTag)e;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"intent-filter")) continue;
                    v1 = e;
                    break block9;
                }
                v1 = null;
            }
            XmlTag xmlTag = v1;
            if (xmlTag == null) {
                return false;
            }
            XmlTag intentFilter = xmlTag;
            Object[] objectArray = new String[]{"activity", "activity-alias"};
            $this$firstOrNull$iv = intentFilter.getParent();
            XmlTag xmlTag2 = $this$firstOrNull$iv instanceof XmlTag ? (XmlTag)$this$firstOrNull$iv : null;
            if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)(xmlTag2 != null ? xmlTag2.getName() : null))) {
                return false;
            }
            if (AppLinksValidDetector.Companion.hasAutoVerifyButInvalidAppLink((AppLinksValidDetector.Companion.TagWrapper)new LintUtils.XmlTagWrapper(intentFilter))) {
                return false;
            }
            if (intentFilter.findFirstSubTag("data") != null) {
                return true;
            }
            XmlTag[] xmlTagArray = intentFilter.findSubTags("category");
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
            Object[] $this$any$iv = xmlTagArray;
            boolean $i$f$any = false;
            for (Object object : $this$any$iv) {
                it = (XmlTag)object;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), (Object)"android.intent.category.BROWSABLE")) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        return bl;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(UrlAssistantBundle.message("url.assistant.toolwindow.title", new Object[0]));
        if (toolWindow == null) {
            return;
        }
        ToolWindow window = toolWindow;
        window.setShowStripeButton(true);
        window.show();
        UsageTrackerUtils.INSTANCE.log(project, (Function1<? super AppLinksAssistantEvent.Builder, AppLinksAssistantEvent.Builder>)((Function1)LaunchAppLinksAssistantIntentionAction::invoke$lambda$2));
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = StudioIcons.Shell.ToolWindows.APP_LINKS_ASSISTANT;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"APP_LINKS_ASSISTANT");
        return icon;
    }

    private static final AppLinksAssistantEvent.Builder invoke$lambda$2(AppLinksAssistantEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AppLinksAssistantEvent.Builder builder = it.setEventSource(AppLinksAssistantEvent.EventSource.LAUNCH_APP_LINKS_ASSISTANT).setEventState(AppLinksAssistantEvent.EventState.COMPLETED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setEventState(...)");
        return builder;
    }
}

