/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.SdkConstants;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.repository.Revision;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.utils.ILogger;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Map;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildCommonUtils {
    @NonNls
    public static final String PROGUARD_CFG_FILE_NAME = "proguard-project.txt";
    @NonNls
    public static final String CLASSES_JAR_FILE_NAME = "classes.jar";
    @NonNls
    public static final String PNG_EXTENSION = "png";
    @NonNls
    public static final String RELEASE_BUILD_OPTION = "RELEASE_BUILD_KEY";
    @NonNls
    public static final String PROGUARD_CFG_PATHS_OPTION = "ANDROID_PROGUARD_CFG_PATHS";
    private static final String[] TEST_CONFIGURATION_TYPE_IDS = new String[]{"AndroidJUnit", "JUnit", "TestNG", "ScalaTestRunConfiguration", "SpecsRunConfiguration", "Specs2RunConfiguration"};
    @NonNls
    public static final String ANNOTATIONS_JAR_RELATIVE_PATH = "/tools/support/annotations.jar";
    @NonNls
    public static final String ANDROID_TEST_RUN_CONFIGURATION_TYPE = "AndroidTestRunConfigurationType";

    private AndroidBuildCommonUtils() {
    }

    public static boolean isTestConfiguration(@NotNull String typeId) {
        return ArrayUtil.find((Object[])TEST_CONFIGURATION_TYPE_IDS, (Object)typeId) >= 0;
    }

    public static String platformToolPath(@NotNull String toolFileName) {
        return SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + toolFileName;
    }

    @Nullable
    public static Revision parsePackageRevision(@NotNull String sdkDirOsPath, @NotNull String packageDirName) {
        File propFile = new File(sdkDirOsPath + File.separatorChar + packageDirName + File.separatorChar + "source.properties");
        if (propFile.exists() && propFile.isFile()) {
            Map map = ProjectProperties.parsePropertyFile((IAbstractFile)new FileWrapper(propFile), (ILogger)new MessageBuildingSdkLog());
            if (map == null) {
                return null;
            }
            String revision = (String)map.get("Pkg.Revision");
            if (revision != null) {
                return Revision.parseRevision((String)revision);
            }
        }
        return null;
    }
}

