/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup;

import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.dex.DexFileDisassembler;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectApkFileSetup {
    @NotNull
    private final DexFileDisassembler myDexFileDisassembler;

    public ProjectApkFileSetup() {
        this(new DexFileDisassembler());
    }

    @VisibleForTesting
    ProjectApkFileSetup(@NotNull DexFileDisassembler dexFileDisassembler) {
        this.myDexFileDisassembler = dexFileDisassembler;
    }

    @NotNull
    public Path setUpApk(@NotNull Path apkFilePath, @NotNull Path destination, @Nullable ProgressIndicator progressIndicator) throws IOException, ExecutionException, InterruptedException {
        Path newApkFile = destination.resolve(apkFilePath.getFileName());
        FileUtils.copyFile((File)apkFilePath.toFile(), (File)newApkFile.toFile());
        Path smaliRootFolderPath = Files.createDirectory(destination.resolve("smali"), new FileAttribute[0]);
        if (progressIndicator != null) {
            progressIndicator.setText("Extracting contents");
        }
        Pattern dexFilePattern = Pattern.compile("classes\\d*\\.dex");
        ArrayList dexFileEntries = new ArrayList();
        Splitter pathSplitter = Splitter.on((char)'/');
        new Decompressor.Zip(newApkFile).entryFilter(entry -> {
            if (entry.type == Decompressor.Entry.Type.DIR) {
                return false;
            }
            String name = entry.name;
            List segments = pathSplitter.omitEmptyStrings().splitToList((CharSequence)name);
            int segmentCount = segments.size();
            if (segmentCount == 0) {
                return false;
            }
            String first = (String)segments.get(0);
            if (segmentCount > 1 && LibraryFolder.getName().equals(first) && name.endsWith(".so")) {
                return true;
            }
            if (segmentCount == 1 && dexFilePattern.matcher(first).matches()) {
                dexFileEntries.add(entry);
                return true;
            }
            return false;
        }).overwrite(true).postProcessor((entry, path) -> {
            if (dexFileEntries.contains(entry)) {
                try {
                    Files.move(path, smaliRootFolderPath.resolve(entry.name), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).extract(destination);
        Path outputFolderPath = Files.createDirectory(smaliRootFolderPath.resolve("out"), new FileAttribute[0]);
        for (Decompressor.Entry entry2 : dexFileEntries) {
            String dexFileName = entry2.name;
            Path dexFilePath = smaliRootFolderPath.resolve(dexFileName);
            File expectedDexFilePath = dexFilePath.toFile();
            if (!expectedDexFilePath.isFile()) {
                throw new FileNotFoundException("Unable to find file '" + expectedDexFilePath.getPath() + "'");
            }
            if (progressIndicator != null) {
                progressIndicator.setText("Disassembling " + dexFileName);
            }
            this.myDexFileDisassembler.disassemble(expectedDexFilePath, outputFolderPath.toFile());
        }
        return newApkFile;
    }
}

