/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.connection;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.PathMapper;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.internal.consumer.CancellationTokenInternal;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.connection.GradleConnectorService;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.execution.target.TargetGradleConnector;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServicesKt;
import org.jetbrains.plugins.gradle.service.project.DistributionFactoryExt;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00040123B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002JW\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010+\u001a\u0004\u0018\u00010,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H'0.H\u0016\u00a2\u0006\u0002\u0010/R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f \u0011*\u0017\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\u0010\u00a2\u0006\u0002\b\u000e0\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0012\u001a2\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f \u0011*\u0017\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\u0010\u00a2\u0006\u0002\b\u000e0\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl;", "Lorg/jetbrains/plugins/gradle/connection/GradleConnectorService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "connectorsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$GradleProjectConnection;", "cancellationTokens", "", "Lorg/gradle/initialization/BuildCancellationToken;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "knownGradleUserHomes", "shutdownStarted", "Lcom/intellij/util/ThreeState;", "getKnownGradleUserHomes", "dispose", "", "stopIdleDaemonsOfOldVersions", "disconnectGradleConnections", "gracefulStopDaemons", "getConnection", "Lorg/gradle/tooling/ProjectConnection;", "connectorParams", "Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$ConnectorParams;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "canBeReused", "", "projectConnection", "withGradleConnection", "R", "projectPath", "executionSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "cancellationToken", "Lorg/gradle/tooling/CancellationToken;", "function", "Ljava/util/function/Function;", "(Ljava/lang/String;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;Lorg/gradle/tooling/CancellationToken;Ljava/util/function/Function;)Ljava/lang/Object;", "GradleProjectConnection", "NonClosableConnection", "ConnectorParams", "Companion", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleConnectorServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleConnectorServiceImpl.kt\norg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,319:1\n774#2:320\n865#2,2:321\n1869#2,2:323\n1869#2,2:325\n27#3:327\n87#3,2:328\n28#3,2:330\n30#3:333\n98#3:334\n90#3,6:335\n1#4:332\n14#5:341\n*S KotlinDebug\n*F\n+ 1 GradleConnectorServiceImpl.kt\norg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl\n*L\n94#1:320\n94#1:321,2\n113#1:323,2\n129#1:325,2\n186#1:327\n186#1:328,2\n186#1:330,2\n186#1:333\n186#1:334\n186#1:335,6\n245#1:341\n*E\n"})
public final class GradleConnectorServiceImpl
implements GradleConnectorService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, GradleProjectConnection> connectorsMap;
    @NotNull
    private final Set<BuildCancellationToken> cancellationTokens;
    @NotNull
    private final Set<String> knownGradleUserHomes;
    @NotNull
    private volatile ThreeState shutdownStarted;
    @NotNull
    private static final Logger LOG;
    private static final boolean DISABLE_STOP_OLD_IDLE_DAEMONS;
    private static final boolean USE_PRODUCTION_TTL_FOR_TESTS;

    public GradleConnectorServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.connectorsMap = new ConcurrentHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.cancellationTokens = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.knownGradleUserHomes = set2;
        this.shutdownStarted = ThreeState.UNSURE;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void start() {
                shutdownStarted = ThreeState.YES;
                super.start();
            }
        });
        ((Collection)this.knownGradleUserHomes).add("");
        String string = GradleSettings.getInstance(project).getServiceDirectoryPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            ((Collection)this.knownGradleUserHomes).add(it);
        }
        GradleSettingsListener listener2 = new GradleSettingsListener(this){
            final /* synthetic */ GradleConnectorServiceImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onServiceDirectoryPathChange(String oldPath, String newPath) {
                block0: {
                    String string = newPath;
                    if (string == null) break block0;
                    String string2 = string;
                    GradleConnectorServiceImpl gradleConnectorServiceImpl = this.this$0;
                    String it = string2;
                    boolean bl = false;
                    GradleConnectorServiceImpl.access$getKnownGradleUserHomes$p(gradleConnectorServiceImpl).add(it);
                }
            }
        };
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic<GradleSettingsListener> topic = GradleSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener2);
    }

    @Override
    @NotNull
    public Set<String> getKnownGradleUserHomes() {
        return this.knownGradleUserHomes;
    }

    public void dispose() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.disconnectGradleConnections();
        this.stopIdleDaemonsOfOldVersions();
    }

    /*
     * WARNING - void declaration
     */
    private final void stopIdleDaemonsOfOldVersions() {
        if (DISABLE_STOP_OLD_IDLE_DAEMONS) {
            return;
        }
        try {
            if (ProjectUtil.getOpenProjects().length == 0) {
                void $this$filterTo$iv$iv;
                GradleVersion gradleVersion_6_5 = GradleVersion.version((String)"6.5");
                Iterable $this$filter$iv = GradleDaemonServicesKt.getDaemonsStatus(this.knownGradleUserHomes);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    DaemonState it = (DaemonState)element$iv$iv;
                    boolean bl = false;
                    String string = it.getStatus();
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string2 = string.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (!(Intrinsics.areEqual((Object)string2, (Object)"idle") && GradleVersion.version((String)it.getVersion()).compareTo(gradleVersion_6_5) < 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List idleDaemons = (List)destination$iv$iv;
                if (!((Collection)idleDaemons).isEmpty()) {
                    GradleDaemonServicesKt.stopDaemons(this.knownGradleUserHomes, idleDaemons);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to stop Gradle daemons during project close", (Throwable)e);
        }
    }

    private final void disconnectGradleConnections() {
        if (this.shutdownStarted != ThreeState.YES) {
            try {
                Collection<GradleProjectConnection> collection = this.connectorsMap.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GradleProjectConnection p0 = (GradleProjectConnection)element$iv;
                    boolean bl = false;
                    p0.disconnect();
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to disconnect Gradle connections during project close", t);
                this.gracefulStopDaemons();
            }
        } else {
            this.gracefulStopDaemons();
        }
        this.cancellationTokens.clear();
        this.connectorsMap.clear();
    }

    private final void gracefulStopDaemons() {
        Iterable $this$forEach$iv = this.cancellationTokens;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildCancellationToken it = (BuildCancellationToken)element$iv;
            boolean bl = false;
            if (it.isCancellationRequested()) continue;
            try {
                it.cancel();
            }
            catch (Throwable t) {
                LOG.warn("Failed to cancel build", t);
            }
        }
        GradleDaemonServicesKt.gracefulStopDaemons(this.knownGradleUserHomes);
    }

    private final ProjectConnection getConnection(ConnectorParams connectorParams, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2) {
        GradleProjectConnection gradleProjectConnection = this.connectorsMap.compute(connectorParams.getProjectPath(), (arg_0, arg_1) -> GradleConnectorServiceImpl.getConnection$lambda$6((arg_0, arg_1) -> GradleConnectorServiceImpl.getConnection$lambda$5(this, connectorParams, taskId, listener2, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)gradleProjectConnection);
        return gradleProjectConnection.getConnection();
    }

    private final boolean canBeReused(GradleProjectConnection projectConnection, ConnectorParams connectorParams) {
        if (connectorParams.getGradleHome() == null) {
            return false;
        }
        if (projectConnection.getConnector() instanceof TargetGradleConnector) {
            return false;
        }
        return Intrinsics.areEqual((Object)connectorParams, (Object)projectConnection.getParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public <R> R withGradleConnection(@NotNull String projectPath, @Nullable ExternalSystemTaskId taskId, @Nullable GradleExecutionSettings executionSettings, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull Function<ProjectConnection, R> function) {
        Closeable closeable;
        void $this$use$iv;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        SpanBuilder spanBuilder = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GradleConnection");
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder spanBuilder2 = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Closeable closeable2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Closeable closeable3;
                BuildCancellationToken buildCancellationToken;
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span it = span$iv;
                boolean bl3 = false;
                CancellationTokenInternal cancellationTokenInternal = cancellationToken instanceof CancellationTokenInternal ? (CancellationTokenInternal)cancellationToken : null;
                BuildCancellationToken buildCancellationToken2 = buildCancellationToken = cancellationTokenInternal != null ? cancellationTokenInternal.getToken() : null;
                if (buildCancellationToken2 != null) {
                    BuildCancellationToken it2 = buildCancellationToken2;
                    boolean bl4 = false;
                    this.cancellationTokens.add(it2);
                }
                try {
                    Object object;
                    ConnectorParams connectionParams = new ConnectorParams(projectPath, executionSettings);
                    ProjectConnection connection = this.getConnection(connectionParams, taskId, listener2);
                    if (connection instanceof NonClosableConnection) {
                        object = function.apply(connection);
                    } else {
                        closeable3 = (Closeable)connection;
                        Throwable throwable2 = null;
                        try {
                            Object p0 = (ProjectConnection)closeable3;
                            boolean bl5 = false;
                            p0 = function.apply((ProjectConnection)p0);
                            object = p0;
                        }
                        catch (Throwable bl5) {
                            throwable2 = bl5;
                            throw bl5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable2);
                        }
                    }
                    closeable3 = object;
                }
                finally {
                    BuildCancellationToken buildCancellationToken3 = buildCancellationToken;
                    if (buildCancellationToken3 != null) {
                        BuildCancellationToken it3 = buildCancellationToken3;
                        boolean bl6 = false;
                        this.cancellationTokens.remove(it3);
                    }
                }
                closeable2 = closeable3;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            closeable = closeable2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        return (R)closeable;
    }

    private static final void getConnection$lambda$5$lambda$3(NonClosableConnection $unwrappedConnection) {
        $unwrappedConnection.getDelegate().close();
    }

    private static final GradleProjectConnection getConnection$lambda$5(GradleConnectorServiceImpl this$0, ConnectorParams $connectorParams, ExternalSystemTaskId $taskId, ExternalSystemTaskNotificationListener $listener, String string, GradleProjectConnection conn) {
        GradleConnector newConnector;
        ProjectConnection newConnection;
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        if (conn != null) {
            if (this$0.canBeReused(conn, $connectorParams)) {
                return conn;
            }
            ProjectConnection projectConnection = conn.getConnection();
            Intrinsics.checkNotNull((Object)projectConnection, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.connection.GradleConnectorServiceImpl.NonClosableConnection");
            NonClosableConnection unwrappedConnection = (NonClosableConnection)projectConnection;
            ApplicationManager.getApplication().executeOnPooledThread(() -> GradleConnectorServiceImpl.getConnection$lambda$5$lambda$3(unwrappedConnection));
        }
        if (!((newConnection = (newConnector = Companion.createConnector$intellij_gradle($connectorParams, $taskId, $listener)).connect()) != null)) {
            boolean bl = false;
            String string2 = "Can't create connection to the target project via gradle tooling api. Project path: '" + $connectorParams.getProjectPath() + "'";
            throw new IllegalStateException(string2.toString());
        }
        NonClosableConnection wrappedConnection = new NonClosableConnection(newConnection);
        return new GradleProjectConnection($connectorParams, newConnector, wrappedConnection);
    }

    private static final GradleProjectConnection getConnection$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return (GradleProjectConnection)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Set access$getKnownGradleUserHomes$p(GradleConnectorServiceImpl $this) {
        return $this.knownGradleUserHomes;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleConnectorServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DISABLE_STOP_OLD_IDLE_DAEMONS = Boolean.getBoolean("idea.gradle.disableStopIdleDaemonsOnProjectClose");
        USE_PRODUCTION_TTL_FOR_TESTS = Boolean.getBoolean("gradle.connector.useExternalSystemRemoteProcessIdleTtlForTests");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0001\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DISABLE_STOP_OLD_IDLE_DAEMONS", "", "USE_PRODUCTION_TTL_FOR_TESTS", "createConnector", "Lorg/gradle/tooling/GradleConnector;", "connectorParams", "Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$ConnectorParams;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "createConnector$intellij_gradle", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        @NotNull
        public final GradleConnector createConnector$intellij_gradle(@NotNull ConnectorParams connectorParams, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2) {
            int ttl;
            Intrinsics.checkNotNullParameter((Object)connectorParams, (String)"connectorParams");
            GradleConnector connector = null;
            if (connectorParams.getEnvironmentConfigurationProvider() != null) {
                connector = new TargetGradleConnector(connectorParams.getEnvironmentConfigurationProvider(), taskId, listener2, connectorParams.getTaskState());
            } else {
                GradleConnector gradleConnector = GradleConnector.newConnector();
                Intrinsics.checkNotNullExpressionValue((Object)gradleConnector, (String)"newConnector(...)");
                connector = gradleConnector;
            }
            File projectDir = new File(connectorParams.getProjectPath());
            String localPathToGradleUserHome = connectorParams.getServiceDirectory();
            if (connectorParams.getDistributionType() == DistributionType.LOCAL) {
                String localPathToGradleHome = connectorParams.getGradleHome();
                if (localPathToGradleHome != null) {
                    if (connector instanceof TargetGradleConnector) {
                        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = connectorParams.getEnvironmentConfigurationProvider();
                        PathMapper targetPathMapper = targetEnvironmentConfigurationProvider != null ? targetEnvironmentConfigurationProvider.getPathMapper() : null;
                        String targetGradleHomePath = GradleTargetUtil.maybeConvertToRemote(targetPathMapper, localPathToGradleHome);
                        TargetGradleConnector targetGradleConnector = (TargetGradleConnector)connector;
                        TargetValue targetValue = TargetValue.create((Object)localPathToGradleHome, (Promise)Promises.resolvedPromise((Object)targetGradleHomePath));
                        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
                        v4 = targetGradleConnector.useInstallation((TargetValue<String>)targetValue);
                    } else {
                        v4 = connector.useInstallation(new File(localPathToGradleHome));
                    }
                }
            } else if (connectorParams.getDistributionType() == DistributionType.WRAPPED && connectorParams.getWrapperPropertyFile() != null) {
                DistributionFactoryExt.setWrappedDistribution(connector, connectorParams.getWrapperPropertyFile());
            }
            if (localPathToGradleUserHome != null) {
                if (connector instanceof TargetGradleConnector) {
                    TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = connectorParams.getEnvironmentConfigurationProvider();
                    PathMapper targetPathMapper = targetEnvironmentConfigurationProvider != null ? targetEnvironmentConfigurationProvider.getPathMapper() : null;
                    String targetGradleUserHomePath = GradleTargetUtil.maybeConvertToRemote(targetPathMapper, localPathToGradleUserHome);
                    TargetGradleConnector targetGradleConnector = (TargetGradleConnector)connector;
                    TargetValue targetValue = TargetValue.create((Object)localPathToGradleUserHome, (Promise)Promises.resolvedPromise((Object)targetGradleUserHomePath));
                    Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"create(...)");
                    v8 = targetGradleConnector.useGradleUserHomeDir((TargetValue<String>)targetValue);
                } else {
                    v8 = connector.useGradleUserHomeDir(new File(localPathToGradleUserHome));
                }
            }
            if (Intrinsics.areEqual((Object)connectorParams.getVerboseProcessing(), (Object)true) && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).setVerboseLogging(true);
            }
            Application app = ApplicationManager.getApplication();
            if (!USE_PRODUCTION_TTL_FOR_TESTS && app != null && app.isUnitTestMode()) {
                v9 = 5000;
            } else {
                Integer n = connectorParams.getTtlMs();
                v9 = ttl = n != null ? n : -1;
            }
            if (ttl > 0 && connector instanceof DefaultGradleConnector) {
                ((DefaultGradleConnector)connector).daemonMaxIdleTime(ttl, TimeUnit.MILLISECONDS);
            }
            connector.forProjectDirectory(projectDir);
            return connector;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b$\b\u0081\b\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0012\u0010\u0016J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010/\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010 J\u0010\u00100\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010#J\u000b\u00101\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u0084\u0001\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\u00020\u000b2\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u00020\rH\u00d6\u0001J\t\u00108\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$ConnectorParams;", "", "projectPath", "", "serviceDirectory", "distributionType", "Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "gradleHome", "javaHome", "wrapperPropertyFile", "verboseProcessing", "", "ttlMs", "", "environmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "taskState", "Lcom/intellij/task/RunConfigurationTaskState;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/DistributionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;Lcom/intellij/task/RunConfigurationTaskState;)V", "executionSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "(Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;)V", "getProjectPath", "()Ljava/lang/String;", "getServiceDirectory", "getDistributionType", "()Lorg/jetbrains/plugins/gradle/settings/DistributionType;", "getGradleHome", "getJavaHome", "getWrapperPropertyFile", "getVerboseProcessing", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getTtlMs", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getEnvironmentConfigurationProvider", "()Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "getTaskState", "()Lcom/intellij/task/RunConfigurationTaskState;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/settings/DistributionType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;Lcom/intellij/task/RunConfigurationTaskState;)Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$ConnectorParams;", "equals", "other", "hashCode", "toString", "intellij.gradle"})
    @ApiStatus.Internal
    public static final class ConnectorParams {
        @NotNull
        private final String projectPath;
        @Nullable
        private final String serviceDirectory;
        @Nullable
        private final DistributionType distributionType;
        @Nullable
        private final String gradleHome;
        @Nullable
        private final String javaHome;
        @Nullable
        private final String wrapperPropertyFile;
        @Nullable
        private final Boolean verboseProcessing;
        @Nullable
        private final Integer ttlMs;
        @Nullable
        private final TargetEnvironmentConfigurationProvider environmentConfigurationProvider;
        @Nullable
        private final RunConfigurationTaskState taskState;

        public ConnectorParams(@NotNull String projectPath, @Nullable String serviceDirectory, @Nullable DistributionType distributionType, @Nullable String gradleHome, @Nullable String javaHome, @Nullable String wrapperPropertyFile, @Nullable Boolean verboseProcessing, @Nullable Integer ttlMs, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider, @Nullable RunConfigurationTaskState taskState) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.projectPath = projectPath;
            this.serviceDirectory = serviceDirectory;
            this.distributionType = distributionType;
            this.gradleHome = gradleHome;
            this.javaHome = javaHome;
            this.wrapperPropertyFile = wrapperPropertyFile;
            this.verboseProcessing = verboseProcessing;
            this.ttlMs = ttlMs;
            this.environmentConfigurationProvider = environmentConfigurationProvider;
            this.taskState = taskState;
        }

        @NotNull
        public final String getProjectPath() {
            return this.projectPath;
        }

        @Nullable
        public final String getServiceDirectory() {
            return this.serviceDirectory;
        }

        @Nullable
        public final DistributionType getDistributionType() {
            return this.distributionType;
        }

        @Nullable
        public final String getGradleHome() {
            return this.gradleHome;
        }

        @Nullable
        public final String getJavaHome() {
            return this.javaHome;
        }

        @Nullable
        public final String getWrapperPropertyFile() {
            return this.wrapperPropertyFile;
        }

        @Nullable
        public final Boolean getVerboseProcessing() {
            return this.verboseProcessing;
        }

        @Nullable
        public final Integer getTtlMs() {
            return this.ttlMs;
        }

        @Nullable
        public final TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider() {
            return this.environmentConfigurationProvider;
        }

        @Nullable
        public final RunConfigurationTaskState getTaskState() {
            return this.taskState;
        }

        public ConnectorParams(@NotNull String projectPath, @Nullable GradleExecutionSettings executionSettings) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            GradleExecutionSettings gradleExecutionSettings = executionSettings;
            GradleExecutionSettings gradleExecutionSettings2 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings3 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings4 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings5 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings6 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings7 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings8 = executionSettings;
            GradleExecutionSettings gradleExecutionSettings9 = executionSettings;
            this(projectPath, gradleExecutionSettings != null ? gradleExecutionSettings.getServiceDirectory() : null, gradleExecutionSettings2 != null ? gradleExecutionSettings2.getDistributionType() : null, gradleExecutionSettings3 != null ? gradleExecutionSettings3.getGradleHome() : null, gradleExecutionSettings4 != null ? gradleExecutionSettings4.getJavaHome() : null, gradleExecutionSettings5 != null ? gradleExecutionSettings5.getWrapperPropertyFile() : null, gradleExecutionSettings6 != null ? Boolean.valueOf(gradleExecutionSettings6.isVerboseProcessing()) : null, gradleExecutionSettings7 != null ? Integer.valueOf((int)gradleExecutionSettings7.getRemoteProcessIdleTtlInMs()) : null, gradleExecutionSettings8 != null ? ExternalSystemExecutionAware.Companion.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)gradleExecutionSettings8) : null, gradleExecutionSettings9 != null ? (RunConfigurationTaskState)gradleExecutionSettings9.getUserData(RunConfigurationTaskState.Companion.getKEY()) : null);
        }

        @NotNull
        public final String component1() {
            return this.projectPath;
        }

        @Nullable
        public final String component2() {
            return this.serviceDirectory;
        }

        @Nullable
        public final DistributionType component3() {
            return this.distributionType;
        }

        @Nullable
        public final String component4() {
            return this.gradleHome;
        }

        @Nullable
        public final String component5() {
            return this.javaHome;
        }

        @Nullable
        public final String component6() {
            return this.wrapperPropertyFile;
        }

        @Nullable
        public final Boolean component7() {
            return this.verboseProcessing;
        }

        @Nullable
        public final Integer component8() {
            return this.ttlMs;
        }

        @Nullable
        public final TargetEnvironmentConfigurationProvider component9() {
            return this.environmentConfigurationProvider;
        }

        @Nullable
        public final RunConfigurationTaskState component10() {
            return this.taskState;
        }

        @NotNull
        public final ConnectorParams copy(@NotNull String projectPath, @Nullable String serviceDirectory, @Nullable DistributionType distributionType, @Nullable String gradleHome, @Nullable String javaHome, @Nullable String wrapperPropertyFile, @Nullable Boolean verboseProcessing, @Nullable Integer ttlMs, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider, @Nullable RunConfigurationTaskState taskState) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return new ConnectorParams(projectPath, serviceDirectory, distributionType, gradleHome, javaHome, wrapperPropertyFile, verboseProcessing, ttlMs, environmentConfigurationProvider, taskState);
        }

        public static /* synthetic */ ConnectorParams copy$default(ConnectorParams connectorParams, String string, String string2, DistributionType distributionType, String string3, String string4, String string5, Boolean bl, Integer n, TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider, RunConfigurationTaskState runConfigurationTaskState, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = connectorParams.projectPath;
            }
            if ((n2 & 2) != 0) {
                string2 = connectorParams.serviceDirectory;
            }
            if ((n2 & 4) != 0) {
                distributionType = connectorParams.distributionType;
            }
            if ((n2 & 8) != 0) {
                string3 = connectorParams.gradleHome;
            }
            if ((n2 & 0x10) != 0) {
                string4 = connectorParams.javaHome;
            }
            if ((n2 & 0x20) != 0) {
                string5 = connectorParams.wrapperPropertyFile;
            }
            if ((n2 & 0x40) != 0) {
                bl = connectorParams.verboseProcessing;
            }
            if ((n2 & 0x80) != 0) {
                n = connectorParams.ttlMs;
            }
            if ((n2 & 0x100) != 0) {
                targetEnvironmentConfigurationProvider = connectorParams.environmentConfigurationProvider;
            }
            if ((n2 & 0x200) != 0) {
                runConfigurationTaskState = connectorParams.taskState;
            }
            return connectorParams.copy(string, string2, distributionType, string3, string4, string5, bl, n, targetEnvironmentConfigurationProvider, runConfigurationTaskState);
        }

        @NotNull
        public String toString() {
            return "ConnectorParams(projectPath=" + this.projectPath + ", serviceDirectory=" + this.serviceDirectory + ", distributionType=" + this.distributionType + ", gradleHome=" + this.gradleHome + ", javaHome=" + this.javaHome + ", wrapperPropertyFile=" + this.wrapperPropertyFile + ", verboseProcessing=" + this.verboseProcessing + ", ttlMs=" + this.ttlMs + ", environmentConfigurationProvider=" + this.environmentConfigurationProvider + ", taskState=" + this.taskState + ")";
        }

        public int hashCode() {
            int result = this.projectPath.hashCode();
            result = result * 31 + (this.serviceDirectory == null ? 0 : this.serviceDirectory.hashCode());
            result = result * 31 + (this.distributionType == null ? 0 : this.distributionType.hashCode());
            result = result * 31 + (this.gradleHome == null ? 0 : this.gradleHome.hashCode());
            result = result * 31 + (this.javaHome == null ? 0 : this.javaHome.hashCode());
            result = result * 31 + (this.wrapperPropertyFile == null ? 0 : this.wrapperPropertyFile.hashCode());
            result = result * 31 + (this.verboseProcessing == null ? 0 : ((Object)this.verboseProcessing).hashCode());
            result = result * 31 + (this.ttlMs == null ? 0 : ((Object)this.ttlMs).hashCode());
            result = result * 31 + (this.environmentConfigurationProvider == null ? 0 : this.environmentConfigurationProvider.hashCode());
            result = result * 31 + (this.taskState == null ? 0 : this.taskState.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectorParams)) {
                return false;
            }
            ConnectorParams connectorParams = (ConnectorParams)other;
            if (!Intrinsics.areEqual((Object)this.projectPath, (Object)connectorParams.projectPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.serviceDirectory, (Object)connectorParams.serviceDirectory)) {
                return false;
            }
            if (this.distributionType != connectorParams.distributionType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gradleHome, (Object)connectorParams.gradleHome)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.javaHome, (Object)connectorParams.javaHome)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.wrapperPropertyFile, (Object)connectorParams.wrapperPropertyFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.verboseProcessing, (Object)connectorParams.verboseProcessing)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ttlMs, (Object)connectorParams.ttlMs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.environmentConfigurationProvider, (Object)connectorParams.environmentConfigurationProvider)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.taskState, (Object)connectorParams.taskState);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$GradleProjectConnection;", "", "params", "Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$ConnectorParams;", "connector", "Lorg/gradle/tooling/GradleConnector;", "connection", "Lorg/gradle/tooling/ProjectConnection;", "<init>", "(Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$ConnectorParams;Lorg/gradle/tooling/GradleConnector;Lorg/gradle/tooling/ProjectConnection;)V", "getParams", "()Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$ConnectorParams;", "getConnector", "()Lorg/gradle/tooling/GradleConnector;", "getConnection", "()Lorg/gradle/tooling/ProjectConnection;", "disconnect", "", "intellij.gradle"})
    private static final class GradleProjectConnection {
        @NotNull
        private final ConnectorParams params;
        @NotNull
        private final GradleConnector connector;
        @NotNull
        private final ProjectConnection connection;

        public GradleProjectConnection(@NotNull ConnectorParams params, @NotNull GradleConnector connector, @NotNull ProjectConnection connection) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            this.params = params;
            this.connector = connector;
            this.connection = connection;
        }

        @NotNull
        public final ConnectorParams getParams() {
            return this.params;
        }

        @NotNull
        public final GradleConnector getConnector() {
            return this.connector;
        }

        @NotNull
        public final ProjectConnection getConnection() {
            return this.connection;
        }

        public final void disconnect() {
            this.connector.disconnect();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016Jk\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b\u0018\u00010\n0\n\"\u0010\b\u0000\u0010\u000b*\n \f*\u0004\u0018\u00010\r0\r2*\u0010\u000e\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b\u0018\u00010\u000f0\u000fH\u0096\u0001J\u0011\u0010\t\u001a\n \f*\u0004\u0018\u00010\u00100\u0010H\u0096\u0001JT\u0010\u0011\u001a\n \f*\u0004\u0018\u0001H\u000bH\u000b\"\u0010\b\u0000\u0010\u000b*\n \f*\u0004\u0018\u00010\r0\r2*\u0010\u0012\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b\u0018\u00010\u00130\u0013H\u0096\u0001\u00a2\u0006\u0002\u0010\u0014Jw\u0010\u0011\u001a\u00020\b\"\u0010\b\u0000\u0010\u000b*\n \f*\u0004\u0018\u00010\r0\r2*\u0010\u0012\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b\u0018\u00010\u00130\u00132.\u0010\u0015\u001a*\u0012\u000e\b\u0000\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b \f*\u0014\u0012\u000e\b\u0000\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b\u0018\u00010\u00160\u0016H\u0096\u0001Jk\u0010\u0017\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b\u0018\u00010\u00180\u0018\"\u0010\b\u0000\u0010\u000b*\n \f*\u0004\u0018\u00010\r0\r2*\u0010\u0012\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u0001H\u000bH\u000b\u0018\u00010\u00130\u0013H\u0096\u0001J\u0011\u0010\u0019\u001a\n \f*\u0004\u0018\u00010\u001a0\u001aH\u0096\u0001J\u0011\u0010\u001b\u001a\n \f*\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J5\u0010\u001d\u001a\u00020\b2*\u0010\u001e\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010 0  \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010 0 \u0018\u00010!0\u001fH\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/gradle/connection/GradleConnectorServiceImpl$NonClosableConnection;", "Lorg/gradle/tooling/ProjectConnection;", "delegate", "<init>", "(Lorg/gradle/tooling/ProjectConnection;)V", "getDelegate", "()Lorg/gradle/tooling/ProjectConnection;", "close", "", "action", "Lorg/gradle/tooling/BuildActionExecuter;", "T", "kotlin.jvm.PlatformType", "", "buildAction", "Lorg/gradle/tooling/BuildAction;", "Lorg/gradle/tooling/BuildActionExecuter$Builder;", "getModel", "modelType", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "handler", "Lorg/gradle/tooling/ResultHandler;", "model", "Lorg/gradle/tooling/ModelBuilder;", "newBuild", "Lorg/gradle/tooling/BuildLauncher;", "newTestLauncher", "Lorg/gradle/tooling/TestLauncher;", "notifyDaemonsAboutChangedPaths", "changedPaths", "", "Ljava/nio/file/Path;", "", "intellij.gradle"})
    private static final class NonClosableConnection
    implements ProjectConnection {
        @NotNull
        private final ProjectConnection delegate;

        public NonClosableConnection(@NotNull ProjectConnection delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public final ProjectConnection getDelegate() {
            return this.delegate;
        }

        public void close() {
            throw new IllegalStateException("This connection should not be closed explicitly.");
        }

        public <T> T getModel(Class<T> modelType) {
            return (T)this.delegate.getModel(modelType);
        }

        public <T> void getModel(Class<T> modelType, ResultHandler<? super T> handler) {
            this.delegate.getModel(modelType, handler);
        }

        public BuildLauncher newBuild() {
            return this.delegate.newBuild();
        }

        public TestLauncher newTestLauncher() {
            return this.delegate.newTestLauncher();
        }

        public <T> ModelBuilder<T> model(Class<T> modelType) {
            return this.delegate.model(modelType);
        }

        public <T> BuildActionExecuter<T> action(BuildAction<T> buildAction) {
            return this.delegate.action(buildAction);
        }

        public BuildActionExecuter.Builder action() {
            return this.delegate.action();
        }

        public void notifyDaemonsAboutChangedPaths(List<Path> changedPaths) {
            this.delegate.notifyDaemonsAboutChangedPaths(changedPaths);
        }
    }
}

