/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.impl;

import com.android.tools.idea.gradle.model.IdeDependencyCore;
import com.android.tools.idea.gradle.model.IdeLibrary;
import com.android.tools.idea.gradle.model.IdeLibraryModelResolver;
import com.android.tools.idea.gradle.model.ResolverType;
import com.android.tools.idea.gradle.model.impl.IdeResolvedLibraryTableImpl;
import com.android.tools.idea.gradle.model.impl.KotlinMultiplatformIdeLibraryTable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/model/impl/IdeLibraryModelResolverImpl;", "Lcom/android/tools/idea/gradle/model/IdeLibraryModelResolver;", "globalLibraryTable", "Lcom/android/tools/idea/gradle/model/impl/IdeResolvedLibraryTableImpl;", "kmpLibraryTable", "Lcom/android/tools/idea/gradle/model/impl/KotlinMultiplatformIdeLibraryTable;", "<init>", "(Lcom/android/tools/idea/gradle/model/impl/IdeResolvedLibraryTableImpl;Lcom/android/tools/idea/gradle/model/impl/KotlinMultiplatformIdeLibraryTable;)V", "resolve", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/gradle/model/IdeLibrary;", "unresolved", "Lcom/android/tools/idea/gradle/model/IdeDependencyCore;", "Companion", "intellij.android.projectSystem.gradle.models"})
public final class IdeLibraryModelResolverImpl
implements IdeLibraryModelResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IdeResolvedLibraryTableImpl globalLibraryTable;
    @Nullable
    private final KotlinMultiplatformIdeLibraryTable kmpLibraryTable;

    @VisibleForTesting
    public IdeLibraryModelResolverImpl(@Nullable IdeResolvedLibraryTableImpl globalLibraryTable, @Nullable KotlinMultiplatformIdeLibraryTable kmpLibraryTable) {
        this.globalLibraryTable = globalLibraryTable;
        this.kmpLibraryTable = kmpLibraryTable;
    }

    @Override
    @NotNull
    public Sequence<IdeLibrary> resolve(@NotNull IdeDependencyCore unresolved) {
        List<IdeLibrary> list;
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        if (unresolved.getTarget().getResolverType() == ResolverType.KMP_ANDROID) {
            KotlinMultiplatformIdeLibraryTable kotlinMultiplatformIdeLibraryTable = this.kmpLibraryTable;
            Intrinsics.checkNotNull((Object)kotlinMultiplatformIdeLibraryTable);
            list = kotlinMultiplatformIdeLibraryTable.getLibraries().get(unresolved.getTarget().getLibraryIndex());
        } else {
            IdeResolvedLibraryTableImpl ideResolvedLibraryTableImpl = this.globalLibraryTable;
            Intrinsics.checkNotNull((Object)ideResolvedLibraryTableImpl);
            list = ideResolvedLibraryTableImpl.getLibraries().get(unresolved.getTarget().getLibraryIndex());
        }
        return CollectionsKt.asSequence((Iterable)list);
    }

    @JvmStatic
    @NotNull
    public static final IdeLibraryModelResolverImpl fromLibraryTables(@Nullable IdeResolvedLibraryTableImpl globalLibraryTable, @Nullable KotlinMultiplatformIdeLibraryTable kmpLibraryTable) {
        return Companion.fromLibraryTables(globalLibraryTable, kmpLibraryTable);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/gradle/model/impl/IdeLibraryModelResolverImpl$Companion;", "", "<init>", "()V", "fromLibraryTables", "Lcom/android/tools/idea/gradle/model/impl/IdeLibraryModelResolverImpl;", "globalLibraryTable", "Lcom/android/tools/idea/gradle/model/impl/IdeResolvedLibraryTableImpl;", "kmpLibraryTable", "Lcom/android/tools/idea/gradle/model/impl/KotlinMultiplatformIdeLibraryTable;", "intellij.android.projectSystem.gradle.models"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IdeLibraryModelResolverImpl fromLibraryTables(@Nullable IdeResolvedLibraryTableImpl globalLibraryTable, @Nullable KotlinMultiplatformIdeLibraryTable kmpLibraryTable) {
            return new IdeLibraryModelResolverImpl(globalLibraryTable, kmpLibraryTable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

