/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.metrics.CustomResourceMetricValue;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PartitionQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetricsForCustomResources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TimeBucketMetrics;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class QueueMetrics
implements MetricsSource {
    @Metric(value={"# of apps submitted"})
    MutableCounterInt appsSubmitted;
    @Metric(value={"# of running apps"})
    MutableGaugeInt appsRunning;
    @Metric(value={"# of pending apps"})
    MutableGaugeInt appsPending;
    @Metric(value={"# of apps completed"})
    MutableCounterInt appsCompleted;
    @Metric(value={"# of apps killed"})
    MutableCounterInt appsKilled;
    @Metric(value={"# of apps failed"})
    MutableCounterInt appsFailed;
    @Metric(value={"# of Unmanaged apps submitted"})
    private MutableCounterInt unmanagedAppsSubmitted;
    @Metric(value={"# of Unmanaged running apps"})
    private MutableGaugeInt unmanagedAppsRunning;
    @Metric(value={"# of Unmanaged pending apps"})
    private MutableGaugeInt unmanagedAppsPending;
    @Metric(value={"# of Unmanaged apps completed"})
    private MutableCounterInt unmanagedAppsCompleted;
    @Metric(value={"# of Unmanaged apps killed"})
    private MutableCounterInt unmanagedAppsKilled;
    @Metric(value={"# of Unmanaged apps failed"})
    private MutableCounterInt unmanagedAppsFailed;
    @Metric(value={"Aggregate # of allocated node-local containers"})
    MutableCounterLong aggregateNodeLocalContainersAllocated;
    @Metric(value={"Aggregate # of allocated rack-local containers"})
    MutableCounterLong aggregateRackLocalContainersAllocated;
    @Metric(value={"Aggregate # of allocated off-switch containers"})
    MutableCounterLong aggregateOffSwitchContainersAllocated;
    @Metric(value={"Aggregate # of preempted containers"})
    MutableCounterLong aggregateContainersPreempted;
    @Metric(value={"Aggregate # of preempted memory seconds"})
    MutableCounterLong aggregateMemoryMBSecondsPreempted;
    @Metric(value={"Aggregate # of preempted vcore seconds"})
    MutableCounterLong aggregateVcoreSecondsPreempted;
    @Metric(value={"# of active users"})
    MutableGaugeInt activeUsers;
    @Metric(value={"# of active applications"})
    MutableGaugeInt activeApplications;
    @Metric(value={"App Attempt First Container Allocation Delay"})
    MutableRate appAttemptFirstContainerAllocationDelay;
    @Metric(value={"Aggregate total of preempted memory MB"})
    MutableCounterLong aggregateMemoryMBPreempted;
    @Metric(value={"Aggregate total of preempted vcores"})
    MutableCounterLong aggregateVcoresPreempted;
    @Metric(value={"Allocated memory in MB"})
    MutableGaugeLong allocatedMB;
    @Metric(value={"Allocated CPU in virtual cores"})
    MutableGaugeInt allocatedVCores;
    @Metric(value={"# of allocated containers"})
    MutableGaugeInt allocatedContainers;
    @Metric(value={"Aggregate # of allocated containers"})
    MutableCounterLong aggregateContainersAllocated;
    @Metric(value={"Aggregate # of released containers"})
    MutableCounterLong aggregateContainersReleased;
    @Metric(value={"Available memory in MB"})
    MutableGaugeLong availableMB;
    @Metric(value={"Available CPU in virtual cores"})
    MutableGaugeInt availableVCores;
    @Metric(value={"Pending memory allocation in MB"})
    MutableGaugeLong pendingMB;
    @Metric(value={"Pending CPU allocation in virtual cores"})
    MutableGaugeInt pendingVCores;
    @Metric(value={"# of pending containers"})
    MutableGaugeInt pendingContainers;
    @Metric(value={"# of reserved memory in MB"})
    MutableGaugeLong reservedMB;
    @Metric(value={"Reserved CPU in virtual cores"})
    MutableGaugeInt reservedVCores;
    @Metric(value={"# of reserved containers"})
    MutableGaugeInt reservedContainers;
    private static final String CONFIGURATION_VALIDATION = "yarn.configuration-validation";
    private final MutableGaugeInt[] runningTime;
    private TimeBucketMetrics<ApplicationId> runBuckets;
    static final Logger LOG = LoggerFactory.getLogger(QueueMetrics.class);
    static final MetricsInfo RECORD_INFO = Interns.info((String)"QueueMetrics", (String)"Metrics for the resource scheduler");
    protected static final MetricsInfo QUEUE_INFO = Interns.info((String)"Queue", (String)"Metrics by queue");
    protected static final MetricsInfo USER_INFO = Interns.info((String)"User", (String)"Metrics by user");
    protected static final MetricsInfo PARTITION_INFO = Interns.info((String)"Partition", (String)"Metrics by partition");
    static final Splitter Q_SPLITTER = Splitter.on((char)'.').omitEmptyStrings().trimResults();
    protected final MetricsRegistry registry;
    protected final String queueName;
    private QueueMetrics parent;
    private Queue parentQueue;
    protected final MetricsSystem metricsSystem;
    protected final Map<String, QueueMetrics> users;
    protected final Configuration conf;
    private QueueMetricsForCustomResources queueMetricsForCustomResources;
    private final boolean enableUserMetrics;
    protected static final MetricsInfo P_RECORD_INFO = Interns.info((String)"PartitionQueueMetrics", (String)"Metrics for the resource scheduler");
    public static final String DEFAULT_PARTITION = "default";
    public static final String DEFAULT_PARTITION_JMX_STR = "";
    public static final String METRIC_NAME_DELIMITER = ".";
    private static final String ALLOCATED_RESOURCE_METRIC_PREFIX = "AllocatedResource.";
    private static final String ALLOCATED_RESOURCE_METRIC_DESC = "Allocated NAME";
    private static final String AVAILABLE_RESOURCE_METRIC_PREFIX = "AvailableResource.";
    private static final String AVAILABLE_RESOURCE_METRIC_DESC = "Available NAME";
    private static final String PENDING_RESOURCE_METRIC_PREFIX = "PendingResource.";
    private static final String PENDING_RESOURCE_METRIC_DESC = "Pending NAME";
    private static final String RESERVED_RESOURCE_METRIC_PREFIX = "ReservedResource.";
    private static final String RESERVED_RESOURCE_METRIC_DESC = "Reserved NAME";
    private static final String AGGREGATE_PREEMPTED_SECONDS_METRIC_PREFIX = "AggregatePreemptedSeconds.";
    private static final String AGGREGATE_PREEMPTED_SECONDS_METRIC_DESC = "Aggregate Preempted Seconds for NAME";
    protected Set<String> storedPartitionMetrics = Sets.newConcurrentHashSet();
    private static final Map<String, QueueMetrics> QUEUE_METRICS = new HashMap<String, QueueMetrics>();

    public QueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        this.registry = this instanceof PartitionQueueMetrics ? new MetricsRegistry(P_RECORD_INFO) : new MetricsRegistry(RECORD_INFO);
        this.queueName = queueName;
        this.parent = parent != null ? parent.getMetrics() : null;
        this.parentQueue = parent;
        this.users = enableUserMetrics ? new HashMap() : null;
        this.enableUserMetrics = enableUserMetrics;
        this.metricsSystem = ms;
        this.conf = conf;
        this.runningTime = this.buildBuckets(conf);
        this.createQueueMetricsForCustomResources();
    }

    protected QueueMetrics tag(MetricsInfo info, String value) {
        this.registry.tag(info, value);
        return this;
    }

    protected static StringBuilder sourceName(String queueName) {
        StringBuilder sb = new StringBuilder(RECORD_INFO.name());
        int i = 0;
        for (String node : Q_SPLITTER.split((CharSequence)queueName)) {
            sb.append(",q").append(i++).append('=').append(node);
        }
        return sb;
    }

    static StringBuilder pSourceName(String partition) {
        StringBuilder sb = new StringBuilder(P_RECORD_INFO.name());
        sb.append(",partition").append('=').append(partition);
        return sb;
    }

    static StringBuilder qSourceName(String queueName) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String node : Q_SPLITTER.split((CharSequence)queueName)) {
            sb.append(",q").append(i++).append('=').append(node);
        }
        return sb;
    }

    public static synchronized QueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        return QueueMetrics.forQueue(DefaultMetricsSystem.instance(), queueName, parent, enableUserMetrics, conf);
    }

    @InterfaceAudience.Private
    public static synchronized void clearQueueMetrics() {
        QUEUE_METRICS.clear();
    }

    public static Map<String, QueueMetrics> getQueueMetrics() {
        return QUEUE_METRICS;
    }

    public static synchronized QueueMetrics forQueue(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        QueueMetrics metrics = QueueMetrics.getQueueMetrics().get(queueName);
        if (metrics == null) {
            metrics = new QueueMetrics(ms, queueName, parent, enableUserMetrics, conf).tag(QUEUE_INFO, queueName);
            if (ms != null) {
                metrics = (QueueMetrics)ms.register(QueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
            }
            QueueMetrics.getQueueMetrics().put(queueName, metrics);
        }
        return metrics;
    }

    public synchronized QueueMetrics getUserMetrics(String userName) {
        if (this.users == null) {
            return null;
        }
        QueueMetrics metrics = this.users.get(userName);
        if (metrics == null) {
            metrics = new QueueMetrics(this.metricsSystem, this.queueName, null, false, this.conf);
            this.users.put(userName, metrics);
            this.metricsSystem.register(QueueMetrics.sourceName(this.queueName).append(",user=").append(userName).toString(), "Metrics for user '" + userName + "' in queue '" + this.queueName + "'", (Object)metrics.tag(QUEUE_INFO, this.queueName).tag(USER_INFO, userName));
        }
        return metrics;
    }

    public synchronized QueueMetrics getPartitionQueueMetrics(String partition) {
        String partitionJMXStr = partition;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            partition = DEFAULT_PARTITION;
            partitionJMXStr = DEFAULT_PARTITION_JMX_STR;
        }
        String metricName = partition + METRIC_NAME_DELIMITER + this.queueName;
        QueueMetrics metrics = QueueMetrics.getQueueMetrics().get(metricName);
        if (metrics == null) {
            PartitionQueueMetrics queueMetrics = new PartitionQueueMetrics(this.metricsSystem, this.queueName, this.parentQueue, this.enableUserMetrics, this.conf, partition);
            this.metricsSystem.register(QueueMetrics.pSourceName(partitionJMXStr).append((CharSequence)QueueMetrics.qSourceName(this.queueName)).toString(), "Metrics for queue: " + this.queueName, (Object)queueMetrics.tag(PARTITION_INFO, partitionJMXStr).tag(QUEUE_INFO, this.queueName));
            if (!QueueMetrics.isConfigurationValidationSet(this.conf)) {
                QueueMetrics.getQueueMetrics().put(metricName, queueMetrics);
            }
            this.registerPartitionMetricsCreation(metricName);
            return queueMetrics;
        }
        return metrics;
    }

    public static boolean isConfigurationValidationSet(Configuration conf) {
        return conf.getBoolean(CONFIGURATION_VALIDATION, false);
    }

    public static void setConfigurationValidation(Configuration conf, boolean value) {
        conf.setBoolean(CONFIGURATION_VALIDATION, value);
    }

    private QueueMetrics getPartitionMetrics(String partition) {
        String partitionJMXStr = partition;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            partition = DEFAULT_PARTITION;
            partitionJMXStr = DEFAULT_PARTITION_JMX_STR;
        }
        String metricName = partition + METRIC_NAME_DELIMITER;
        QueueMetrics metrics = QueueMetrics.getQueueMetrics().get(metricName);
        if (metrics == null) {
            metrics = new PartitionQueueMetrics(this.metricsSystem, this.queueName, null, false, this.conf, partition);
            if (this.metricsSystem != null) {
                this.metricsSystem.register(QueueMetrics.pSourceName(partitionJMXStr).toString(), "Metrics for partition: " + partitionJMXStr, (Object)((PartitionQueueMetrics)metrics.tag(PARTITION_INFO, partitionJMXStr)));
            }
            QueueMetrics.getQueueMetrics().put(metricName, metrics);
            this.registerPartitionMetricsCreation(metricName);
        }
        return metrics;
    }

    private ArrayList<Integer> parseInts(String value) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : value.split(",")) {
            result.add(Integer.parseInt(s.trim()));
        }
        return result;
    }

    private MutableGaugeInt[] buildBuckets(Configuration conf) {
        ArrayList<Integer> buckets = this.parseInts(conf.get("yarn.resourcemanager.metrics.runtime.buckets", "60,300,1440"));
        MutableGaugeInt[] result = new MutableGaugeInt[buckets.size() + 1];
        result[0] = this.registry.newGauge("running_0", DEFAULT_PARTITION_JMX_STR, 0);
        long[] cuts = new long[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            result[i + 1] = this.registry.newGauge("running_" + buckets.get(i), DEFAULT_PARTITION_JMX_STR, 0);
            cuts[i] = (long)buckets.get(i).intValue() * 1000L * 60L;
        }
        this.runBuckets = new TimeBucketMetrics(cuts);
        return result;
    }

    private void updateRunningTime() {
        int[] counts = this.runBuckets.getBucketCounts(System.currentTimeMillis());
        for (int i = 0; i < counts.length; ++i) {
            this.runningTime[i].set(counts[i]);
        }
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.updateRunningTime();
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public void submitApp(String user, boolean unmanagedAM) {
        QueueMetrics userMetrics;
        this.appsSubmitted.incr();
        if (unmanagedAM) {
            this.unmanagedAppsSubmitted.incr();
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.submitApp(user, unmanagedAM);
        }
        if (this.parent != null) {
            this.parent.submitApp(user, unmanagedAM);
        }
    }

    public void submitAppAttempt(String user, boolean unmanagedAM) {
        QueueMetrics userMetrics;
        this.appsPending.incr();
        if (unmanagedAM) {
            this.unmanagedAppsPending.incr();
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.submitAppAttempt(user, unmanagedAM);
        }
        if (this.parent != null) {
            this.parent.submitAppAttempt(user, unmanagedAM);
        }
    }

    public void runAppAttempt(ApplicationId appId, String user, boolean unmanagedAM) {
        QueueMetrics userMetrics;
        this.runBuckets.add(appId, System.currentTimeMillis());
        this.appsRunning.incr();
        this.appsPending.decr();
        if (unmanagedAM) {
            this.unmanagedAppsRunning.incr();
            this.unmanagedAppsPending.decr();
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.runAppAttempt(appId, user, unmanagedAM);
        }
        if (this.parent != null) {
            this.parent.runAppAttempt(appId, user, unmanagedAM);
        }
    }

    public void finishAppAttempt(ApplicationId appId, boolean isPending, String user, boolean unmanagedAM) {
        QueueMetrics userMetrics;
        this.runBuckets.remove(appId);
        if (isPending) {
            this.appsPending.decr();
        } else {
            this.appsRunning.decr();
        }
        if (unmanagedAM) {
            if (isPending) {
                this.unmanagedAppsPending.decr();
            } else {
                this.unmanagedAppsRunning.decr();
            }
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.finishAppAttempt(appId, isPending, user, unmanagedAM);
        }
        if (this.parent != null) {
            this.parent.finishAppAttempt(appId, isPending, user, unmanagedAM);
        }
    }

    public void finishApp(String user, RMAppState rmAppFinalState, boolean unmanagedAM) {
        QueueMetrics userMetrics;
        switch (rmAppFinalState) {
            case KILLED: {
                this.appsKilled.incr();
                break;
            }
            case FAILED: {
                this.appsFailed.incr();
                break;
            }
            default: {
                this.appsCompleted.incr();
            }
        }
        if (unmanagedAM) {
            switch (rmAppFinalState) {
                case KILLED: {
                    this.unmanagedAppsKilled.incr();
                    break;
                }
                case FAILED: {
                    this.unmanagedAppsFailed.incr();
                    break;
                }
                default: {
                    this.unmanagedAppsCompleted.incr();
                }
            }
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.finishApp(user, rmAppFinalState, unmanagedAM);
        }
        if (this.parent != null) {
            this.parent.finishApp(user, rmAppFinalState, unmanagedAM);
        }
    }

    public void moveAppFrom(AppSchedulingInfo app, boolean unmanagedAM) {
        QueueMetrics userMetrics;
        if (app.isPending()) {
            this.appsPending.decr();
        } else {
            this.appsRunning.decr();
        }
        if (unmanagedAM) {
            if (app.isPending()) {
                this.unmanagedAppsPending.decr();
            } else {
                this.unmanagedAppsRunning.decr();
            }
        }
        if ((userMetrics = this.getUserMetrics(app.getUser())) != null) {
            userMetrics.moveAppFrom(app, unmanagedAM);
        }
        if (this.parent != null) {
            this.parent.moveAppFrom(app, unmanagedAM);
        }
    }

    public void moveAppTo(AppSchedulingInfo app, boolean unmanagedAM) {
        QueueMetrics userMetrics;
        if (app.isPending()) {
            this.appsPending.incr();
        } else {
            this.appsRunning.incr();
        }
        if (unmanagedAM) {
            if (app.isPending()) {
                this.unmanagedAppsPending.incr();
            } else {
                this.unmanagedAppsRunning.incr();
            }
        }
        if ((userMetrics = this.getUserMetrics(app.getUser())) != null) {
            userMetrics.moveAppTo(app, unmanagedAM);
        }
        if (this.parent != null) {
            this.parent.moveAppTo(app, unmanagedAM);
        }
    }

    public void setAvailableResourcesToQueue(String partition, Resource limit) {
        QueueMetrics partitionQueueMetrics;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            this.setAvailableResources(limit);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null) {
            QueueMetrics partitionMetrics;
            partitionQueueMetrics.setAvailableResources(limit);
            if (this.queueName.equals("root") && (partitionMetrics = this.getPartitionMetrics(partition)) != null) {
                partitionMetrics.setAvailableResources(limit);
            }
        }
    }

    public void setAvailableResources(Resource limit) {
        this.availableMB.set(limit.getMemorySize());
        this.availableVCores.set(limit.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.setAvailable(limit);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getAvailableValues(), this.registry, AVAILABLE_RESOURCE_METRIC_PREFIX, AVAILABLE_RESOURCE_METRIC_DESC);
        }
    }

    public void setAvailableResourcesToQueue(Resource limit) {
        this.setAvailableResourcesToQueue(DEFAULT_PARTITION_JMX_STR, limit);
    }

    public void setAvailableResourcesToUser(String partition, String user, Resource limit) {
        QueueMetrics partitionUserMetrics;
        QueueMetrics partitionQueueMetrics;
        QueueMetrics userMetrics;
        if ((partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) && (userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.setAvailableResources(limit);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null && (partitionUserMetrics = partitionQueueMetrics.getUserMetrics(user)) != null) {
            partitionUserMetrics.setAvailableResources(limit);
        }
    }

    public void incrPendingResources(String partition, String user, int containers, Resource res) {
        QueueMetrics partitionQueueMetrics;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            this.internalIncrPendingResources(partition, user, containers, res);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null) {
            partitionQueueMetrics.internalIncrPendingResources(partition, user, containers, res);
            QueueMetrics partitionMetrics = this.getPartitionMetrics(partition);
            if (partitionMetrics != null) {
                partitionMetrics.incrementPendingResources(containers, res);
            }
        }
    }

    public void internalIncrPendingResources(String partition, String user, int containers, Resource res) {
        this.incrementPendingResources(containers, res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.internalIncrPendingResources(partition, user, containers, res);
        }
        if (this.parent != null) {
            this.parent.internalIncrPendingResources(partition, user, containers, res);
        }
    }

    protected void createQueueMetricsForCustomResources() {
        if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
            this.queueMetricsForCustomResources = new QueueMetricsForCustomResources();
            this.registerCustomResources();
        }
    }

    protected void registerCustomResources() {
        Map customResources = this.queueMetricsForCustomResources.initAndGetCustomResources();
        this.queueMetricsForCustomResources.registerCustomResources(customResources, this.registry);
        this.queueMetricsForCustomResources.registerCustomResources(customResources, this.registry, PENDING_RESOURCE_METRIC_PREFIX, PENDING_RESOURCE_METRIC_DESC);
        this.queueMetricsForCustomResources.registerCustomResources(customResources, this.registry, RESERVED_RESOURCE_METRIC_PREFIX, RESERVED_RESOURCE_METRIC_DESC);
        this.queueMetricsForCustomResources.registerCustomResources(customResources, this.registry, AGGREGATE_PREEMPTED_SECONDS_METRIC_PREFIX, AGGREGATE_PREEMPTED_SECONDS_METRIC_DESC);
    }

    private void incrementPendingResources(int containers, Resource res) {
        this.pendingContainers.incr(containers);
        this.pendingMB.incr(res.getMemorySize() * (long)containers);
        this.pendingVCores.incr(res.getVirtualCores() * containers);
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increasePending(res, containers);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getPendingValues(), this.registry, PENDING_RESOURCE_METRIC_PREFIX, PENDING_RESOURCE_METRIC_DESC);
        }
    }

    public void decrPendingResources(String partition, String user, int containers, Resource res) {
        QueueMetrics partitionQueueMetrics;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            this.internalDecrPendingResources(partition, user, containers, res);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null) {
            partitionQueueMetrics.internalDecrPendingResources(partition, user, containers, res);
            QueueMetrics partitionMetrics = this.getPartitionMetrics(partition);
            if (partitionMetrics != null) {
                partitionMetrics.decrementPendingResources(containers, res);
            }
        }
    }

    protected void internalDecrPendingResources(String partition, String user, int containers, Resource res) {
        this.decrementPendingResources(containers, res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.internalDecrPendingResources(partition, user, containers, res);
        }
        if (this.parent != null) {
            this.parent.internalDecrPendingResources(partition, user, containers, res);
        }
    }

    private void decrementPendingResources(int containers, Resource res) {
        this.pendingContainers.decr(containers);
        this.pendingMB.decr(res.getMemorySize() * (long)containers);
        this.pendingVCores.decr(res.getVirtualCores() * containers);
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.decreasePending(res, containers);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getPendingValues(), this.registry, PENDING_RESOURCE_METRIC_PREFIX, PENDING_RESOURCE_METRIC_DESC);
        }
    }

    public void incrNodeTypeAggregations(String user, NodeType type) {
        if (type == NodeType.NODE_LOCAL) {
            this.aggregateNodeLocalContainersAllocated.incr();
        } else if (type == NodeType.RACK_LOCAL) {
            this.aggregateRackLocalContainersAllocated.incr();
        } else if (type == NodeType.OFF_SWITCH) {
            this.aggregateOffSwitchContainersAllocated.incr();
        } else {
            return;
        }
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.incrNodeTypeAggregations(user, type);
        }
        if (this.parent != null) {
            this.parent.incrNodeTypeAggregations(user, type);
        }
    }

    public void allocateResources(String partition, String user, int containers, Resource res, boolean decrPending) {
        QueueMetrics partitionQueueMetrics;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            this.internalAllocateResources(partition, user, containers, res, decrPending);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null) {
            partitionQueueMetrics.internalAllocateResources(partition, user, containers, res, decrPending);
            QueueMetrics partitionMetrics = this.getPartitionMetrics(partition);
            if (partitionMetrics != null) {
                partitionMetrics.computeAllocateResources(containers, res, decrPending);
            }
        }
    }

    public void internalAllocateResources(String partition, String user, int containers, Resource res, boolean decrPending) {
        this.computeAllocateResources(containers, res, decrPending);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.internalAllocateResources(partition, user, containers, res, decrPending);
        }
        if (this.parent != null) {
            this.parent.internalAllocateResources(partition, user, containers, res, decrPending);
        }
    }

    private void computeAllocateResources(int containers, Resource res, boolean decrPending) {
        this.allocatedContainers.incr(containers);
        this.aggregateContainersAllocated.incr((long)containers);
        this.allocatedMB.incr(res.getMemorySize() * (long)containers);
        this.allocatedVCores.incr(res.getVirtualCores() * containers);
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increaseAllocated(res, containers);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getAllocatedValues(), this.registry, ALLOCATED_RESOURCE_METRIC_PREFIX, ALLOCATED_RESOURCE_METRIC_DESC);
        }
        if (decrPending) {
            this.decrementPendingResources(containers, res);
        }
    }

    public void allocateResources(String partition, String user, Resource res) {
        QueueMetrics userMetrics;
        this.allocatedMB.incr(res.getMemorySize());
        this.allocatedVCores.incr(res.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increaseAllocated(res);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getAllocatedValues(), this.registry, ALLOCATED_RESOURCE_METRIC_PREFIX, ALLOCATED_RESOURCE_METRIC_DESC);
        }
        this.pendingMB.decr(res.getMemorySize());
        this.pendingVCores.decr(res.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.decreasePending(res);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getPendingValues(), this.registry, PENDING_RESOURCE_METRIC_PREFIX, PENDING_RESOURCE_METRIC_DESC);
        }
        if ((userMetrics = this.getUserMetrics(user)) != null) {
            userMetrics.allocateResources(partition, user, res);
        }
        if (this.parent != null) {
            this.parent.allocateResources(partition, user, res);
        }
    }

    public void releaseResources(String partition, String user, int containers, Resource res) {
        QueueMetrics partitionQueueMetrics;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            this.internalReleaseResources(partition, user, containers, res);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null) {
            partitionQueueMetrics.internalReleaseResources(partition, user, containers, res);
            QueueMetrics partitionMetrics = this.getPartitionMetrics(partition);
            if (partitionMetrics != null) {
                partitionMetrics.computeReleaseResources(containers, res);
            }
        }
    }

    public void internalReleaseResources(String partition, String user, int containers, Resource res) {
        this.computeReleaseResources(containers, res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.internalReleaseResources(partition, user, containers, res);
        }
        if (this.parent != null) {
            this.parent.internalReleaseResources(partition, user, containers, res);
        }
    }

    private void computeReleaseResources(int containers, Resource res) {
        this.allocatedContainers.decr(containers);
        this.aggregateContainersReleased.incr((long)containers);
        this.allocatedMB.decr(res.getMemorySize() * (long)containers);
        this.allocatedVCores.decr(res.getVirtualCores() * containers);
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.decreaseAllocated(res, containers);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getAllocatedValues(), this.registry, ALLOCATED_RESOURCE_METRIC_PREFIX, ALLOCATED_RESOURCE_METRIC_DESC);
        }
    }

    public void preemptContainer() {
        this.aggregateContainersPreempted.incr();
        if (this.parent != null) {
            this.parent.preemptContainer();
        }
    }

    public void updatePreemptedMemoryMBSeconds(long mbSeconds) {
        this.aggregateMemoryMBSecondsPreempted.incr(mbSeconds);
        if (this.parent != null) {
            this.parent.updatePreemptedMemoryMBSeconds(mbSeconds);
        }
    }

    public void updatePreemptedVcoreSeconds(long vcoreSeconds) {
        this.aggregateVcoreSecondsPreempted.incr(vcoreSeconds);
        if (this.parent != null) {
            this.parent.updatePreemptedVcoreSeconds(vcoreSeconds);
        }
    }

    public void updatePreemptedResources(Resource res) {
        this.aggregateMemoryMBPreempted.incr(res.getMemorySize());
        this.aggregateVcoresPreempted.incr((long)res.getVirtualCores());
        if (this.parent != null) {
            this.parent.updatePreemptedResources(res);
        }
    }

    public void updatePreemptedForCustomResources(Resource res) {
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increaseAggregatedPreempted(res);
        }
        if (this.parent != null) {
            this.parent.updatePreemptedForCustomResources(res);
        }
    }

    public void updatePreemptedSecondsForCustomResources(Resource res, long seconds) {
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increaseAggregatedPreemptedSeconds(res, seconds);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getAggregatePreemptedSeconds().getValues(), this.registry, AGGREGATE_PREEMPTED_SECONDS_METRIC_PREFIX, AGGREGATE_PREEMPTED_SECONDS_METRIC_DESC);
        }
        if (this.parent != null) {
            this.parent.updatePreemptedSecondsForCustomResources(res, seconds);
        }
    }

    public void reserveResource(String partition, String user, Resource res) {
        QueueMetrics partitionQueueMetrics;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            this.internalReserveResources(partition, user, res);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null) {
            partitionQueueMetrics.internalReserveResources(partition, user, res);
            QueueMetrics partitionMetrics = this.getPartitionMetrics(partition);
            if (partitionMetrics != null) {
                partitionMetrics.incrReserveResources(res);
            }
        }
    }

    protected void internalReserveResources(String partition, String user, Resource res) {
        this.incrReserveResources(res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.internalReserveResources(partition, user, res);
        }
        if (this.parent != null) {
            this.parent.internalReserveResources(partition, user, res);
        }
    }

    public void incrReserveResources(Resource res) {
        this.reservedContainers.incr();
        this.reservedMB.incr(res.getMemorySize());
        this.reservedVCores.incr(res.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.increaseReserved(res);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getReservedValues(), this.registry, RESERVED_RESOURCE_METRIC_PREFIX, RESERVED_RESOURCE_METRIC_DESC);
        }
    }

    public void unreserveResource(String partition, String user, Resource res) {
        QueueMetrics partitionQueueMetrics;
        if (partition == null || partition.equals(DEFAULT_PARTITION_JMX_STR)) {
            this.internalUnReserveResources(partition, user, res);
        }
        if ((partitionQueueMetrics = this.getPartitionQueueMetrics(partition)) != null) {
            partitionQueueMetrics.internalUnReserveResources(partition, user, res);
            QueueMetrics partitionMetrics = this.getPartitionMetrics(partition);
            if (partitionMetrics != null) {
                partitionMetrics.decrReserveResource(res);
            }
        }
    }

    protected void internalUnReserveResources(String partition, String user, Resource res) {
        this.decrReserveResource(res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.internalUnReserveResources(partition, user, res);
        }
        if (this.parent != null) {
            this.parent.internalUnReserveResources(partition, user, res);
        }
    }

    public void decrReserveResource(Resource res) {
        int containers = 1;
        this.reservedContainers.decr(containers);
        this.reservedMB.decr(res.getMemorySize());
        this.reservedVCores.decr(res.getVirtualCores());
        if (this.queueMetricsForCustomResources != null) {
            this.queueMetricsForCustomResources.decreaseReserved(res);
            this.queueMetricsForCustomResources.registerCustomResources(this.queueMetricsForCustomResources.getReservedValues(), this.registry, RESERVED_RESOURCE_METRIC_PREFIX, RESERVED_RESOURCE_METRIC_DESC);
        }
    }

    public void incrActiveUsers() {
        this.activeUsers.incr();
    }

    public void decrActiveUsers() {
        this.activeUsers.decr();
    }

    public void activateApp(String user) {
        this.activeApplications.incr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.activateApp(user);
        }
        if (this.parent != null) {
            this.parent.activateApp(user);
        }
    }

    public void deactivateApp(String user) {
        this.activeApplications.decr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.deactivateApp(user);
        }
        if (this.parent != null) {
            this.parent.deactivateApp(user);
        }
    }

    public void addAppAttemptFirstContainerAllocationDelay(long latency) {
        this.appAttemptFirstContainerAllocationDelay.add(latency);
    }

    public int getAppsSubmitted() {
        return this.appsSubmitted.value();
    }

    public int getUnmanagedAppsSubmitted() {
        return this.unmanagedAppsSubmitted.value();
    }

    public int getAppsRunning() {
        return this.appsRunning.value();
    }

    public int getUnmanagedAppsRunning() {
        return this.unmanagedAppsRunning.value();
    }

    public int getAppsPending() {
        return this.appsPending.value();
    }

    public int getUnmanagedAppsPending() {
        return this.unmanagedAppsPending.value();
    }

    public int getAppsCompleted() {
        return this.appsCompleted.value();
    }

    public int getUnmanagedAppsCompleted() {
        return this.unmanagedAppsCompleted.value();
    }

    public int getAppsKilled() {
        return this.appsKilled.value();
    }

    public int getAppsFailed() {
        return this.appsFailed.value();
    }

    public int getUnmanagedAppsFailed() {
        return this.unmanagedAppsFailed.value();
    }

    public Resource getAllocatedResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.allocatedMB.value(), (int)this.allocatedVCores.value(), (Map)this.queueMetricsForCustomResources.getAllocatedValues());
        }
        return Resource.newInstance((long)this.allocatedMB.value(), (int)this.allocatedVCores.value());
    }

    public Resource getAvailableResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.availableMB.value(), (int)this.availableVCores.value(), (Map)this.queueMetricsForCustomResources.getAvailableValues());
        }
        return Resource.newInstance((long)this.availableMB.value(), (int)this.availableVCores.value());
    }

    public Resource getPendingResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.pendingMB.value(), (int)this.pendingVCores.value(), this.queueMetricsForCustomResources.getPendingValues());
        }
        return Resource.newInstance((long)this.pendingMB.value(), (int)this.pendingVCores.value());
    }

    public Resource getReservedResources() {
        if (this.queueMetricsForCustomResources != null) {
            return Resource.newInstance((long)this.reservedMB.value(), (int)this.reservedVCores.value(), this.queueMetricsForCustomResources.getReservedValues());
        }
        return Resource.newInstance((long)this.reservedMB.value(), (int)this.reservedVCores.value());
    }

    @VisibleForTesting
    public CustomResourceMetricValue getAggregatedPreemptedSecondsResources() {
        return this.queueMetricsForCustomResources.getAggregatePreemptedSeconds();
    }

    @VisibleForTesting
    public MutableCounterLong getAggregateMemoryMBSecondsPreempted() {
        return this.aggregateMemoryMBSecondsPreempted;
    }

    @VisibleForTesting
    public MutableCounterLong getAggregateVcoreSecondsPreempted() {
        return this.aggregateVcoreSecondsPreempted;
    }

    @VisibleForTesting
    public long getAggregateMemoryMBPreempted() {
        return this.aggregateMemoryMBPreempted.value();
    }

    @VisibleForTesting
    public long getAggregateVcoresPreempted() {
        return this.aggregateVcoresPreempted.value();
    }

    public long getAllocatedMB() {
        return this.allocatedMB.value();
    }

    public int getAllocatedVirtualCores() {
        return this.allocatedVCores.value();
    }

    public int getAllocatedContainers() {
        return this.allocatedContainers.value();
    }

    public long getAvailableMB() {
        return this.availableMB.value();
    }

    public int getAvailableVirtualCores() {
        return this.availableVCores.value();
    }

    public long getPendingMB() {
        return this.pendingMB.value();
    }

    public int getPendingVirtualCores() {
        return this.pendingVCores.value();
    }

    public int getPendingContainers() {
        return this.pendingContainers.value();
    }

    public long getReservedMB() {
        return this.reservedMB.value();
    }

    public int getReservedVirtualCores() {
        return this.reservedVCores.value();
    }

    public int getReservedContainers() {
        return this.reservedContainers.value();
    }

    public int getActiveUsers() {
        return this.activeUsers.value();
    }

    public int getActiveApps() {
        return this.activeApplications.value();
    }

    public MetricsSystem getMetricsSystem() {
        return this.metricsSystem;
    }

    public long getAggregateAllocatedContainers() {
        return this.aggregateContainersAllocated.value();
    }

    public long getAggregateNodeLocalContainersAllocated() {
        return this.aggregateNodeLocalContainersAllocated.value();
    }

    public long getAggregateRackLocalContainersAllocated() {
        return this.aggregateRackLocalContainersAllocated.value();
    }

    public long getAggregateOffSwitchContainersAllocated() {
        return this.aggregateOffSwitchContainersAllocated.value();
    }

    public long getAggegatedReleasedContainers() {
        return this.aggregateContainersReleased.value();
    }

    public long getAggregatePreemptedContainers() {
        return this.aggregateContainersPreempted.value();
    }

    public void fillInValuesFromAvailableResources(Resource fromResource, Resource targetResource) {
        if (this.queueMetricsForCustomResources != null) {
            CustomResourceMetricValue availableResources = this.queueMetricsForCustomResources.getAvailable();
            for (Map.Entry availableEntry : availableResources.getValues().entrySet()) {
                String resourceName = (String)availableEntry.getKey();
                if (targetResource.getResourceValue(resourceName) != 0L) continue;
                Long availableValue = (Long)availableEntry.getValue();
                long value = Math.min(availableValue, fromResource.getResourceValue(resourceName));
                targetResource.setResourceValue(resourceName, value);
            }
        }
    }

    @VisibleForTesting
    public QueueMetricsForCustomResources getQueueMetricsForCustomResources() {
        return this.queueMetricsForCustomResources;
    }

    protected void setQueueMetricsForCustomResources(QueueMetricsForCustomResources metrics) {
        this.queueMetricsForCustomResources = metrics;
    }

    public void setParent(QueueMetrics parent) {
        this.parent = parent;
    }

    public Queue getParentQueue() {
        return this.parentQueue;
    }

    protected void registerPartitionMetricsCreation(String metricName) {
        if (this.storedPartitionMetrics != null) {
            this.storedPartitionMetrics.add(metricName);
        }
    }

    public void setParentQueue(Queue parentQueue) {
        this.parentQueue = parentQueue;
        if (this.storedPartitionMetrics == null) {
            return;
        }
        for (String partitionMetric : this.storedPartitionMetrics) {
            QueueMetrics metric = QueueMetrics.getQueueMetrics().get(partitionMetric);
            if (metric == null || metric.parentQueue == null) continue;
            metric.parentQueue = parentQueue;
        }
    }
}

