/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.tools.fedbalance.FedBalanceConfigs;

public class FedBalanceContext
implements Writable {
    private Path src;
    private Path dst;
    private String mount;
    private boolean forceCloseOpenFiles;
    private boolean useMountReadOnly;
    private int mapNum;
    private int bandwidthLimit;
    private FedBalanceConfigs.TrashOption trashOpt;
    private long delayDuration;
    private int diffThreshold;
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public Path getSrc() {
        return this.src;
    }

    public Path getDst() {
        return this.dst;
    }

    public String getMount() {
        return this.mount;
    }

    public boolean getForceCloseOpenFiles() {
        return this.forceCloseOpenFiles;
    }

    public boolean getUseMountReadOnly() {
        return this.useMountReadOnly;
    }

    public int getMapNum() {
        return this.mapNum;
    }

    public int getBandwidthLimit() {
        return this.bandwidthLimit;
    }

    public int getDiffThreshold() {
        return this.diffThreshold;
    }

    public FedBalanceConfigs.TrashOption getTrashOpt() {
        return this.trashOpt;
    }

    public void write(DataOutput out) throws IOException {
        this.conf.write(out);
        Text.writeString((DataOutput)out, (String)this.src.toString());
        Text.writeString((DataOutput)out, (String)this.dst.toString());
        Text.writeString((DataOutput)out, (String)this.mount);
        out.writeBoolean(this.forceCloseOpenFiles);
        out.writeBoolean(this.useMountReadOnly);
        out.writeInt(this.mapNum);
        out.writeInt(this.bandwidthLimit);
        out.writeInt(this.trashOpt.ordinal());
        out.writeLong(this.delayDuration);
        out.writeInt(this.diffThreshold);
    }

    public void readFields(DataInput in) throws IOException {
        this.conf = new Configuration(false);
        this.conf.readFields(in);
        this.src = new Path(Text.readString((DataInput)in));
        this.dst = new Path(Text.readString((DataInput)in));
        this.mount = Text.readString((DataInput)in);
        this.forceCloseOpenFiles = in.readBoolean();
        this.useMountReadOnly = in.readBoolean();
        this.mapNum = in.readInt();
        this.bandwidthLimit = in.readInt();
        this.trashOpt = FedBalanceConfigs.TrashOption.values()[in.readInt()];
        this.delayDuration = in.readLong();
        this.diffThreshold = in.readInt();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FedBalanceContext bc = (FedBalanceContext)obj;
        return new EqualsBuilder().append((Object)this.src, (Object)bc.src).append((Object)this.dst, (Object)bc.dst).append((Object)this.mount, (Object)bc.mount).append(this.forceCloseOpenFiles, bc.forceCloseOpenFiles).append(this.useMountReadOnly, bc.useMountReadOnly).append(this.mapNum, bc.mapNum).append(this.bandwidthLimit, bc.bandwidthLimit).append((Object)this.trashOpt, (Object)bc.trashOpt).append(this.delayDuration, bc.delayDuration).append(this.diffThreshold, bc.diffThreshold).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.src).append((Object)this.dst).append((Object)this.mount).append(this.forceCloseOpenFiles).append(this.useMountReadOnly).append(this.mapNum).append(this.bandwidthLimit).append((Object)this.trashOpt).append(this.delayDuration).append(this.diffThreshold).build();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Move ").append(this.src).append(" to ").append(this.dst);
        if (this.useMountReadOnly) {
            builder.append(" using router mode, mount point=").append(this.mount).append(".");
        } else {
            builder.append(" using normal federation mode.");
        }
        builder.append(" Submit distcp job with map=").append(this.mapNum).append(" and bandwidth=").append(this.bandwidthLimit).append(".");
        builder.append(" When the diff count is no greater than ").append(this.diffThreshold);
        if (this.forceCloseOpenFiles) {
            builder.append(", force close all open files.");
        } else {
            builder.append(", wait until there is no open files.");
        }
        switch (this.trashOpt) {
            case DELETE: {
                builder.append(" Delete the src after the job is complete.");
                break;
            }
            case TRASH: {
                builder.append(" Move the src to trash after the job is complete.");
                break;
            }
        }
        builder.append(" Delay duration is ").append(this.delayDuration).append("ms.");
        return builder.toString();
    }

    public static class Builder {
        private final Path src;
        private final Path dst;
        private final String mount;
        private final Configuration conf;
        private boolean forceCloseOpenFiles = false;
        private boolean useMountReadOnly = false;
        private int mapNum;
        private int bandwidthLimit;
        private FedBalanceConfigs.TrashOption trashOpt;
        private long delayDuration;
        private int diffThreshold;

        public Builder(Path src, Path dst, String mount, Configuration conf) {
            this.src = src;
            this.dst = dst;
            this.mount = mount;
            this.conf = conf;
        }

        public Builder setForceCloseOpenFiles(boolean value) {
            this.forceCloseOpenFiles = value;
            return this;
        }

        public Builder setUseMountReadOnly(boolean value) {
            this.useMountReadOnly = value;
            return this;
        }

        public Builder setMapNum(int value) {
            this.mapNum = value;
            return this;
        }

        public Builder setBandwidthLimit(int value) {
            this.bandwidthLimit = value;
            return this;
        }

        public Builder setTrash(FedBalanceConfigs.TrashOption value) {
            this.trashOpt = value;
            return this;
        }

        public Builder setDelayDuration(long value) {
            this.delayDuration = value;
            return this;
        }

        public Builder setDiffThreshold(int value) {
            this.diffThreshold = value;
            return this;
        }

        public FedBalanceContext build() {
            FedBalanceContext context = new FedBalanceContext();
            context.src = this.src;
            context.dst = this.dst;
            context.mount = this.mount;
            context.conf = this.conf;
            context.forceCloseOpenFiles = this.forceCloseOpenFiles;
            context.useMountReadOnly = this.useMountReadOnly;
            context.mapNum = this.mapNum;
            context.bandwidthLimit = this.bandwidthLimit;
            context.trashOpt = this.trashOpt;
            context.delayDuration = this.delayDuration;
            context.diffThreshold = this.diffThreshold;
            return context;
        }
    }
}

