/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ResponseUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import rx.Observable;
import rx.Single;

public class HttpClientUtils {
    public static Single<RxDocumentServiceResponse> parseResponseAsync(HttpClientResponse<ByteBuf> responseMessage) {
        if (responseMessage.getStatus().code() < 400) {
            Single<StoreResponse> storeResponse = ResponseUtils.toStoreResponse(responseMessage);
            return storeResponse.map(sr -> new RxDocumentServiceResponse(sr));
        }
        return HttpClientUtils.createDocumentClientException(responseMessage).flatMap(e -> Single.error((Throwable)e));
    }

    private static Single<DocumentClientException> createDocumentClientException(HttpClientResponse<ByteBuf> responseMessage) {
        Single readStream = ResponseUtils.toString((Observable<ByteBuf>)responseMessage.getContent()).toSingle();
        return readStream.map(body -> {
            Error error = new Error(body);
            return new DocumentClientException(responseMessage.getStatus().code(), error, HttpUtils.asMap((HttpResponseHeaders)responseMessage.getHeaders()));
        });
    }
}

