/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.method.dispatch;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.shaded.com.sun.jersey.api.core.HttpContext;
import org.apache.hadoop.shaded.com.sun.jersey.api.model.AbstractResourceMethod;
import org.apache.hadoop.shaded.com.sun.jersey.api.model.Parameter;
import org.apache.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentScope;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.inject.InjectableValuesProvider;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.method.dispatch.AbstractResourceMethodDispatchProvider;
import org.apache.hadoop.shaded.com.sun.jersey.spi.inject.Injectable;

public class EntityParamDispatchProvider
extends AbstractResourceMethodDispatchProvider {
    @Override
    protected InjectableValuesProvider getInjectableValuesProvider(AbstractResourceMethod abstractResourceMethod) {
        return new InjectableValuesProvider(this.processParameters(abstractResourceMethod));
    }

    private List<Injectable> processParameters(AbstractResourceMethod method) {
        Parameter parameter;
        int i;
        if (null == method.getParameters() || 0 == method.getParameters().size()) {
            return Collections.emptyList();
        }
        boolean hasEntity = false;
        ArrayList<Injectable> is = new ArrayList<Injectable>(method.getParameters().size());
        for (i = 0; i < method.getParameters().size(); ++i) {
            parameter = method.getParameters().get(i);
            if (Parameter.Source.ENTITY == parameter.getSource()) {
                hasEntity = true;
                is.add(this.processEntityParameter(parameter, method.getMethod().getParameterAnnotations()[i]));
                continue;
            }
            is.add(this.getInjectableProviderContext().getInjectable((AccessibleObject)method.getMethod(), parameter, ComponentScope.PerRequest));
        }
        if (hasEntity) {
            return is;
        }
        if (Collections.frequency(is, null) == 1) {
            i = is.lastIndexOf(null);
            parameter = method.getParameters().get(i);
            if (Parameter.Source.UNKNOWN == parameter.getSource() && !parameter.isQualified()) {
                Injectable ij = this.processEntityParameter(parameter, method.getMethod().getParameterAnnotations()[i]);
                is.set(i, ij);
            }
        }
        return is;
    }

    private Injectable processEntityParameter(Parameter parameter, Annotation[] annotations) {
        return new EntityInjectable(parameter.getParameterClass(), parameter.getParameterType(), annotations);
    }

    static final class EntityInjectable
    extends AbstractHttpContextInjectable<Object> {
        final Class<?> c;
        final Type t;
        final Annotation[] as;

        EntityInjectable(Class c, Type t, Annotation[] as) {
            this.c = c;
            this.t = t;
            this.as = as;
        }

        @Override
        public Object getValue(HttpContext context) {
            return context.getRequest().getEntity(this.c, this.t, this.as);
        }
    }
}

