"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parser = exports.transformAST = void 0;
const wrapAstTransformation_1 = __importDefault(require("../src/wrapAstTransformation"));
const vue_as_namespace_import_1 = require("./vue-as-namespace-import");
const import_composition_api_from_vue_1 = require("./import-composition-api-from-vue");
const new_vue_to_create_app_1 = require("./new-vue-to-create-app");
const root_prop_to_use_1 = require("./root-prop-to-use");
const remove_trivial_root_1 = require("./remove-trivial-root");
const remove_production_tip_1 = require("./remove-production-tip");
const remove_vue_use_1 = require("./remove-vue-use");
const remove_contextual_h_from_render_1 = require("./remove-contextual-h-from-render");
const remove_extraneous_import_1 = require("./remove-extraneous-import");
const transformAST = (context) => {
    vue_as_namespace_import_1.transformAST(context);
    import_composition_api_from_vue_1.transformAST(context);
    new_vue_to_create_app_1.transformAST(context);
    root_prop_to_use_1.transformAST(context, { rootPropName: 'store' });
    root_prop_to_use_1.transformAST(context, { rootPropName: 'router' });
    remove_trivial_root_1.transformAST(context);
    remove_production_tip_1.transformAST(context);
    // TODO:
    // should analyze the AST to get the default import of vue-router and vuex,
    // rather than hard-coding the names
    remove_vue_use_1.transformAST(context, { removablePlugins: ['VueRouter', 'Vuex'] });
    remove_contextual_h_from_render_1.transformAST(context);
    remove_extraneous_import_1.transformAST(context, { localBinding: 'Vue' });
    remove_extraneous_import_1.transformAST(context, { localBinding: 'Vuex' });
    remove_extraneous_import_1.transformAST(context, { localBinding: 'VueRouter' });
};
exports.transformAST = transformAST;
exports.default = wrapAstTransformation_1.default(exports.transformAST);
exports.parser = 'babylon';
