import type { NormalizedServerOptions, ProxyTargetDetailed, ServerOptions } from "./index";
import { type IncomingMessage as Request } from "node:http";
import type { Socket } from "node:net";
import * as urllib from "node:url";
export declare const isSSL: RegExp;
type Outgoing0 = ProxyTargetDetailed & ServerOptions;
export interface Outgoing extends Outgoing0 {
    rejectUnauthorized?: boolean;
    path?: string;
    headers: {
        [header: string]: string | string[] | undefined;
    } & {
        overwritten?: boolean;
    };
}
export declare function setupOutgoing(outgoing: Outgoing, options: NormalizedServerOptions, req: Request, forward?: "forward"): Outgoing;
export declare function setupSocket(socket: Socket): Socket;
export declare function getPort(req: Request): string;
export declare function hasEncryptedConnection(req: Request): boolean;
export declare function urlJoin(...args: string[]): string;
export declare function rewriteCookieProperty(header: string, config: Record<string, string>, property: string): string;
export declare function rewriteCookieProperty(header: string | string[], config: Record<string, string>, property: string): string | string[];
export declare function toURL(url: URL | urllib.Url | ProxyTargetDetailed | string | undefined): URL;
export {};
