/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import com.ibm.icu.util.ULocale;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.types.UTF8String;

public class CollationAwareUTF8String {
    private static final int MATCH_NOT_FOUND = -1;
    private static final int COMBINED_ASCII_SMALL_I_COMBINING_DOT = 6882055;
    private static final HashMap<Integer, String> codepointOneToManyTitleCaseLookupTable = new HashMap<Integer, String>(){
        {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i <= 0x10FFFF; ++i) {
                sb.appendCodePoint(i);
                String titleCase = UCharacter.toTitleCase((String)sb.toString(), null);
                if (titleCase.codePointCount(0, titleCase.length()) > 1) {
                    this.put(i, titleCase);
                }
                sb.setLength(0);
            }
        }
    };

    private static boolean lowercaseMatchFrom(UTF8String target, UTF8String lowercasePattern, int startPos) {
        return CollationAwareUTF8String.lowercaseMatchLengthFrom(target, lowercasePattern, startPos) != -1;
    }

    private static int lowercaseMatchLengthFrom(UTF8String target, UTF8String lowercasePattern, int startPos) {
        assert (startPos >= 0);
        Iterator<Integer> targetIterator = target.codePointIterator();
        Iterator<Integer> patternIterator = lowercasePattern.codePointIterator();
        for (int i = 0; i < startPos; ++i) {
            if (!targetIterator.hasNext()) {
                return -1;
            }
            targetIterator.next();
        }
        int matchLength = 0;
        int codePointBuffer = -1;
        while ((targetIterator.hasNext() || codePointBuffer != -1) && patternIterator.hasNext()) {
            int patternCodePoint;
            int targetCodePoint;
            if (codePointBuffer != -1) {
                targetCodePoint = codePointBuffer;
                codePointBuffer = -1;
            } else {
                targetCodePoint = CollationAwareUTF8String.getLowercaseCodePoint(targetIterator.next());
                if (targetCodePoint == 6882055) {
                    targetCodePoint = 105;
                    codePointBuffer = 775;
                }
                ++matchLength;
            }
            if (targetCodePoint == (patternCodePoint = patternIterator.next().intValue())) continue;
            return -1;
        }
        if (patternIterator.hasNext() || codePointBuffer != -1) {
            return -1;
        }
        return matchLength;
    }

    private static int lowercaseFind(UTF8String target, UTF8String lowercasePattern, int startPos) {
        assert (startPos >= 0);
        for (int i = startPos; i <= target.numChars(); ++i) {
            if (!CollationAwareUTF8String.lowercaseMatchFrom(target, lowercasePattern, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean lowercaseMatchUntil(UTF8String target, UTF8String lowercasePattern, int endPos) {
        return CollationAwareUTF8String.lowercaseMatchLengthUntil(target, lowercasePattern, endPos) != -1;
    }

    private static int lowercaseMatchLengthUntil(UTF8String target, UTF8String lowercasePattern, int endPos) {
        assert (endPos >= 0);
        Iterator<Integer> targetIterator = target.reverseCodePointIterator();
        Iterator<Integer> patternIterator = lowercasePattern.reverseCodePointIterator();
        for (int i = endPos; i < target.numChars(); ++i) {
            if (!targetIterator.hasNext()) {
                return -1;
            }
            targetIterator.next();
        }
        int matchLength = 0;
        int codePointBuffer = -1;
        while ((targetIterator.hasNext() || codePointBuffer != -1) && patternIterator.hasNext()) {
            int patternCodePoint;
            int targetCodePoint;
            if (codePointBuffer != -1) {
                targetCodePoint = codePointBuffer;
                codePointBuffer = -1;
            } else {
                targetCodePoint = CollationAwareUTF8String.getLowercaseCodePoint(targetIterator.next());
                if (targetCodePoint == 6882055) {
                    targetCodePoint = 775;
                    codePointBuffer = 105;
                }
                ++matchLength;
            }
            if (targetCodePoint == (patternCodePoint = patternIterator.next().intValue())) continue;
            return -1;
        }
        if (patternIterator.hasNext() || codePointBuffer != -1) {
            return -1;
        }
        return matchLength;
    }

    private static int lowercaseRFind(UTF8String target, UTF8String lowercasePattern, int endPos) {
        assert (endPos <= target.numChars());
        for (int i = endPos; i >= 0; --i) {
            if (!CollationAwareUTF8String.lowercaseMatchUntil(target, lowercasePattern, i)) continue;
            return i;
        }
        return -1;
    }

    public static int compareLowerCase(UTF8String left, UTF8String right) {
        if (left.isFullAscii() && right.isFullAscii()) {
            return CollationAwareUTF8String.compareLowerCaseAscii(left, right);
        }
        return CollationAwareUTF8String.compareLowerCaseSlow(left, right);
    }

    private static int compareLowerCaseAscii(UTF8String left, UTF8String right) {
        int leftBytes = left.numBytes();
        int rightBytes = right.numBytes();
        for (int curr = 0; curr < leftBytes && curr < rightBytes; ++curr) {
            int lowerRightByte;
            int lowerLeftByte = Character.toLowerCase(left.getByte(curr));
            if (lowerLeftByte == (lowerRightByte = Character.toLowerCase(right.getByte(curr)))) continue;
            return lowerLeftByte - lowerRightByte;
        }
        return leftBytes - rightBytes;
    }

    private static int compareLowerCaseSlow(UTF8String left, UTF8String right) {
        return CollationAwareUTF8String.lowerCaseCodePoints(left).binaryCompare(CollationAwareUTF8String.lowerCaseCodePoints(right));
    }

    public static UTF8String replace(UTF8String target, UTF8String search, UTF8String replace, int collationId) {
        if (target.numBytes() == 0 || search.numBytes() == 0) {
            return target;
        }
        String targetStr = target.toValidString();
        String searchStr = search.toValidString();
        StringSearch stringSearch = CollationFactory.getStringSearch(targetStr, searchStr, collationId);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int matchStart = stringSearch.first();
        while (matchStart != -1) {
            sb.append(targetStr, start, matchStart);
            sb.append(replace.toValidString());
            start = matchStart + stringSearch.getMatchLength();
            matchStart = stringSearch.next();
        }
        sb.append(targetStr, start, targetStr.length());
        return UTF8String.fromString(sb.toString());
    }

    public static UTF8String lowercaseReplace(UTF8String target, UTF8String search, UTF8String replace) {
        int start;
        if (target.numBytes() == 0 || search.numBytes() == 0) {
            return target;
        }
        UTF8String lowercaseSearch = CollationAwareUTF8String.lowerCaseCodePoints(search);
        int end = CollationAwareUTF8String.lowercaseFind(target, lowercaseSearch, start = 0);
        if (end == -1) {
            return target;
        }
        int increase = Math.max(0, replace.numBytes() - search.numBytes()) * 16;
        UTF8StringBuilder buf = new UTF8StringBuilder(target.numBytes() + increase);
        while (end != -1) {
            buf.append(target.substring(start, end));
            buf.append(replace);
            start = end + CollationAwareUTF8String.lowercaseMatchLengthFrom(target, lowercaseSearch, end);
            end = CollationAwareUTF8String.lowercaseFind(target, lowercaseSearch, start);
        }
        buf.append(target.substring(start, target.numChars()));
        return buf.build();
    }

    public static UTF8String toUpperCase(UTF8String target) {
        if (target.isFullAscii()) {
            return target.toUpperCaseAscii();
        }
        return CollationAwareUTF8String.toUpperCaseSlow(target);
    }

    private static UTF8String toUpperCaseSlow(UTF8String target) {
        return UTF8String.fromString(UCharacter.toUpperCase((String)target.toValidString()));
    }

    public static UTF8String toUpperCase(UTF8String target, int collationId) {
        if (target.isFullAscii()) {
            return target.toUpperCaseAscii();
        }
        return CollationAwareUTF8String.toUpperCaseSlow(target, collationId);
    }

    private static UTF8String toUpperCaseSlow(UTF8String target, int collationId) {
        ULocale locale = CollationFactory.fetchCollation(collationId).getCollator().getLocale(ULocale.ACTUAL_LOCALE);
        return UTF8String.fromString(UCharacter.toUpperCase((ULocale)locale, (String)target.toValidString()));
    }

    public static UTF8String toLowerCase(UTF8String target) {
        if (target.isFullAscii()) {
            return target.toLowerCaseAscii();
        }
        return CollationAwareUTF8String.toLowerCaseSlow(target);
    }

    private static UTF8String toLowerCaseSlow(UTF8String target) {
        return UTF8String.fromString(UCharacter.toLowerCase((String)target.toValidString()));
    }

    public static UTF8String toLowerCase(UTF8String target, int collationId) {
        if (target.isFullAscii()) {
            return target.toLowerCaseAscii();
        }
        return CollationAwareUTF8String.toLowerCaseSlow(target, collationId);
    }

    private static UTF8String toLowerCaseSlow(UTF8String target, int collationId) {
        ULocale locale = CollationFactory.fetchCollation(collationId).getCollator().getLocale(ULocale.ACTUAL_LOCALE);
        return UTF8String.fromString(UCharacter.toLowerCase((ULocale)locale, (String)target.toValidString()));
    }

    private static void appendLowercaseCodePoint(int codePoint, StringBuilder sb) {
        int lowercaseCodePoint = CollationAwareUTF8String.getLowercaseCodePoint(codePoint);
        if (lowercaseCodePoint == 6882055) {
            sb.appendCodePoint(105);
            sb.appendCodePoint(775);
        } else {
            sb.appendCodePoint(lowercaseCodePoint);
        }
    }

    private static int getLowercaseCodePoint(int codePoint) {
        if (codePoint == 304) {
            return 6882055;
        }
        if (codePoint == 962) {
            return 963;
        }
        return UCharacter.toLowerCase((int)codePoint);
    }

    public static UTF8String lowerCaseCodePoints(UTF8String target) {
        if (target.isFullAscii()) {
            return target.toLowerCaseAscii();
        }
        return CollationAwareUTF8String.lowerCaseCodePointsSlow(target);
    }

    private static UTF8String lowerCaseCodePointsSlow(UTF8String target) {
        Iterator<Integer> targetIter = target.codePointIterator(UTF8String.CodePointIteratorType.CODE_POINT_ITERATOR_MAKE_VALID);
        StringBuilder sb = new StringBuilder();
        while (targetIter.hasNext()) {
            CollationAwareUTF8String.appendLowercaseCodePoint(targetIter.next(), sb);
        }
        return UTF8String.fromString(sb.toString());
    }

    public static UTF8String toTitleCase(UTF8String target) {
        return UTF8String.fromString(UCharacter.toTitleCase((String)target.toValidString(), (BreakIterator)BreakIterator.getWordInstance()));
    }

    public static UTF8String toTitleCase(UTF8String target, int collationId) {
        ULocale locale = CollationFactory.fetchCollation(collationId).getCollator().getLocale(ULocale.ACTUAL_LOCALE);
        return UTF8String.fromString(UCharacter.toTitleCase((ULocale)locale, (String)target.toValidString(), (BreakIterator)BreakIterator.getWordInstance((ULocale)locale)));
    }

    public static UTF8String toTitleCaseICU(UTF8String source) {
        source = source.makeValid();
        UTF8StringBuilder sb = new UTF8StringBuilder();
        boolean isNewWord = true;
        boolean precededByCasedLetter = false;
        int len = source.numBytes();
        for (int offset = 0; offset < len; offset += UTF8String.numBytesForFirstByte(source.getByte(offset))) {
            int codepoint = source.codePointFrom(offset);
            CollationAwareUTF8String.appendTitleCasedCodepoint(sb, codepoint, isNewWord, precededByCasedLetter, source, offset);
            boolean bl = isNewWord = codepoint == 32;
            if (UCharacter.hasBinaryProperty((int)codepoint, (int)50)) continue;
            precededByCasedLetter = UCharacter.hasBinaryProperty((int)codepoint, (int)49);
        }
        return sb.build();
    }

    private static void appendTitleCasedCodepoint(UTF8StringBuilder sb, int codepoint, boolean isAfterAsciiSpace, boolean precededByCasedLetter, UTF8String source, int offset) {
        if (isAfterAsciiSpace) {
            CollationAwareUTF8String.appendCodepointToTitleCase(sb, codepoint);
            return;
        }
        if (codepoint == 931) {
            CollationAwareUTF8String.appendLowerCasedGreekCapitalSigma(sb, precededByCasedLetter, source, offset);
            return;
        }
        if (codepoint == 304) {
            sb.appendCodePoint(105);
            sb.appendCodePoint(775);
            return;
        }
        sb.appendCodePoint(UCharacter.toLowerCase((int)codepoint));
    }

    private static void appendLowerCasedGreekCapitalSigma(UTF8StringBuilder sb, boolean precededByCasedLetter, UTF8String source, int offset) {
        int codepoint = !CollationAwareUTF8String.followedByCasedLetter(source, offset) && precededByCasedLetter ? 962 : 963;
        sb.appendCodePoint(codepoint);
    }

    private static boolean followedByCasedLetter(UTF8String source, int offset) {
        offset += UTF8String.numBytesForFirstByte(source.getByte(offset));
        int len = source.numBytes();
        while (offset < len) {
            int codepoint = source.codePointFrom(offset);
            if (UCharacter.hasBinaryProperty((int)codepoint, (int)50)) {
                offset += UTF8String.numBytesForFirstByte(source.getByte(offset));
                continue;
            }
            return UCharacter.hasBinaryProperty((int)codepoint, (int)49);
        }
        return false;
    }

    private static void appendCodepointToTitleCase(UTF8StringBuilder sb, int codepoint) {
        String toTitleCase = codepointOneToManyTitleCaseLookupTable.get(codepoint);
        if (toTitleCase == null) {
            sb.appendCodePoint(UCharacter.toTitleCase((int)codepoint));
        } else {
            sb.append(toTitleCase);
        }
    }

    public static int findInSet(UTF8String match, UTF8String set, int collationId) {
        if (match.contains(UTF8String.fromString(","))) {
            return 0;
        }
        int byteIndex = 0;
        int charIndex = 0;
        int wordCount = 1;
        int lastComma = -1;
        while (byteIndex < set.numBytes()) {
            byte nextByte = set.getByte(byteIndex);
            if (nextByte == 44) {
                if (set.substring(lastComma + 1, charIndex).semanticEquals(match, collationId)) {
                    return wordCount;
                }
                lastComma = charIndex;
                ++wordCount;
            }
            byteIndex += UTF8String.numBytesForFirstByte(nextByte);
            ++charIndex;
        }
        if (set.substring(lastComma + 1, set.numBytes()).semanticEquals(match, collationId)) {
            return wordCount;
        }
        return 0;
    }

    public static boolean lowercaseContains(UTF8String target, UTF8String pattern) {
        if (target.isFullAscii() && pattern.isFullAscii()) {
            return target.toLowerCase().contains(pattern.toLowerCase());
        }
        return CollationAwareUTF8String.lowercaseIndexOfSlow(target, pattern, 0) >= 0;
    }

    public static boolean lowercaseStartsWith(UTF8String target, UTF8String pattern) {
        if (target.isFullAscii() && pattern.isFullAscii()) {
            return target.toLowerCase().startsWith(pattern.toLowerCase());
        }
        return CollationAwareUTF8String.lowercaseMatchFrom(target, CollationAwareUTF8String.lowerCaseCodePointsSlow(pattern), 0);
    }

    public static boolean lowercaseEndsWith(UTF8String target, UTF8String pattern) {
        if (target.isFullAscii() && pattern.isFullAscii()) {
            return target.toLowerCase().endsWith(pattern.toLowerCase());
        }
        return CollationAwareUTF8String.lowercaseMatchUntil(target, CollationAwareUTF8String.lowerCaseCodePointsSlow(pattern), target.numChars());
    }

    public static int lowercaseIndexOf(UTF8String target, UTF8String pattern, int start) {
        if (pattern.numChars() == 0) {
            return target.indexOfEmpty(start);
        }
        if (target.isFullAscii() && pattern.isFullAscii()) {
            return target.toLowerCase().indexOf(pattern.toLowerCase(), start);
        }
        return CollationAwareUTF8String.lowercaseIndexOfSlow(target, pattern, start);
    }

    private static int lowercaseIndexOfSlow(UTF8String target, UTF8String pattern, int start) {
        return CollationAwareUTF8String.lowercaseFind(target, CollationAwareUTF8String.lowerCaseCodePoints(pattern), start);
    }

    public static int indexOf(UTF8String target, UTF8String pattern, int start, int collationId) {
        if (pattern.numBytes() == 0) {
            return target.indexOfEmpty(start);
        }
        if (target.numBytes() == 0) {
            return -1;
        }
        String targetStr = target.toValidString();
        String patternStr = pattern.toValidString();
        if (targetStr.codePointCount(0, targetStr.length()) <= start) {
            return -1;
        }
        StringSearch stringSearch = CollationFactory.getStringSearch(targetStr, patternStr, collationId);
        stringSearch.setOverlapping(true);
        int startIndex = targetStr.offsetByCodePoints(0, start);
        stringSearch.setIndex(startIndex);
        int searchIndex = stringSearch.next();
        if (searchIndex == -1) {
            return -1;
        }
        int indexOf = targetStr.codePointCount(0, searchIndex);
        if (indexOf < start) {
            return -1;
        }
        return indexOf;
    }

    private static int findIndex(StringSearch stringSearch, int count) {
        assert (count >= 0);
        int index = 0;
        while (count > 0) {
            int nextIndex = stringSearch.next();
            if (nextIndex == -1) {
                return -1;
            }
            if (nextIndex == index && index != 0) {
                stringSearch.setIndex(stringSearch.getIndex() + stringSearch.getMatchLength());
                continue;
            }
            --count;
            index = nextIndex;
        }
        return index;
    }

    private static int findIndexReverse(StringSearch stringSearch, int count) {
        assert (count >= 0);
        int index = 0;
        while (count > 0) {
            index = stringSearch.previous();
            if (index == -1) {
                return -1;
            }
            --count;
        }
        return index + stringSearch.getMatchLength();
    }

    public static UTF8String subStringIndex(UTF8String string, UTF8String delimiter, int count, int collationId) {
        if (delimiter.numBytes() == 0 || count == 0 || string.numBytes() == 0) {
            return UTF8String.EMPTY_UTF8;
        }
        String str = string.toValidString();
        String delim = delimiter.toValidString();
        StringSearch stringSearch = CollationFactory.getStringSearch(str, delim, collationId);
        stringSearch.setOverlapping(true);
        if (count > 0) {
            int searchIndex = CollationAwareUTF8String.findIndex(stringSearch, count);
            if (searchIndex == -1) {
                return string;
            }
            if (searchIndex == 0) {
                return UTF8String.EMPTY_UTF8;
            }
            return UTF8String.fromString(str.substring(0, searchIndex));
        }
        int searchIndex = CollationAwareUTF8String.findIndexReverse(stringSearch, -count);
        if (searchIndex == -1) {
            return string;
        }
        if (searchIndex == str.length()) {
            return UTF8String.EMPTY_UTF8;
        }
        return UTF8String.fromString(str.substring(searchIndex));
    }

    public static UTF8String lowercaseSubStringIndex(UTF8String string, UTF8String delimiter, int count) {
        if (delimiter.numBytes() == 0 || count == 0) {
            return UTF8String.EMPTY_UTF8;
        }
        UTF8String lowercaseDelimiter = CollationAwareUTF8String.lowerCaseCodePoints(delimiter);
        if (count > 0) {
            int matchLength = -1;
            while (count > 0) {
                if ((matchLength = CollationAwareUTF8String.lowercaseFind(string, lowercaseDelimiter, matchLength + 1)) > -1) {
                    --count;
                    continue;
                }
                return string;
            }
            return string.substring(0, matchLength);
        }
        int matchLength = string.numChars() + 1;
        for (count = -count; count > 0; --count) {
            if ((matchLength = CollationAwareUTF8String.lowercaseRFind(string, lowercaseDelimiter, matchLength - 1)) > -1) {
                continue;
            }
            return string;
        }
        return string.substring(matchLength, string.numChars());
    }

    private static Map<Integer, String> getLowercaseDict(Map<String, String> dict) {
        HashMap<Integer, String> lowercaseDict = new HashMap<Integer, String>();
        for (Map.Entry<String, String> entry : dict.entrySet()) {
            int codePoint = entry.getKey().codePointAt(0);
            lowercaseDict.putIfAbsent(CollationAwareUTF8String.getLowercaseCodePoint(codePoint), entry.getValue());
        }
        return lowercaseDict;
    }

    public static UTF8String lowercaseTranslate(UTF8String input, Map<String, String> dict) {
        Iterator<Integer> inputIter = input.codePointIterator(UTF8String.CodePointIteratorType.CODE_POINT_ITERATOR_MAKE_VALID);
        Map<Integer, String> lowercaseDict = CollationAwareUTF8String.getLowercaseDict(dict);
        StringBuilder sb = new StringBuilder();
        int codePointBuffer = -1;
        while (inputIter.hasNext()) {
            String translated;
            int codePoint;
            if (codePointBuffer != -1) {
                codePoint = codePointBuffer;
                codePointBuffer = -1;
            } else {
                codePoint = inputIter.next();
            }
            if (lowercaseDict.containsKey(6882055) && codePoint == 105 && inputIter.hasNext()) {
                int nextCodePoint = inputIter.next();
                if (nextCodePoint == 775) {
                    codePoint = 6882055;
                } else {
                    codePointBuffer = nextCodePoint;
                }
            }
            if ((translated = lowercaseDict.get(CollationAwareUTF8String.getLowercaseCodePoint(codePoint))) == null) {
                sb.appendCodePoint(codePoint);
                continue;
            }
            if ("\u0000".equals(translated)) continue;
            sb.append(translated);
        }
        if (codePointBuffer != -1) {
            sb.appendCodePoint(codePointBuffer);
        }
        return UTF8String.fromString(sb.toString());
    }

    public static UTF8String translate(UTF8String input, Map<String, String> dict, int collationId) {
        String inputString = input.toValidString();
        StringCharacterIterator target = new StringCharacterIterator(inputString);
        Collator collator = CollationFactory.fetchCollation(collationId).getCollator();
        StringBuilder sb = new StringBuilder();
        int charIndex = 0;
        while (charIndex < inputString.length()) {
            int longestMatchLen = 0;
            String longestMatch = "";
            for (String key : dict.keySet()) {
                int matchLen;
                StringSearch stringSearch = new StringSearch(key, (CharacterIterator)target, (RuleBasedCollator)collator);
                stringSearch.setIndex(charIndex);
                int matchIndex = stringSearch.next();
                if (matchIndex != charIndex || (matchLen = stringSearch.getMatchLength()) <= longestMatchLen) continue;
                longestMatchLen = matchLen;
                longestMatch = key;
            }
            if (longestMatchLen == 0) {
                sb.append(inputString.charAt(charIndex));
                ++charIndex;
                continue;
            }
            if (!"\u0000".equals(dict.get(longestMatch))) {
                sb.append(dict.get(longestMatch));
            }
            charIndex += longestMatchLen;
        }
        return UTF8String.fromString(sb.toString());
    }

    public static UTF8String binaryTrim(UTF8String srcString, UTF8String trimString, int collationId) {
        return CollationAwareUTF8String.binaryTrimRight(srcString.trimLeft(trimString), trimString, collationId);
    }

    public static UTF8String lowercaseTrim(UTF8String srcString, UTF8String trimString, int collationId) {
        return CollationAwareUTF8String.lowercaseTrimRight(CollationAwareUTF8String.lowercaseTrimLeft(srcString, trimString), trimString, collationId);
    }

    public static UTF8String trim(UTF8String srcString, UTF8String trimString, int collationId) {
        return CollationAwareUTF8String.trimRight(CollationAwareUTF8String.trimLeft(srcString, trimString, collationId), trimString, collationId);
    }

    public static UTF8String lowercaseTrimLeft(UTF8String srcString, UTF8String trimString) {
        if (trimString == null) {
            return null;
        }
        HashSet<Integer> trimChars = new HashSet<Integer>();
        Iterator<Integer> trimIter = trimString.codePointIterator();
        while (trimIter.hasNext()) {
            trimChars.add(CollationAwareUTF8String.getLowercaseCodePoint(trimIter.next()));
        }
        int searchIndex = 0;
        int codePointBuffer = -1;
        Iterator<Integer> srcIter = srcString.codePointIterator();
        while (srcIter.hasNext()) {
            int codePoint;
            if (codePointBuffer != -1) {
                codePoint = codePointBuffer;
                codePointBuffer = -1;
            } else {
                codePoint = CollationAwareUTF8String.getLowercaseCodePoint(srcIter.next());
            }
            if (codePoint == 105 && srcIter.hasNext() && trimChars.contains(6882055)) {
                codePointBuffer = codePoint;
                codePoint = CollationAwareUTF8String.getLowercaseCodePoint(srcIter.next());
                if (codePoint == 775) {
                    searchIndex += 2;
                    codePointBuffer = -1;
                    continue;
                }
                if (!trimChars.contains(codePointBuffer)) break;
                ++searchIndex;
                codePointBuffer = codePoint;
                continue;
            }
            if (!trimChars.contains(codePoint)) break;
            ++searchIndex;
        }
        return searchIndex == 0 ? srcString : srcString.substring(searchIndex, srcString.numChars());
    }

    public static UTF8String trimLeft(UTF8String srcString, UTF8String trimString, int collationId) {
        int charIndex;
        int longestMatchLen;
        if (trimString == null) {
            return null;
        }
        if (srcString.numBytes() == 0) {
            return srcString;
        }
        HashMap<Integer, String> trimChars = new HashMap<Integer, String>();
        Iterator<Integer> trimIter = trimString.codePointIterator(UTF8String.CodePointIteratorType.CODE_POINT_ITERATOR_MAKE_VALID);
        while (trimIter.hasNext()) {
            int codePoint = trimIter.next();
            trimChars.putIfAbsent(codePoint, new String(Character.toChars(codePoint)));
        }
        String src = srcString.toValidString();
        StringCharacterIterator target = new StringCharacterIterator(src);
        Collator collator = CollationFactory.fetchCollation(collationId).getCollator();
        for (charIndex = 0; charIndex < src.length(); charIndex += longestMatchLen) {
            longestMatchLen = 0;
            for (String trim : trimChars.values()) {
                int matchLen;
                StringSearch stringSearch = new StringSearch(trim, (CharacterIterator)target, (RuleBasedCollator)collator);
                stringSearch.setIndex(charIndex);
                int matchIndex = stringSearch.next();
                if (matchIndex != charIndex || (matchLen = stringSearch.getMatchLength()) <= longestMatchLen) continue;
                longestMatchLen = matchLen;
            }
            if (longestMatchLen == 0) break;
        }
        return UTF8String.fromString(src.substring(charIndex));
    }

    public static UTF8String binaryTrimRight(UTF8String srcString, UTF8String trimString, int collationId) {
        int codePoint;
        if (trimString == null) {
            return null;
        }
        HashSet<Integer> trimChars = new HashSet<Integer>();
        Iterator<Integer> trimIter = trimString.codePointIterator();
        while (trimIter.hasNext()) {
            trimChars.add(trimIter.next());
        }
        int searchIndex = srcString.numChars();
        int codePointBuffer = -1;
        int lastNonSpaceCharacterIdx = srcString.numChars();
        if (!trimChars.contains(32) && CollationFactory.ignoresSpacesInTrimFunctions(collationId, false, true)) {
            int lastNonSpaceByteIdx;
            for (lastNonSpaceByteIdx = srcString.numBytes(); lastNonSpaceByteIdx > 0 && srcString.getByte(lastNonSpaceByteIdx - 1) == 32; --lastNonSpaceByteIdx) {
            }
            if (lastNonSpaceByteIdx == 0) {
                return srcString;
            }
            searchIndex = lastNonSpaceCharacterIdx = srcString.numChars() - (srcString.numBytes() - lastNonSpaceByteIdx);
        }
        Iterator<Integer> srcIter = srcString.reverseCodePointIterator();
        for (int i = lastNonSpaceCharacterIdx; i < srcString.numChars(); ++i) {
            srcIter.next();
        }
        while (srcIter.hasNext() && trimChars.contains(codePoint = srcIter.next().intValue())) {
            --searchIndex;
        }
        if (searchIndex == srcString.numChars()) {
            return srcString;
        }
        if (lastNonSpaceCharacterIdx == srcString.numChars()) {
            return srcString.substring(0, searchIndex);
        }
        return UTF8String.concat(srcString.substring(0, searchIndex), srcString.substring(lastNonSpaceCharacterIdx, srcString.numChars()));
    }

    public static UTF8String lowercaseTrimRight(UTF8String srcString, UTF8String trimString, int collationId) {
        if (trimString == null) {
            return null;
        }
        HashSet<Integer> trimChars = new HashSet<Integer>();
        Iterator<Integer> trimIter = trimString.codePointIterator();
        while (trimIter.hasNext()) {
            trimChars.add(CollationAwareUTF8String.getLowercaseCodePoint(trimIter.next()));
        }
        int searchIndex = srcString.numChars();
        int codePointBuffer = -1;
        int lastNonSpaceCharacterIdx = srcString.numChars();
        if (!trimChars.contains(32) && CollationFactory.ignoresSpacesInTrimFunctions(collationId, false, true)) {
            int lastNonSpaceByteIdx;
            for (lastNonSpaceByteIdx = srcString.numBytes(); lastNonSpaceByteIdx > 0 && srcString.getByte(lastNonSpaceByteIdx - 1) == 32; --lastNonSpaceByteIdx) {
            }
            if (lastNonSpaceByteIdx == 0) {
                return srcString;
            }
            searchIndex = lastNonSpaceCharacterIdx = srcString.numChars() - (srcString.numBytes() - lastNonSpaceByteIdx);
        }
        Iterator<Integer> srcIter = srcString.reverseCodePointIterator();
        for (int i = lastNonSpaceCharacterIdx; i < srcString.numChars(); ++i) {
            srcIter.next();
        }
        while (srcIter.hasNext()) {
            int codePoint;
            if (codePointBuffer != -1) {
                codePoint = codePointBuffer;
                codePointBuffer = -1;
            } else {
                codePoint = CollationAwareUTF8String.getLowercaseCodePoint(srcIter.next());
            }
            if (codePoint == 775 && srcIter.hasNext() && trimChars.contains(6882055)) {
                codePointBuffer = codePoint;
                codePoint = CollationAwareUTF8String.getLowercaseCodePoint(srcIter.next());
                if (codePoint == 105) {
                    searchIndex -= 2;
                    codePointBuffer = -1;
                    continue;
                }
                if (!trimChars.contains(codePointBuffer)) break;
                --searchIndex;
                codePointBuffer = codePoint;
                continue;
            }
            if (!trimChars.contains(codePoint)) break;
            --searchIndex;
        }
        if (searchIndex == srcString.numChars()) {
            return srcString;
        }
        if (lastNonSpaceCharacterIdx == srcString.numChars()) {
            return srcString.substring(0, searchIndex);
        }
        return UTF8String.concat(srcString.substring(0, searchIndex), srcString.substring(lastNonSpaceCharacterIdx, srcString.numChars()));
    }

    public static UTF8String trimRight(UTF8String srcString, UTF8String trimString, int collationId) {
        int lastNonSpacePosition;
        if (trimString == null) {
            return null;
        }
        if (srcString.numBytes() == 0) {
            return srcString;
        }
        HashMap<Integer, String> trimChars = new HashMap<Integer, String>();
        Iterator<Integer> trimIter = trimString.codePointIterator(UTF8String.CodePointIteratorType.CODE_POINT_ITERATOR_MAKE_VALID);
        while (trimIter.hasNext()) {
            int codePoint = trimIter.next();
            trimChars.putIfAbsent(codePoint, new String(Character.toChars(codePoint)));
        }
        String src = srcString.toValidString();
        StringCharacterIterator target = new StringCharacterIterator(src);
        Collator collator = CollationFactory.fetchCollation(collationId).getCollator();
        int charIndex = src.length();
        if (!trimChars.containsKey(32) && CollationFactory.ignoresSpacesInTrimFunctions(collationId, false, true)) {
            for (lastNonSpacePosition = src.length(); lastNonSpacePosition > 0 && src.charAt(lastNonSpacePosition - 1) == ' '; --lastNonSpacePosition) {
            }
            if (lastNonSpacePosition == 0) {
                return UTF8String.fromString(src);
            }
            charIndex = lastNonSpacePosition;
        }
        while (charIndex >= 0) {
            int longestMatchLen = 0;
            for (String trim : trimChars.values()) {
                StringSearch stringSearch = new StringSearch(trim, (CharacterIterator)target, (RuleBasedCollator)collator);
                stringSearch.setIndex(Math.max(charIndex - 3, 0));
                int matchIndex = stringSearch.next();
                int matchLen = stringSearch.getMatchLength();
                while (matchIndex != -1 && matchIndex < charIndex - matchLen) {
                    matchIndex = stringSearch.next();
                    matchLen = stringSearch.getMatchLength();
                }
                if (matchIndex != charIndex - matchLen || matchLen <= longestMatchLen) continue;
                longestMatchLen = matchLen;
            }
            if (longestMatchLen == 0) break;
            charIndex -= longestMatchLen;
        }
        if (charIndex == src.length()) {
            return srcString;
        }
        if (lastNonSpacePosition == srcString.numChars()) {
            return UTF8String.fromString(src.substring(0, charIndex));
        }
        return UTF8String.fromString(src.substring(0, charIndex) + src.substring(lastNonSpacePosition));
    }

    public static UTF8String[] splitSQL(UTF8String input, UTF8String delim, int limit, int collationId) {
        if (CollationFactory.fetchCollation((int)collationId).isUtf8BinaryType) {
            return input.split(delim, limit);
        }
        if (CollationFactory.fetchCollation((int)collationId).isUtf8LcaseType) {
            return CollationAwareUTF8String.lowercaseSplitSQL(input, delim, limit);
        }
        return CollationAwareUTF8String.icuSplitSQL(input, delim, limit, collationId);
    }

    public static UTF8String[] lowercaseSplitSQL(UTF8String string, UTF8String delimiter, int limit) {
        if (delimiter.numBytes() == 0) {
            return new UTF8String[]{string};
        }
        if (string.numBytes() == 0) {
            return new UTF8String[]{UTF8String.EMPTY_UTF8};
        }
        ArrayList<UTF8String> strings = new ArrayList<UTF8String>();
        UTF8String lowercaseDelimiter = CollationAwareUTF8String.lowerCaseCodePoints(delimiter);
        int startIndex = 0;
        int nextMatch = 0;
        while (nextMatch != -1 && (limit <= 0 || strings.size() != limit - 1)) {
            nextMatch = CollationAwareUTF8String.lowercaseFind(string, lowercaseDelimiter, startIndex);
            if (nextMatch == -1) continue;
            int nextMatchLength = CollationAwareUTF8String.lowercaseMatchLengthFrom(string, lowercaseDelimiter, nextMatch);
            strings.add(string.substring(startIndex, nextMatch));
            startIndex = nextMatch + nextMatchLength;
        }
        if (startIndex <= string.numChars()) {
            strings.add(string.substring(startIndex, string.numChars()));
        }
        if (limit == 0) {
            for (int i = strings.size() - 1; i >= 0 && ((UTF8String)strings.get(i)).numBytes() == 0; --i) {
                strings.remove(i);
            }
        }
        return strings.toArray(new UTF8String[0]);
    }

    public static UTF8String[] icuSplitSQL(UTF8String string, UTF8String delimiter, int limit, int collationId) {
        int end;
        if (delimiter.numBytes() == 0) {
            return new UTF8String[]{string};
        }
        if (string.numBytes() == 0) {
            return new UTF8String[]{UTF8String.EMPTY_UTF8};
        }
        ArrayList<UTF8String> strings = new ArrayList<UTF8String>();
        String target = string.toValidString();
        String pattern = delimiter.toValidString();
        StringSearch stringSearch = CollationFactory.getStringSearch(target, pattern, collationId);
        int start = 0;
        while ((end = stringSearch.next()) != -1 && (limit <= 0 || strings.size() != limit - 1)) {
            strings.add(UTF8String.fromString(target.substring(start, end)));
            start = end + stringSearch.getMatchLength();
        }
        if (start <= target.length()) {
            strings.add(UTF8String.fromString(target.substring(start)));
        }
        if (limit == 0) {
            for (int i = strings.size() - 1; i >= 0 && ((UTF8String)strings.get(i)).numBytes() == 0; --i) {
                strings.remove(i);
            }
        }
        return strings.toArray(new UTF8String[0]);
    }
}

