import type { NormalizedServerOptions, NormalizeProxyTarget, ProxyTarget } from "..";
import type { Request, ProxyResponse } from "./web-incoming";
export interface EditableResponse {
    statusCode: number;
    statusMessage: string;
    setHeader(key: string, value: string | string[]): this;
}
export declare function removeChunked(_req: Request, _res: EditableResponse, proxyRes: ProxyResponse): void;
export declare function setConnection(req: Request, _res: EditableResponse, proxyRes: ProxyResponse): void;
export declare function setRedirectHostRewrite(req: Request, _res: EditableResponse, proxyRes: ProxyResponse, options: NormalizedServerOptions & {
    target: NormalizeProxyTarget<ProxyTarget>;
}): void;
export declare function writeHeaders(_req: Request, res: EditableResponse, proxyRes: ProxyResponse, options: NormalizedServerOptions & {
    target: NormalizeProxyTarget<ProxyTarget>;
}): void;
export declare function writeStatusCode(_req: Request, res: EditableResponse, proxyRes: ProxyResponse): void;
export declare const OUTGOING_PASSES: {
    removeChunked: typeof removeChunked;
    setConnection: typeof setConnection;
    setRedirectHostRewrite: typeof setRedirectHostRewrite;
    writeHeaders: typeof writeHeaders;
    writeStatusCode: typeof writeStatusCode;
};
