<!-- markdownlint-disable  MD013 -->

<!-- wiki-title CA handler using EST protocol -->

# Generic EST protocol handler

The EST protocol handler is not bound to a specific CA server and implements the ['cacerts'](https://tools.ietf.org/html/rfc7030#section-2.1) and ['simpleenroll'](https://tools.ietf.org/html/rfc7030#section-2.2) calls as defined in [RFC7030](https://tools.ietf.org/html/rfc7030).

When using the handler please be aware of the following limitations:

- Authentication towards CA server is limited to ClientAuth as described in [RFC7030 section 3.3.2](https://tools.ietf.org/html/rfc7030#section-3.3.2) and HTTP-BASIC authentication as described in [RFC7030 section 3.2.3](https://tools.ietf.org/html/rfc7030#section-3.2.3)
- Revocation operations are not supported

The handler has been tested with the following EST implementation:

- [Insta Certifier](https://www.insta.fi/en/services/cyber-security/insta-certifier)
- EST reference implementation from [Cisco](http://testrfc7030.com/)

When using the Cisco test server make sure that the csr generated by your ACME client has a valid common-name. So enrollment by using [Certbot](https://certbot.eff.org/) is unfortunately not possible.

## Pre-requisites

- Certificate and key (in PEM format) used to authenticate acme2certifier towards EST server.
- CA certificate(s) in PEM format allowing to validate the certificate presented by the EST server. The CA certificates must be bundled into a single chain file as described in [RFC5246 section 7.4.2](https://tools.ietf.org/html/rfc5246#section-7.4.2)

## Installation and Configuration

- modify the server configuration (/acme_srv/acme_srv.cfg) and add the following parameters

```config
[CAhandler]
handler_file: examples/ca_handler/est_ca_handler.py
est_host: https://<ip>:<port>
est_client_key: <filename>
est_client_cert: <filename>
est_user: <user_name>
est_password: <password>
ca_bundle: <filename>
```

- est_host - URL of the EST server service
- est_host_variable - *optional* - name of the environment variable storing the est server url (a configured `est_host` parameter in acme_srv.cfg takes precedence)
- est_client_cert - Certificate used for TLS client-auth (in either PEM or PKCS#12 format)
- _either_: est_client_key - Private key of the certificate used for TLS client-auth (in pem-format)
- _or_: cert_passphrase - passphrase to access the pkcs#12 container
- _or_: cert_passphrase_variable - *optional* - name of the environment variable containing the cert_passphrase (a configured `cert_passphrase` parameter in acme_srv.cfg takes precedence)
- est_user - username for HTTP Basic Authentication
- est_user_variable - *optional* - name of the environment variable specifying the username for HTTP basic authentication (a configured `est_user` parameter in acme_srv.cfg takes precedence)
- est_password - password for HTTP Basic Authentication
- est_password_variable - *optional* - name of the environment variable specifying the user password for HTTP basic authentication (a configured `est_password` parameter in acme_srv.cfg takes precedence)
- ca_bundle - CA certificate bundle needed to validate the EST server certificate (acme_srv/est/ca_bundle.pem). Setting to False disables the certificate check
- allowed_domainlist - optional - list of domain-names allowed for enrollment in JSON format, for example: \["bar.local$, bar.foo.local\] (default: \[\])

Important: TLS Client Authentication and HTTP basic Authentication cannot be combined with each other

Below is the CA bundle needed to interoperate with EST reference implementation from [Cisco](http://testrfc7030.com/)

```pem
subject=CN = estExampleCA

issuer=CN = estExampleCA

-----BEGIN CERTIFICATE-----
MIIBUjCB+qADAgECAgkAsOsMO552gHQwCgYIKoZIzj0EAwIwFzEVMBMGA1UEAxMM
ZXN0RXhhbXBsZUNBMB4XDTE5MDgwOTIwMjUzOFoXDTI5MDgwNjIwMjUzOFowFzEV
MBMGA1UEAxMMZXN0RXhhbXBsZUNBMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE
e/4TlZtkyUP7v6F8GHdJLzjQvwahFDBj0L/oPfxf00oDHya5wsU2wT0cV7L70hPD
1n4dxhG/1JYX2UK10zflqKMvMC0wDAYDVR0TBAUwAwEB/zAdBgNVHQ4EFgQU2f8O
cSG4J8B3LPU203cyUF2DQCEwCgYIKoZIzj0EAwIDRwAwRAIgTgMXKl86lcQr3mTo
2uXbSZt8had163ft+9LBCqoxHiICIAfzhrTBBKSUxZQDeGIahr4OLQlS7GeSNGK1
ey5tEG+Z
-----END CERTIFICATE-----
```
