/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate;

import java.io.Serializable;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.statefulprocessor.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.ttl.StateTTL$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\u000e\u001d\u0001=B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u001dA\u0007A1A\u0005\n%Da! \u0001!\u0002\u0013Q\u0007b\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003\u0007\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u0003\u0017\u0001\u0001\u0015!\u0003\u0002\n!I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011\u0011\u0004\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\u001e!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003k\u0001A\u0011AA\u001f\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002`\u0001!\t!!\u0019\b\u000f\u0005%D\u0004#\u0001\u0002l\u001911\u0004\bE\u0001\u0003[Ba\u0001Y\f\u0005\u0002\u0005=\u0004bBA9/\u0011\u0005\u00111\u000f\u0005\n\u0003\u000f;\u0012\u0013!C\u0001\u0003\u0013\u0013\u0011c\u0015;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3s\u0015\tib$\u0001\nue\u0006t7OZ8s[^LG\u000f[:uCR,'BA\u0010!\u0003!\u0019H/\u0019;fMVd'BA\u0011#\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0002$I\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003K\u0019\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005AR5C\u0001\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u0006Q1.Z=F]\u000e|G-\u001a:\u0011\u0007er\u0004)D\u0001;\u0015\tYD(\u0001\u0005f]\u000e|G-\u001a:t\u0015\tid%\u0001\u0005dCR\fG._:u\u0013\ty$HA\tFqB\u0014Xm]:j_:,enY8eKJ\u0004\"AM!\n\u0005\t\u001b$aA!os\u0006Qa/\u00197F]\u000e|G-\u001a:\u0011\u0007\u00153\u0005*D\u0001'\u0013\t9eEA\u0004F]\u000e|G-\u001a:\u0011\u0005%SE\u0002\u0001\u0003\u0006\u0017\u0002\u0011\r\u0001\u0014\u0002\u0002-F\u0011Q\n\u0011\t\u0003e9K!aT\u001a\u0003\u000f9{G\u000f[5oO\u0006I1\u000f^1uK:\u000bW.\u001a\t\u0003%fs!aU,\u0011\u0005Q\u001bT\"A+\u000b\u0005Ys\u0013A\u0002\u001fs_>$h(\u0003\u0002Yg\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tA6'\u0001\u0004iCN$F\u000f\u001c\t\u0003eyK!aX\u001a\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"RA\u00193fM\u001e\u00042a\u0019\u0001I\u001b\u0005a\u0002\"B\u001c\u0006\u0001\u0004A\u0004\"B\"\u0006\u0001\u0004!\u0005\"\u0002)\u0006\u0001\u0004\t\u0006\"\u0002/\u0006\u0001\u0004i\u0016!D6fsN+'/[1mSj,'/F\u0001k!\rY'\u0010\u0011\b\u0003Ybt!!\\<\u000f\u000594hBA8v\u001d\t\u0001HO\u0004\u0002rg:\u0011AK]\u0005\u0002[%\u00111\u0006L\u0005\u0003S)J!a\n\u0015\n\u0005u2\u0013BA\u001e=\u0013\tI((A\tFqB\u0014Xm]:j_:,enY8eKJL!a\u001f?\u0003\u0015M+'/[1mSj,'O\u0003\u0002zu\u0005q1.Z=TKJL\u0017\r\\5{KJ\u0004\u0013\u0001\u0005<bY\u0016C\bO]3tg&|g.\u00128d+\t\t\t\u0001E\u0002:}!\u000b\u0011C^1m\u000bb\u0004(/Z:tS>tWI\\2!\u0003Iy'M\u001b+p%><8+\u001a:jC2L'0\u001a:\u0016\u0005\u0005%\u0001cA6{\u0011\u0006\u0019rN\u00196U_J{woU3sS\u0006d\u0017N_3sA\u0005!\"o\\<U_>\u0013'\u000eR3tKJL\u0017\r\\5{KJ,\"!!\u0005\u0011\t-\f\u0019\u0002S\u0005\u0004\u0003+a(\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018!\u0006:poR{wJ\u00196EKN,'/[1mSj,'\u000fI\u0001\u0013m\u0006dW/\u001a+U\u0019B\u0013xN[3di&|g.\u0006\u0002\u0002\u001eA!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$q\n1\"\u001a=qe\u0016\u001c8/[8og&!\u0011qEA\u0011\u0005A)fn]1gKB\u0013xN[3di&|g.A\nwC2,X\r\u0016+M!J|'.Z2uS>t\u0007%A\tf]\u000e|G-Z$s_V\u0004\u0018N\\4LKf$\"!a\f\u0011\t\u0005}\u0011\u0011G\u0005\u0005\u0003g\t\tCA\u0005V]N\fg-\u001a*po\u0006YQM\\2pI\u00164\u0016\r\\;f)\u0011\ty#!\u000f\t\r\u0005m\u0012\u00031\u0001I\u0003\u00151\u0018\r\\;f)\u0019\ty#a\u0010\u0002B!1\u00111\b\nA\u0002!Cq!a\u0011\u0013\u0001\u0004\t)%\u0001\u0007fqBL'/\u0019;j_:l5\u000fE\u00023\u0003\u000fJ1!!\u00134\u0005\u0011auN\\4\u0002\u0017\u0011,7m\u001c3f-\u0006dW/\u001a\u000b\u0004\u0011\u0006=\u0003bBA)'\u0001\u0007\u0011qF\u0001\u0004e><\u0018!\u00063fG>$W\r\u0016;m\u000bb\u0004\u0018N]1uS>tWj\u001d\u000b\u0005\u0003/\ni\u0006E\u00033\u00033\n)%C\u0002\u0002\\M\u0012aa\u00149uS>t\u0007bBA))\u0001\u0007\u0011qF\u0001\nSN,\u0005\u0010]5sK\u0012$R!XA2\u0003KBq!!\u0015\u0016\u0001\u0004\ty\u0003C\u0004\u0002hU\u0001\r!!\u0012\u0002!\t\fGo\u00195US6,7\u000f^1na6\u001b\u0018!E*uCR,G+\u001f9fg\u0016s7m\u001c3feB\u00111mF\n\u0003/E\"\"!a\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005U\u00141\u0010\u000b\u000b\u0003o\ni(a \u0002\u0004\u0006\u0015\u0005\u0003B2\u0001\u0003s\u00022!SA>\t\u0015Y\u0015D1\u0001M\u0011\u00159\u0014\u00041\u00019\u0011\u0019\u0019\u0015\u00041\u0001\u0002\u0002B!QIRA=\u0011\u0015\u0001\u0016\u00041\u0001R\u0011\u001da\u0016\u0004%AA\u0002u\u000bq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u000b\u0005\u0003\u0017\u000b\t+\u0006\u0002\u0002\u000e*\u001aQ,a$,\u0005\u0005E\u0005\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a'4\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\u000b)JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$Qa\u0013\u000eC\u00021\u0003")
public class StateTypesEncoder<V> {
    private final Encoder<V> valEncoder;
    private final String stateName;
    private final boolean hasTtl;
    private final ExpressionEncoder.Serializer<Object> keySerializer;
    private final ExpressionEncoder<V> valExpressionEnc;
    private final ExpressionEncoder.Serializer<V> objToRowSerializer;
    private final ExpressionEncoder.Deserializer<V> rowToObjDeserializer;
    private final UnsafeProjection valueTTLProjection;

    public static <V> boolean apply$default$4() {
        return StateTypesEncoder$.MODULE$.apply$default$4();
    }

    public static <V> StateTypesEncoder<V> apply(ExpressionEncoder<Object> keyEncoder, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        return StateTypesEncoder$.MODULE$.apply(keyEncoder, valEncoder, stateName, hasTtl);
    }

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        return this.keySerializer;
    }

    private ExpressionEncoder<V> valExpressionEnc() {
        return this.valExpressionEnc;
    }

    private ExpressionEncoder.Serializer<V> objToRowSerializer() {
        return this.objToRowSerializer;
    }

    private ExpressionEncoder.Deserializer<V> rowToObjDeserializer() {
        return this.rowToObjDeserializer;
    }

    private UnsafeProjection valueTTLProjection() {
        return this.valueTTLProjection;
    }

    public UnsafeRow encodeGroupingKey() {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(this.stateName);
        }
        return (UnsafeRow)this.keySerializer().apply(keyOption.get());
    }

    public UnsafeRow encodeValue(V value) {
        return (UnsafeRow)this.objToRowSerializer().apply(value);
    }

    public UnsafeRow encodeValue(V value, long expirationMs) {
        InternalRow objRow = this.objToRowSerializer().apply(value);
        return this.valueTTLProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{objRow, BoxesRunTime.boxToLong((long)expirationMs)})));
    }

    public V decodeValue(UnsafeRow row) {
        if (this.hasTtl) {
            return (V)this.rowToObjDeserializer().apply((InternalRow)row.getStruct(0, this.valEncoder.schema().length()));
        }
        return (V)this.rowToObjDeserializer().apply((InternalRow)row);
    }

    public Option<Object> decodeTtlExpirationMs(UnsafeRow row) {
        Predef$.MODULE$.assert(this.hasTtl);
        long expirationMs = row.getLong(1);
        if (expirationMs == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)expirationMs));
    }

    public boolean isExpired(UnsafeRow row, long batchTimestampMs) {
        Option<Object> expirationMs = this.decodeTtlExpirationMs(row);
        return expirationMs.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> StateTTL$.MODULE$.isExpired(x$1, batchTimestampMs));
    }

    public StateTypesEncoder(ExpressionEncoder<Object> keyEncoder, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        this.valEncoder = valEncoder;
        this.stateName = stateName;
        this.hasTtl = hasTtl;
        this.keySerializer = keyEncoder.createSerializer();
        this.valExpressionEnc = package$.MODULE$.encoderFor(valEncoder);
        this.objToRowSerializer = this.valExpressionEnc().createSerializer();
        this.rowToObjDeserializer = this.valExpressionEnc().resolveAndBind(this.valExpressionEnc().resolveAndBind$default$1(), this.valExpressionEnc().resolveAndBind$default$2()).createDeserializer();
        this.valueTTLProjection = UnsafeProjection$.MODULE$.create(TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(valEncoder.schema(), true));
    }
}

