/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import liquibase.GlobalConfiguration;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.InsertDataChange;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Data;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtil;
import org.apache.commons.lang3.StringUtils;

public class MissingDataChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Data.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class};
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{PrimaryKey.class, ForeignKey.class, Index.class};
    }

    @Override
    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl outputControl, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        Change[] changeArray;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Data data = (Data)missingObject;
            Table table = data.getTable();
            if (referenceDatabase.isLiquibaseObject(table)) {
                Change[] changeArray2 = null;
                return changeArray2;
            }
            String excludeObjects = outputControl.getExcludeObjects();
            String includeObjects = outputControl.getIncludeObjects();
            List<Object> columnNames = Collections.emptyList();
            JdbcConnection connection = (JdbcConnection)referenceDatabase.getConnection();
            Object sql = "SELECT * FROM " + referenceDatabase.escapeTableName(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName());
            if (StringUtils.isNotEmpty((CharSequence)excludeObjects) || StringUtils.isNotEmpty((CharSequence)includeObjects)) {
                String queryToRetrieveTableMetaDataOnly = (String)sql + " WHERE 1=0";
                stmt = connection.createStatement(1003, 1007);
                stmt.setFetchSize(1);
                rs = stmt.executeQuery(queryToRetrieveTableMetaDataOnly);
                boolean isCaseSensitive = referenceDatabase.isCaseSensitive();
                columnNames = this.identifyColumnNames(rs, excludeObjects, includeObjects, isCaseSensitive);
                if (columnNames.isEmpty()) {
                    throw new CommandExecutionException(String.format("No columns matched with excludeObjects '%s' / includeObjects '%s'", excludeObjects, includeObjects));
                }
                String replacement = "\"" + String.join((CharSequence)"\", \"", columnNames) + "\"";
                sql = ((String)sql).replace("*", replacement);
            }
            stmt = connection.createStatement(1003, 1007);
            stmt.setFetchSize(1000);
            rs = stmt.executeQuery((String)sql);
            if (columnNames.isEmpty()) {
                columnNames = new ArrayList();
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    columnNames.add(rs.getMetaData().getColumnName(i + 1));
                }
            }
            ArrayList<InsertDataChange> changes = new ArrayList<InsertDataChange>();
            while (rs.next()) {
                InsertDataChange change = new InsertDataChange();
                if (outputControl.getIncludeCatalog()) {
                    change.setCatalogName(table.getSchema().getCatalogName());
                }
                if (outputControl.getIncludeSchema()) {
                    change.setSchemaName(table.getSchema().getName());
                }
                change.setTableName(table.getName());
                for (int i = 0; i < columnNames.size(); ++i) {
                    ColumnConfig column = new ColumnConfig();
                    column.setName((String)columnNames.get(i));
                    Object value = JdbcUtil.getResultSetValue(rs, i + 1);
                    if (value == null) {
                        column.setValue(null);
                    } else if (value instanceof Number) {
                        column.setValueNumeric((Number)value);
                    } else if (value instanceof Boolean) {
                        column.setValueBoolean((Boolean)value);
                    } else if (value instanceof Date) {
                        column.setValueDate((Date)value);
                    } else if (value instanceof byte[]) {
                        if (referenceDatabase instanceof InformixDatabase) {
                            column.setValue(new String((byte[])value, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
                        }
                        column.setValueComputed(new DatabaseFunction("UNSUPPORTED FOR DIFF: BINARY DATA"));
                    } else {
                        column.setValue(value.toString());
                    }
                    change.addColumn(column);
                }
                changes.add(change);
            }
            changeArray = changes.toArray(EMPTY_CHANGE);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return changeArray;
    }

    private List<String> identifyColumnNames(ResultSet rs, String excludeObjects, String includeObjects, boolean isCaseSensitive) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        excludeObjects = this.extractColumnInfo(excludeObjects);
        includeObjects = this.extractColumnInfo(includeObjects);
        boolean withExcludeOnly = Objects.nonNull(excludeObjects);
        boolean withIncludeOnly = Objects.nonNull(includeObjects);
        Pattern pattern = null;
        if (withExcludeOnly) {
            pattern = Pattern.compile(excludeObjects, isCaseSensitive ? 0 : 2);
        }
        if (withIncludeOnly) {
            pattern = Pattern.compile(includeObjects, isCaseSensitive ? 0 : 2);
        }
        boolean noFiltering = null == pattern;
        for (int i = 1; i < rs.getMetaData().getColumnCount() + 1; ++i) {
            String columnName = rs.getMetaData().getColumnName(i);
            if (!noFiltering && (!withIncludeOnly || !pattern.matcher(columnName).matches()) && (!withExcludeOnly || pattern.matcher(columnName).matches())) continue;
            columnNames.add((String)(isCaseSensitive ? "\\\"" + columnName + "\\\"" : columnName));
        }
        return columnNames;
    }

    private String extractColumnInfo(String s) {
        if (null == s) {
            return null;
        }
        int commaPos = s.indexOf(44);
        int colPos = s.indexOf("column:") + 7;
        if (6 < colPos) {
            if (commaPos < colPos) {
                return s.substring(colPos).trim();
            }
            return s.substring(colPos, commaPos).trim();
        }
        if (s.contains("table:")) {
            return null;
        }
        return s.trim();
    }
}

